/*
 * Decompiled with CFR 0.152.
 */
package app.redwarp.gif.decoder.lzw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lapp/redwarp/gif/decoder/lzw/LzwDecoder;", "", "()V", "pixelStack", "", "prefix", "", "suffix", "decode", "", "imageData", "destination", "pixelCount", "", "decoder"})
public final class LzwDecoder {
    @NotNull
    private final short[] prefix = new short[4096];
    @NotNull
    private final byte[] suffix = new byte[4096];
    @NotNull
    private final byte[] pixelStack = new byte[4097];

    public final void decode(@NotNull byte[] imageData, @NotNull byte[] destination, int pixelCount) {
        int code;
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        short[] prefix = this.prefix;
        byte[] suffix = this.suffix;
        byte[] pixelStack = this.pixelStack;
        int dataIndex = 0;
        byte lzwMinimumCodeSize = imageData[dataIndex];
        int n = dataIndex;
        dataIndex = n + 1;
        int clear = 1 << lzwMinimumCodeSize;
        int endOfData = clear + 1;
        int codeSize = lzwMinimumCodeSize + 1;
        int bits = 0;
        int currentByte = 0;
        int blockSize = 0;
        int mask = (1 << codeSize) - 1;
        int available = clear + 2;
        int stackTop = 0;
        int first = 0;
        int oldCode = -1;
        int n2 = 0;
        if (n2 < clear) {
            do {
                code = n2++;
                prefix[code] = 0;
                suffix[code] = (byte)code;
            } while (n2 < clear);
        }
        int pixelIndex = 0;
        while (pixelIndex < pixelCount) {
            int n3;
            while (bits < codeSize) {
                if (blockSize == 0) {
                    blockSize = imageData[dataIndex] & 0xFF;
                    code = dataIndex;
                    dataIndex = code + 1;
                }
                currentByte += (imageData[dataIndex] & 0xFF) << bits;
                code = dataIndex;
                dataIndex = code + 1;
                bits += 8;
                code = blockSize;
                blockSize = code + -1;
            }
            code = currentByte & mask;
            bits -= codeSize;
            currentByte >>>= codeSize;
            if (code == clear) {
                codeSize = lzwMinimumCodeSize + 1;
                mask = (1 << codeSize) - 1;
                available = clear + 2;
                oldCode = -1;
                continue;
            }
            if (code > available || code == endOfData) break;
            if (oldCode == -1) {
                destination[pixelIndex] = suffix[code];
                int n4 = pixelIndex;
                pixelIndex = n4 + 1;
                oldCode = code;
                first = code;
                continue;
            }
            int initialCode = code;
            if (code >= available) {
                pixelStack[stackTop] = (byte)first;
                n3 = stackTop;
                stackTop = n3 + 1;
                code = oldCode;
            }
            while (code >= clear) {
                pixelStack[stackTop] = suffix[code];
                n3 = stackTop;
                stackTop = n3 + 1;
                code = prefix[code] & 0xFFFF;
            }
            first = suffix[code] & 0xFF;
            destination[pixelIndex] = (byte)first;
            n3 = pixelIndex;
            pixelIndex = n3 + 1;
            while (stackTop > 0) {
                n3 = stackTop;
                stackTop = n3 + -1;
                destination[pixelIndex] = pixelStack[stackTop];
                n3 = pixelIndex;
                pixelIndex = n3 + 1;
            }
            if (available < 4096) {
                prefix[available] = (short)oldCode;
                suffix[available] = (byte)first;
                n3 = available;
                if (((available = n3 + 1) & mask) == 0 && available < 4096) {
                    n3 = codeSize;
                    codeSize = n3 + 1;
                    mask += available;
                }
            }
            oldCode = initialCode;
        }
    }
}

