/*
 * Decompiled with CFR 0.152.
 */
package app.redwarp.gif.decoder.streams;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapp/redwarp/gif/decoder/streams/BufferedRandomAccessFile;", "Ljava/io/RandomAccessFile;", "file", "Ljava/io/File;", "mode", "", "bufferSize", "", "(Ljava/io/File;Ljava/lang/String;I)V", "buffer", "", "bufferEnd", "bufferPosition", "realPosition", "", "fillBuffer", "getFilePointer", "invalidate", "", "read", "b", "off", "len", "seek", "pos", "decoder"})
public final class BufferedRandomAccessFile
extends RandomAccessFile {
    private final int bufferSize;
    @NotNull
    private final byte[] buffer;
    private int bufferEnd;
    private int bufferPosition;
    private long realPosition;

    public BufferedRandomAccessFile(@NotNull File file, @NotNull String mode, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        super(file, mode);
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
    }

    public /* synthetic */ BufferedRandomAccessFile(File file, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        this(file, string, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        int n;
        if (this.bufferPosition >= this.bufferEnd && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.bufferEnd == 0) {
            n = -1;
        } else {
            void var1_1;
            int value = this.buffer[this.bufferPosition] & 0xFF;
            ++this.bufferPosition;
            n = var1_1;
        }
        return n;
    }

    private final int fillBuffer() throws IOException {
        int readCount = super.read(this.buffer, 0, this.bufferSize);
        if (readCount >= 0) {
            this.realPosition += (long)readCount;
            this.bufferEnd = readCount;
            this.bufferPosition = 0;
        }
        return readCount;
    }

    private final void invalidate() throws IOException {
        this.bufferEnd = 0;
        this.bufferPosition = 0;
        this.realPosition = super.getFilePointer();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int currentLength = len;
        int currentOffset = off;
        int totalRead = 0;
        while (true) {
            int leftover;
            if (currentLength <= (leftover = this.bufferEnd - this.bufferPosition)) {
                System.arraycopy(this.buffer, this.bufferPosition, b, currentOffset, currentLength);
                this.bufferPosition += currentLength;
                return totalRead + currentLength;
            }
            System.arraycopy(this.buffer, this.bufferPosition, b, currentOffset, leftover);
            totalRead += leftover;
            this.bufferPosition += leftover;
            if (this.fillBuffer() <= 0) break;
            currentOffset += leftover;
            currentLength -= leftover;
        }
        return totalRead == 0 ? -1 : totalRead;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.realPosition - (long)this.bufferEnd + (long)this.bufferPosition;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.realPosition - pos);
        boolean bl = 0 <= n ? n <= this.bufferEnd : false;
        if (bl) {
            this.bufferPosition = this.bufferEnd - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }
}

