/*
 * Decompiled with CFR 0.152.
 */
package app.redwarp.gif.decoder;

import app.redwarp.gif.decoder.InvalidGifException;
import app.redwarp.gif.decoder.descriptors.Dimension;
import app.redwarp.gif.decoder.descriptors.GifDescriptor;
import app.redwarp.gif.decoder.descriptors.GraphicControlExtension;
import app.redwarp.gif.decoder.descriptors.Header;
import app.redwarp.gif.decoder.descriptors.ImageData;
import app.redwarp.gif.decoder.descriptors.ImageDescriptor;
import app.redwarp.gif.decoder.descriptors.LogicalScreenDescriptor;
import app.redwarp.gif.decoder.descriptors.Position;
import app.redwarp.gif.decoder.descriptors.params.PixelPacking;
import app.redwarp.gif.decoder.streams.BufferedReplayInputStream;
import app.redwarp.gif.decoder.streams.RandomAccessFileInputStream;
import app.redwarp.gif.decoder.streams.ReplayInputStream;
import app.redwarp.gif.decoder.utils.InputStreamXKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\f\u0010\u0010J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00112\b\b\u0002\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\f\u0010\u0012J,\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0011H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0011H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0011H\u0002J\u001e\u0010!\u001a\u00020\u0016*\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010#\u001a\u00020$*\u00020\u0011H\u0002J\f\u0010%\u001a\u00020\u0004*\u00020\u0011H\u0002J\n\u0010&\u001a\u00020'*\u00020\tJ\f\u0010(\u001a\u00020)*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lapp/redwarp/gif/decoder/Parser;", "", "()V", "RANDOM_ACCESS_BUFFER_SIZE", "", "parse", "Lkotlin/Result;", "Lapp/redwarp/gif/decoder/descriptors/GifDescriptor;", "inputStream", "Lapp/redwarp/gif/decoder/streams/ReplayInputStream;", "pixelPacking", "Lapp/redwarp/gif/decoder/descriptors/params/PixelPacking;", "parse-gIAlu-s", "(Lapp/redwarp/gif/decoder/streams/ReplayInputStream;Lapp/redwarp/gif/decoder/descriptors/params/PixelPacking;)Ljava/lang/Object;", "file", "Ljava/io/File;", "(Ljava/io/File;Lapp/redwarp/gif/decoder/descriptors/params/PixelPacking;)Ljava/lang/Object;", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Lapp/redwarp/gif/decoder/descriptors/params/PixelPacking;)Ljava/lang/Object;", "parseLoop", "Lkotlin/Pair;", "", "Lapp/redwarp/gif/decoder/descriptors/ImageDescriptor;", "bufferedSource", "parseApplicationId", "", "parseColorTable", "", "colorCount", "parseGraphicControl", "Lapp/redwarp/gif/decoder/descriptors/GraphicControlExtension;", "parseHeader", "Lapp/redwarp/gif/decoder/descriptors/Header;", "parseImageDescriptor", "graphicControlExtension", "parseLogicalScreenDescriptor", "Lapp/redwarp/gif/decoder/descriptors/LogicalScreenDescriptor;", "parseLoopCount", "readImageData", "Lapp/redwarp/gif/decoder/descriptors/ImageData;", "skipSubBlocks", "", "decoder"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();
    private static final int RANDOM_ACCESS_BUFFER_SIZE = 0x100000;

    private Parser() {
    }

    @NotNull
    public final Object parse-gIAlu-s(@NotNull File file, @NotNull PixelPacking pixelPacking) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        return this.parse-gIAlu-s(new RandomAccessFileInputStream(file, 0x100000), pixelPacking);
    }

    public static /* synthetic */ Object parse-gIAlu-s$default(Parser parser, File file, PixelPacking pixelPacking, int n, Object object) {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse-gIAlu-s(file, pixelPacking);
    }

    @NotNull
    public final Object parse-gIAlu-s(@NotNull InputStream inputStream, @NotNull PixelPacking pixelPacking) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        return this.parse-gIAlu-s(new BufferedReplayInputStream(inputStream), pixelPacking);
    }

    public static /* synthetic */ Object parse-gIAlu-s$default(Parser parser, InputStream inputStream, PixelPacking pixelPacking, int n, Object object) {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse-gIAlu-s(inputStream, pixelPacking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object parse-gIAlu-s(ReplayInputStream inputStream, PixelPacking pixelPacking) {
        Object object;
        Parser parser = this;
        try {
            GifDescriptor gifDescriptor;
            Parser $this$parse_gIAlu_s_u24lambda_u2d1 = parser;
            boolean bl = false;
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                ReplayInputStream stream = (ReplayInputStream)closeable;
                boolean bl2 = false;
                Header header = $this$parse_gIAlu_s_u24lambda_u2d1.parseHeader(stream);
                LogicalScreenDescriptor logicalScreenDescriptor = $this$parse_gIAlu_s_u24lambda_u2d1.parseLogicalScreenDescriptor(stream);
                int[] globalColorTable = logicalScreenDescriptor.getHasGlobalColorTable() ? $this$parse_gIAlu_s_u24lambda_u2d1.parseColorTable(stream, logicalScreenDescriptor.getColorCount(), pixelPacking) : (int[])null;
                Pair<Integer, List<ImageDescriptor>> pair = $this$parse_gIAlu_s_u24lambda_u2d1.parseLoop(stream, pixelPacking);
                Integer loopCount = (Integer)pair.component1();
                List imageDescriptors = (List)pair.component2();
                gifDescriptor = new GifDescriptor(header, logicalScreenDescriptor, globalColorTable, imageDescriptors.size() <= 1 ? null : loopCount, imageDescriptors, stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)gifDescriptor);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    static /* synthetic */ Object parse-gIAlu-s$default(Parser parser, ReplayInputStream replayInputStream, PixelPacking pixelPacking, int n, Object object) {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse-gIAlu-s(replayInputStream, pixelPacking);
    }

    private final Header parseHeader(InputStream $this$parseHeader) throws InvalidGifException {
        Header header;
        String headerString = InputStreamXKt.readAsciiString($this$parseHeader, 6);
        if (Intrinsics.areEqual((Object)headerString, (Object)"GIF87a")) {
            header = Header.GIF87a;
        } else if (Intrinsics.areEqual((Object)headerString, (Object)"GIF89a")) {
            header = Header.GIF89a;
        } else {
            throw new InvalidGifException(headerString + " is not a valid GIF header");
        }
        return header;
    }

    private final LogicalScreenDescriptor parseLogicalScreenDescriptor(InputStream $this$parseLogicalScreenDescriptor) {
        Dimension dimension = new Dimension(InputStreamXKt.readUShortLe($this$parseLogicalScreenDescriptor), InputStreamXKt.readUShortLe($this$parseLogicalScreenDescriptor), null);
        byte hasGlobalColorTableMask = -128;
        byte packedFields = InputStreamXKt.readUByte($this$parseLogicalScreenDescriptor);
        boolean hasGlobalColorTable = UByte.constructor-impl((byte)((byte)(hasGlobalColorTableMask & packedFields))) == hasGlobalColorTableMask;
        int sizeOfGlobalColorTableMask = 7;
        byte sizeOfGlobalColorTable = UByte.constructor-impl((byte)((byte)(sizeOfGlobalColorTableMask & packedFields)));
        byte backgroundColorIndex = InputStreamXKt.readUByte($this$parseLogicalScreenDescriptor);
        return new LogicalScreenDescriptor(dimension, hasGlobalColorTable, sizeOfGlobalColorTable, hasGlobalColorTable ? UByte.box-impl((byte)backgroundColorIndex) : null, InputStreamXKt.readByte($this$parseLogicalScreenDescriptor), null);
    }

    private final int[] parseColorTable(InputStream $this$parseColorTable, int colorCount, PixelPacking pixelPacking) {
        int[] colors = new int[colorCount];
        for (int colorIndex = 0; colorIndex < colorCount; ++colorIndex) {
            int color;
            int n;
            byte r = InputStreamXKt.readByte($this$parseColorTable);
            byte g = InputStreamXKt.readByte($this$parseColorTable);
            byte b = InputStreamXKt.readByte($this$parseColorTable);
            switch (WhenMappings.$EnumSwitchMapping$0[pixelPacking.ordinal()]) {
                case 1: {
                    n = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                    break;
                }
                case 2: {
                    n = 0xFF000000 | b << 16 & 0xFF0000 | g << 8 & 0xFF00 | r & 0xFF;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            colors[colorIndex] = color = n;
        }
        return colors;
    }

    private final GraphicControlExtension parseGraphicControl(InputStream $this$parseGraphicControl) {
        byte blockSize = InputStreamXKt.readByte($this$parseGraphicControl);
        if (blockSize != 4) {
            throw new InvalidGifException("Block size of the graphic control should be 4");
        }
        byte packedField = InputStreamXKt.readByte($this$parseGraphicControl);
        int disposalMethodValue = packedField >> 2 & 7;
        boolean hasTransparency = (packedField & 1) == 1;
        short delayTime = UShort.constructor-impl((short)InputStreamXKt.readShortLe($this$parseGraphicControl));
        byte transparentColorIndex = InputStreamXKt.readByte($this$parseGraphicControl);
        byte terminator = InputStreamXKt.readByte($this$parseGraphicControl);
        if (terminator != 0) {
            throw new InvalidGifException("Terminator not properly set");
        }
        GraphicControlExtension.Disposal disposalMethod = disposalMethodValue >= GraphicControlExtension.Disposal.values().length ? GraphicControlExtension.Disposal.NOT_SPECIFIED : GraphicControlExtension.Disposal.values()[disposalMethodValue];
        return new GraphicControlExtension(disposalMethod, delayTime, hasTransparency ? Byte.valueOf(transparentColorIndex) : null, null);
    }

    private final String parseApplicationId(InputStream $this$parseApplicationId) {
        $this$parseApplicationId.skip(1L);
        return InputStreamXKt.readAsciiString($this$parseApplicationId, 11);
    }

    private final int parseLoopCount(InputStream $this$parseLoopCount) {
        $this$parseLoopCount.skip(2L);
        short count = InputStreamXKt.readShortLe($this$parseLoopCount);
        $this$parseLoopCount.skip(1L);
        return count;
    }

    private final void skipSubBlocks(InputStream $this$skipSubBlocks) {
        long subBlockSize = InputStreamXKt.readByte($this$skipSubBlocks);
        while (subBlockSize != 0L) {
            $this$skipSubBlocks.skip(subBlockSize);
            subBlockSize = InputStreamXKt.readByte($this$skipSubBlocks);
        }
    }

    private final Pair<Integer, List<ImageDescriptor>> parseLoop(ReplayInputStream bufferedSource, PixelPacking pixelPacking) {
        Integer loopCount = 0;
        GraphicControlExtension pendingGraphicControl = null;
        List imageDescriptors = new ArrayList();
        while (true) {
            byte by;
            if ((by = InputStreamXKt.readByte(bufferedSource)) == 44) {
                imageDescriptors.add(this.parseImageDescriptor(bufferedSource, pendingGraphicControl, pixelPacking));
                pendingGraphicControl = null;
                continue;
            }
            if (by == 59) break;
            if (by != 33) continue;
            byte by2 = InputStreamXKt.readByte(bufferedSource);
            if (by2 == -1) {
                String applicationId = this.parseApplicationId(bufferedSource);
                if (Intrinsics.areEqual((Object)applicationId, (Object)"NETSCAPE2.0") || Intrinsics.areEqual((Object)applicationId, (Object)"ANIMEXTS1.0")) {
                    loopCount = this.parseLoopCount(bufferedSource);
                    continue;
                }
                this.skipSubBlocks(bufferedSource);
                continue;
            }
            if (by2 == -7) {
                pendingGraphicControl = this.parseGraphicControl(bufferedSource);
                continue;
            }
            this.skipSubBlocks(bufferedSource);
        }
        return new Pair((Object)loopCount, (Object)imageDescriptors);
    }

    private final ImageDescriptor parseImageDescriptor(ReplayInputStream $this$parseImageDescriptor, GraphicControlExtension graphicControlExtension, PixelPacking pixelPacking) {
        byte colorTableFlagMask;
        Position position = new Position(InputStreamXKt.readUShortLe($this$parseImageDescriptor), InputStreamXKt.readUShortLe($this$parseImageDescriptor), null);
        Dimension dimension = new Dimension(InputStreamXKt.readUShortLe($this$parseImageDescriptor), InputStreamXKt.readUShortLe($this$parseImageDescriptor), null);
        byte packedFields = InputStreamXKt.readUByte($this$parseImageDescriptor);
        boolean usesLocalColorTable = UByte.constructor-impl((byte)((byte)(packedFields & (colorTableFlagMask = -128)))) == colorTableFlagMask;
        byte interlacedMask = 64;
        boolean isInterlaced = UByte.constructor-impl((byte)((byte)(packedFields & interlacedMask))) == interlacedMask;
        int sizeOfLocalTableMask = 7;
        int sizeOfLocalTable = UByte.constructor-impl((byte)((byte)(sizeOfLocalTableMask & packedFields))) & 0xFF;
        int colorCount = 1 << sizeOfLocalTable + 1;
        int[] localColorTable = usesLocalColorTable ? this.parseColorTable($this$parseImageDescriptor, colorCount, pixelPacking) : (int[])null;
        ImageData imageData = this.readImageData($this$parseImageDescriptor);
        return new ImageDescriptor(position, dimension, isInterlaced, localColorTable, imageData, graphicControlExtension);
    }

    @NotNull
    public final ImageData readImageData(@NotNull ReplayInputStream $this$readImageData) {
        Intrinsics.checkNotNullParameter((Object)$this$readImageData, (String)"<this>");
        int position = $this$readImageData.getPosition();
        int length = 1;
        $this$readImageData.skip(1L);
        while (true) {
            int blockSize = InputStreamXKt.readUByte($this$readImageData) & 0xFF;
            ++length;
            if (blockSize == 0) break;
            length += blockSize;
            $this$readImageData.skip(blockSize);
        }
        return new ImageData(position, length);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PixelPacking.values().length];
            nArray[PixelPacking.ARGB.ordinal()] = 1;
            nArray[PixelPacking.ABGR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

