/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import app.tozzi.exception.InvalidValueException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class GenericUtils {
    public static boolean containsSeparator(String string, String separator, String escapeSeparatorChar) {
        return escapeSeparatorChar != null ? Pattern.compile("(?<!" + Pattern.quote(escapeSeparatorChar) + ")" + Pattern.quote(separator)).matcher(string).find() : string.contains(separator);
    }

    public static boolean containsSeparatorWithEscape(String string, String separator, String escapeSeparatorChar) {
        return string.contains(escapeSeparatorChar + separator);
    }

    public static Integer loadInt(String value, int defaultInt) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultInt;
        }
    }

    public static List<String> split(String string, String separator, String escapeSeparatorChar) {
        String[] tokens;
        ArrayList<String> result = new ArrayList<String>();
        if (string == null || separator == null) {
            return result;
        }
        String regex = escapeSeparatorChar != null ? "(?<!" + Pattern.quote(escapeSeparatorChar) + ")" + Pattern.quote(separator) : separator;
        for (String token : tokens = string.split(regex)) {
            result.add(token.replace(escapeSeparatorChar + separator, separator));
        }
        if (string.endsWith(separator) && !string.endsWith(escapeSeparatorChar + separator)) {
            result.add("");
        }
        return result;
    }

    public static Number formatNumber(Number decimalNumber, String pattern, boolean bigDecimal) throws ParseException {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setParseBigDecimal(bigDecimal);
        return df.parse(df.format(decimalNumber));
    }

    public static Float parseFloat(String field, Object value) {
        if (value instanceof Float) {
            Float fl = (Float)value;
            return fl;
        }
        if (value instanceof String) {
            String fl = (String)value;
            return Float.valueOf(Float.parseFloat(fl));
        }
        throw new InvalidValueException("Invalid float number [" + String.valueOf(value) + "]", field, value);
    }

    public static Long parseLong(String field, Object value) {
        if (value instanceof Long) {
            Long ln = (Long)value;
            return ln;
        }
        if (value instanceof String) {
            String ln = (String)value;
            return Long.parseLong(ln);
        }
        throw new InvalidValueException("Invalid long number [" + String.valueOf(value) + "]", field, value);
    }

    public static Integer parseInteger(String field, Object value) {
        if (value instanceof Integer) {
            Integer in = (Integer)value;
            return in;
        }
        if (value instanceof String) {
            String in = (String)value;
            return Integer.parseInt(in);
        }
        throw new InvalidValueException("Invalid number [" + String.valueOf(value) + "]", field, value);
    }

    public static Double parseDouble(String field, Object value) {
        if (value instanceof Double) {
            Double db = (Double)value;
            return db;
        }
        if (value instanceof String) {
            String db = (String)value;
            return Double.parseDouble(db);
        }
        throw new InvalidValueException("Invalid double number [" + String.valueOf(value) + "]", field, value);
    }

    public static BigDecimal parseBigDecimal(String field, Object value) {
        if (value instanceof BigDecimal) {
            BigDecimal db = (BigDecimal)value;
            return db;
        }
        if (value instanceof String) {
            String db = (String)value;
            return new BigDecimal(db);
        }
        throw new InvalidValueException("Invalid big decimal number [" + String.valueOf(value) + "]", field, value);
    }

    public static boolean containsOnlyDigits(Object number) {
        String str;
        return number instanceof String && (str = (String)number).matches("\\d+");
    }

    public static boolean parseBoolean(String field, Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        if ("true".equalsIgnoreCase(value.toString())) {
            return true;
        }
        if ("false".equalsIgnoreCase(value.toString())) {
            return false;
        }
        throw new InvalidValueException("Invalid boolean value [" + String.valueOf(value) + "]", field, value);
    }

    public static Date parseDate(String field, Object value, String pattern) throws ParseException {
        if (value instanceof Date) {
            Date d = (Date)value;
            return d;
        }
        if (value instanceof String) {
            String str = (String)value;
            return new SimpleDateFormat(pattern).parse(str);
        }
        throw new InvalidValueException("Invalid date value [" + String.valueOf(value) + "]", field, value);
    }

    public static LocalDate parseLocalDate(String field, Object value, String pattern) {
        if (value instanceof LocalDate) {
            LocalDate ld = (LocalDate)value;
            return ld;
        }
        if (value instanceof String) {
            String str = (String)value;
            return LocalDate.parse(str, DateTimeFormatter.ofPattern(pattern));
        }
        throw new InvalidValueException("Invalid local date value [" + String.valueOf(value) + "]", field, value);
    }

    public static LocalTime parseLocalTime(String field, Object value, String pattern) {
        if (value instanceof LocalTime) {
            LocalTime lt = (LocalTime)value;
            return lt;
        }
        if (value instanceof String) {
            String str = (String)value;
            return LocalTime.parse(str, DateTimeFormatter.ofPattern(pattern));
        }
        throw new InvalidValueException("Invalid local time [" + String.valueOf(value) + "]", field, value);
    }

    public static LocalDateTime parseLocalDateTime(String field, Object value, String pattern) {
        if (value instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)value;
            return ldt;
        }
        if (value instanceof String) {
            String str = (String)value;
            return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(pattern));
        }
        throw new InvalidValueException("Invalid local date time value [" + String.valueOf(value) + "]", field, value);
    }

    public static OffsetTime parseOffsetTime(String field, Object value, String pattern) {
        if (value instanceof OffsetTime) {
            OffsetTime ot = (OffsetTime)value;
            return ot;
        }
        if (value instanceof String) {
            String str = (String)value;
            return OffsetTime.parse(str, DateTimeFormatter.ofPattern(pattern));
        }
        throw new InvalidValueException("Invalid offset time value [" + String.valueOf(value) + "]", field, value);
    }

    public static OffsetDateTime parseOffsetDateTime(String field, Object value, String pattern) {
        if (value instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)value;
            return odt;
        }
        if (value instanceof String) {
            String str = (String)value;
            return OffsetDateTime.parse(str, DateTimeFormatter.ofPattern(pattern));
        }
        throw new InvalidValueException("Invalid offset date time value [" + String.valueOf(value) + "]", field, value);
    }

    public static ZonedDateTime parseZonedDateTime(String field, Object value, String pattern) {
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)value;
            return zdt;
        }
        if (value instanceof String) {
            String str = (String)value;
            return ZonedDateTime.parse(str, DateTimeFormatter.ofPattern(pattern));
        }
        throw new InvalidValueException("Invalid zoned date time value [" + String.valueOf(value) + "]", field, value);
    }
}

