/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import app.tozzi.exception.JPASearchException;
import app.tozzi.model.JPASearchOperatorFilter;
import app.tozzi.model.JPASearchOperatorGroup;
import app.tozzi.model.JPASearchPaginationFilter;
import app.tozzi.model.JPASearchSortType;
import app.tozzi.model.input.JPASearchInput;
import app.tozzi.util.GenericUtils;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class JPASearchUtils {
    public static JPASearchInput EMPTY_INPUT = new JPASearchInput();
    private static final String SEPARATOR = ",";
    private static final String ESCAPE_SEPARATOR_CHAR = "/";
    private static final String IGNORE_CASE_OPTION_IDENTIFIER = "#i";
    private static final String NEGATION_OPTION_IDENTIFIER = "#n";
    private static final String TRIM_OPTION_IDENTIFIER = "#t";
    private static final String PROJECTION_KEY = "selections";

    public static JPASearchInput toObject(Map<String, String> filters, boolean processPaginationOptions, boolean processSortOption, boolean processProjection) {
        if (filters == null || filters.isEmpty()) {
            if (processSortOption) {
                throw new JPASearchException("Invalid sort filters");
            }
            if (processPaginationOptions) {
                throw new JPASearchException("Invalid pagination filters");
            }
            if (processProjection) {
                throw new JPASearchException("Invalid projection selection");
            }
            return EMPTY_INPUT;
        }
        JPASearchInput res = new JPASearchInput();
        res.setFilter(new JPASearchInput.RootFilter());
        res.getFilter().setOperator(JPASearchOperatorGroup.AND.getValue());
        filters.entrySet().stream().filter(e -> e.getValue() != null && e.getKey() != null && !((String)e.getKey()).isBlank()).forEach(e -> {
            JPASearchInput.FieldFilter filter;
            if ((processPaginationOptions || processSortOption) && (((String)e.getKey()).charAt(0) == '_' && JPASearchPaginationFilter.keys().contains(((String)e.getKey()).substring(1)) || ((String)e.getKey()).endsWith("_" + JPASearchPaginationFilter.SORT.getValue()))) {
                if (res.getOptions() == null) {
                    res.setOptions(new JPASearchInput.JPASearchOptions());
                }
                JPASearchPaginationFilter paginationFilter = ((String)e.getKey()).endsWith("_" + JPASearchPaginationFilter.SORT.getValue()) ? JPASearchPaginationFilter.SORT : JPASearchPaginationFilter.load(((String)e.getKey()).substring(1));
                switch (paginationFilter) {
                    case LIMIT: {
                        res.getOptions().setPageSize(GenericUtils.loadInt((String)e.getValue(), processPaginationOptions ? 0 : -1));
                        break;
                    }
                    case OFFSET: {
                        res.getOptions().setPageOffset(GenericUtils.loadInt((String)e.getValue(), 0));
                        break;
                    }
                    case SORT: {
                        res.getOptions().setSortKey(((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("_")));
                        res.getOptions().setSortDesc(JPASearchSortType.DESC.name().equalsIgnoreCase((String)e.getValue()));
                    }
                }
                return;
            }
            if (processProjection && ((String)e.getKey()).equals(PROJECTION_KEY)) {
                if (res.getOptions() == null) {
                    res.setOptions(new JPASearchInput.JPASearchOptions());
                }
                res.getOptions().setSelections(GenericUtils.split((String)e.getValue(), SEPARATOR, null));
                return;
            }
            String field = ((String)e.getKey()).contains("_") ? ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("_")) : (String)e.getKey();
            String operator = ((String)e.getKey()).contains("_") ? ((String)e.getKey()).substring(((String)e.getKey()).lastIndexOf("_") + 1) : JPASearchOperatorFilter.EQ.getValue();
            boolean ignoreCase = false;
            if (operator.contains(IGNORE_CASE_OPTION_IDENTIFIER)) {
                ignoreCase = true;
                operator = operator.replace(IGNORE_CASE_OPTION_IDENTIFIER, "");
            }
            boolean negation = false;
            if (operator.contains(NEGATION_OPTION_IDENTIFIER)) {
                negation = true;
                operator = operator.replace(NEGATION_OPTION_IDENTIFIER, "");
            }
            boolean trim = false;
            if (operator.contains(TRIM_OPTION_IDENTIFIER)) {
                trim = true;
                operator = operator.replace(TRIM_OPTION_IDENTIFIER, "");
            }
            if (GenericUtils.containsSeparator((String)e.getValue(), SEPARATOR, ESCAPE_SEPARATOR_CHAR)) {
                filter = new JPASearchInput.FilterMultipleValues();
                ((JPASearchInput.FilterMultipleValues)filter).setValues(new ArrayList<Object>(GenericUtils.split((String)e.getValue(), SEPARATOR, ESCAPE_SEPARATOR_CHAR)));
            } else if (GenericUtils.containsSeparatorWithEscape((String)e.getValue(), SEPARATOR, ESCAPE_SEPARATOR_CHAR)) {
                filter = new JPASearchInput.FilterSingleValue();
                ((JPASearchInput.FilterSingleValue)filter).setValue(((String)e.getValue()).replace(ESCAPE_SEPARATOR_CHAR, ""));
            } else {
                filter = new JPASearchInput.FilterSingleValue();
                ((JPASearchInput.FilterSingleValue)filter).setValue(e.getValue());
            }
            filter.setKey(field);
            filter.setOperator(operator);
            if (ignoreCase || negation || trim) {
                filter.setOptions(new JPASearchInput.JPASearchFilterOptions());
                filter.getOptions().setIgnoreCase(ignoreCase);
                filter.getOptions().setNegate(negation);
                filter.getOptions().setTrim(trim);
            }
            if (res.getFilter().getFilters() == null) {
                res.getFilter().setFilters(new ArrayList<JPASearchInput.Filter>());
            }
            res.getFilter().getFilters().add(filter);
        });
        return res;
    }

    public static Predicate[] toPredicates(Expression<Boolean>[] values) {
        Predicate[] predicates = new Predicate[values.length];
        for (int i = 0; i < values.length; ++i) {
            predicates[i] = (Predicate)values[i];
        }
        return predicates;
    }

    public static <E> Root<E> fetchManagement(Map<String, JoinType> fetchMap, Root<E> root) {
        if (fetchMap != null) {
            fetchMap = new TreeMap<String, JoinType>(fetchMap);
            ArrayList doneFetches = new ArrayList();
            fetchMap.forEach((k, v) -> {
                if (k.contains(".")) {
                    Fetch fetch;
                    Iterator it = Arrays.stream(k.split("\\.")).iterator();
                    String f = (String)it.next();
                    StringBuilder tempPath = new StringBuilder(f);
                    if (!doneFetches.contains(f)) {
                        fetch = root.fetch(f, v);
                        doneFetches.add(f);
                    } else {
                        fetch = root.getFetches().stream().filter(rf -> rf.getAttribute().getName().equals(f)).findAny().orElseThrow();
                    }
                    while (it.hasNext()) {
                        String f1 = (String)it.next();
                        tempPath.append(".").append(f1);
                        if (!doneFetches.contains(tempPath.toString())) {
                            fetch = fetch.fetch(f1, v);
                            doneFetches.add(tempPath.toString());
                            continue;
                        }
                        fetch = fetch.getFetches().stream().filter(rf -> rf.getAttribute().getName().equals(f1)).findAny().orElseThrow();
                    }
                } else if (!doneFetches.contains(k)) {
                    root.fetch(k, v);
                    doneFetches.add(k);
                }
            });
        }
        return root;
    }

    public static <T> Expression<T> getPath(Root<?> root, String k) {
        if (k.contains(".")) {
            Path path = null;
            for (String f : k.split("\\.")) {
                path = path == null ? root.get(f) : path.get(f);
            }
            return path;
        }
        return root.get(k);
    }
}

