/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.core;

import app.tozzi.annotation.Searchable;
import app.tozzi.annotation.Tag;
import app.tozzi.exception.InvalidFieldException;
import app.tozzi.model.FieldDescriptor;
import app.tozzi.model.JPASearchType;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class JPASearchCoreFieldProcessor {
    protected static FieldDescriptor processField(String field, Map<String, String> entityFieldMap, Map<String, Pair<Searchable, Field>> searchableFields, boolean throwIfFieldNotExists, boolean throwsIfNotSortable, boolean checkSortable) {
        Class<?> type;
        Searchable s;
        HashMap tagMap = new HashMap();
        searchableFields.entrySet().stream().filter(e -> ((Searchable)((Pair)e.getValue()).getKey()).tags() != null && ((Searchable)((Pair)e.getValue()).getKey()).tags().length > 0).forEach(e -> Stream.of(((Searchable)((Pair)e.getValue()).getKey()).tags()).forEach(t -> tagMap.put(t.fieldKey(), Pair.of((Object)((Pair)e.getValue()), (Object)t))));
        if (!searchableFields.containsKey(field) && !tagMap.containsKey(field)) {
            if (throwIfFieldNotExists) {
                throw new InvalidFieldException("Field [" + field + "] does not exists or not sortable", field);
            }
            return null;
        }
        if (searchableFields.containsKey(field) && (s = (Searchable)searchableFields.get(field).getKey()).tags().length > 0 && Stream.of(s.tags()).noneMatch(t -> t.fieldKey().equals(field))) {
            throw new InvalidFieldException("Field [" + field + "] does not exists or not sortable", field);
        }
        Searchable searchable = searchableFields.containsKey(field) ? (Searchable)searchableFields.get(field).getKey() : (Searchable)((Pair)((Pair)tagMap.get(field)).getKey()).getKey();
        Class<?> clazz = type = searchableFields.containsKey(field) ? ((Field)searchableFields.get(field).getValue()).getType() : ((Field)((Pair)((Pair)tagMap.get(field)).getKey()).getValue()).getType();
        if (checkSortable && !searchable.sortable()) {
            if (throwsIfNotSortable) {
                throw new InvalidFieldException("Field [" + field + "] is not sortable", field);
            }
            return null;
        }
        String entityField = entityFieldMap != null && entityFieldMap.containsKey(field) ? entityFieldMap.get(field) : (tagMap.containsKey(field) ? (((Tag)((Pair)tagMap.get(field)).getRight()).entityFieldKey() != null && !((Tag)((Pair)tagMap.get(field)).getRight()).entityFieldKey().isBlank() ? ((Tag)((Pair)tagMap.get(field)).getRight()).entityFieldKey() : field) : (searchable.entityFieldKey() != null && !searchable.entityFieldKey().isBlank() ? searchable.entityFieldKey() : field));
        return new FieldDescriptor(field, searchable, JPASearchType.UNTYPED.equals((Object)searchable.targetType()) ? JPASearchType.load(type, JPASearchType.STRING) : searchable.targetType(), entityField);
    }
}

