/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.core;

import app.tozzi.annotation.Projectable;
import app.tozzi.annotation.Searchable;
import app.tozzi.core.JPASearchCore;
import app.tozzi.exception.InvalidFieldException;
import app.tozzi.exception.JPASearchException;
import app.tozzi.model.JPAEntityId;
import app.tozzi.model.ProjectionDescriptor;
import app.tozzi.model.input.JPASearchInput;
import app.tozzi.util.JPASearchUtils;
import app.tozzi.util.ReflectionUtils;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;

public class JPAProjectionProcessor {
    public static <E> ProjectionDescriptor getQuery(@NonNull JPASearchInput input, @NonNull Class<?> type, @NonNull Class<E> entityClass, @NonNull CriteriaBuilder criteriaBuilder, @NonNull Map<Class<?>, Map<String, Field>> idFields, boolean processSortOptions, Map<String, JoinType> fetchMap, Map<String, String> entityFieldMap, Map<String, Pair<Searchable, Field>> searchableFields, boolean overrideJoins, Map<String, JoinType> overrideJoinTypes) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        if (criteriaBuilder == null) {
            throw new NullPointerException("criteriaBuilder is marked non-null but is null");
        }
        if (idFields == null) {
            throw new NullPointerException("idFields is marked non-null but is null");
        }
        if (input.getOptions() == null) {
            throw new JPASearchException("Invalid projection");
        }
        Specification specification = JPASearchCore.specification(input.getFilter(), ReflectionUtils.getAllSearchableFields(type), fetchMap, entityFieldMap);
        CriteriaQuery query = criteriaBuilder.createTupleQuery();
        Root root = query.from(entityClass);
        Predicate predicate = specification.toPredicate(root, query, criteriaBuilder);
        List<Selection<?>> selections = JPAProjectionProcessor.loadSelection(input.getOptions().getSelections(), root, entityClass, ReflectionUtils.getAllProjectableFields(type), idFields, true, overrideJoins, overrideJoinTypes);
        CriteriaQuery criteriaQuery = query.multiselect(selections);
        if (predicate != null) {
            criteriaQuery = query.where((Expression)predicate);
        }
        if (processSortOptions) {
            Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, entityFieldMap);
            criteriaQuery = criteriaQuery.orderBy(QueryUtils.toOrders((Sort)sort, (From)root, (CriteriaBuilder)criteriaBuilder));
        }
        return new ProjectionDescriptor((CriteriaQuery<Tuple>)criteriaQuery, selections, input, root);
    }

    public static List<Selection<?>> loadSelection(List<String> fields, Root<?> root, Class<?> entityClass, Map<String, Pair<Projectable, Field>> projectableFields, Map<Class<?>, Map<String, Field>> idFields, boolean throwsIfNotExists, boolean overrideJoins, Map<String, JoinType> overrideJoinTypes) {
        if (fields == null || fields.isEmpty()) {
            throw new JPASearchException("Invalid projection");
        }
        if (idFields == null || idFields.isEmpty()) {
            throw new JPASearchException("Invalid entity");
        }
        Pair<List<Selection<?>>, Map<String, Join<?, ?>>> selectionsAndJoins = JPAProjectionProcessor.loadSelectionsFromFields(fields, root, entityClass, projectableFields, idFields, throwsIfNotExists, overrideJoins, overrideJoinTypes);
        List selections = (List)selectionsAndJoins.getLeft();
        Map joins = (Map)selectionsAndJoins.getRight();
        return JPAProjectionProcessor.loadCompleteSelections(selections, joins, root, entityClass, idFields);
    }

    private static Pair<List<Selection<?>>, Map<String, Join<?, ?>>> loadSelectionsFromFields(List<String> fields, Root<?> root, Class<?> entityClass, Map<String, Pair<Projectable, Field>> projectableFields, Map<Class<?>, Map<String, Field>> idFields, boolean throwsIfNotExists, boolean overrideJoins, Map<String, JoinType> overrideJoinTypes) {
        LinkedHashMap joins = new LinkedHashMap();
        return Pair.of((Object)fields.stream().filter(f -> {
            if (!projectableFields.containsKey(f)) {
                if (throwsIfNotExists) {
                    throw new InvalidFieldException("Field [" + f + "] does not exist or is not projectable", (String)f);
                }
                return false;
            }
            return true;
        }).map(f -> {
            String parentPath;
            Projectable projection = (Projectable)((Pair)projectableFields.get(f)).getLeft();
            String key = projection.entityFieldKey() != null && !projection.entityFieldKey().isBlank() ? projection.entityFieldKey() : f;
            int lastDotIndex = key.lastIndexOf(46);
            String string = parentPath = lastDotIndex == -1 ? key : key.substring(0, lastDotIndex);
            if (!overrideJoins || overrideJoinTypes != null && overrideJoinTypes.isEmpty()) {
                idFields.entrySet().stream().filter(e -> !((Class)e.getKey()).equals(entityClass)).flatMap(e -> ((Map)e.getValue()).keySet().stream()).map(k -> {
                    int ldi = k.lastIndexOf(46);
                    String pp = ldi == -1 ? k : k.substring(0, ldi);
                    return Pair.of((Object)k, (Object)pp);
                }).filter(p -> ((String)p.getRight()).equals(parentPath)).map(Pair::getLeft).forEach(k -> {
                    String[] path = key.split("\\.");
                    StringBuilder completeCurrentPath = new StringBuilder();
                    for (int i = 0; i < path.length - 1; ++i) {
                        Join join;
                        String cp = path[i];
                        String previousPath = i > 0 ? path[i - 1] : "";
                        String completePreviousPath = completeCurrentPath.toString();
                        if (i > 0) {
                            completeCurrentPath.append(".");
                        }
                        completeCurrentPath.append(path[i]);
                        if (!overrideJoins) {
                            if (joins.containsKey(completeCurrentPath.toString())) continue;
                            join = previousPath.isBlank() ? root.join(cp, JoinType.LEFT) : (Join)joins.get(completePreviousPath);
                            joins.put(completeCurrentPath.toString(), previousPath.isBlank() ? join : join.join(cp, JoinType.LEFT));
                            continue;
                        }
                        if (!overrideJoinTypes.containsKey(completeCurrentPath.toString()) || joins.containsKey(completeCurrentPath.toString())) continue;
                        join = previousPath.isBlank() ? root.join(cp, JoinType.LEFT) : (Join)joins.get(completePreviousPath);
                        joins.put(completeCurrentPath.toString(), previousPath.isBlank() ? join : join.join(cp, (JoinType)overrideJoinTypes.get(completeCurrentPath.toString())));
                    }
                });
            }
            String currentPath = lastDotIndex == -1 ? key : key.substring(lastDotIndex + 1);
            return joins.containsKey(parentPath) ? ((Join)joins.get(parentPath)).get(currentPath).alias(key) : JPASearchUtils.getPath(root, key).alias(key);
        }).collect(Collectors.toCollection(ArrayList::new)), joins);
    }

    private static List<Selection<?>> loadCompleteSelections(List<Selection<?>> selections, Map<String, Join<?, ?>> joins, Root<?> root, Class<?> entityClass, Map<Class<?>, Map<String, Field>> idFields) {
        idFields.forEach((currentClass, value) -> value.keySet().forEach(el -> {
            boolean matchesCurrentEntity = currentClass.equals(entityClass);
            if (matchesCurrentEntity && selections.stream().noneMatch(selection -> selection.getAlias().equals(el))) {
                selections.add(JPASearchUtils.getPath(root, el).alias(el));
            } else if (!matchesCurrentEntity) {
                String currentPath;
                String[] parts = el.split("\\.");
                String path = String.join((CharSequence)".", Arrays.copyOf(parts, parts.length - 1));
                int lastDotIndex = el.lastIndexOf(46);
                String parentPath = lastDotIndex == -1 ? el : el.substring(0, lastDotIndex);
                String string = currentPath = lastDotIndex == -1 ? el : el.substring(lastDotIndex + 1);
                if (selections.stream().anyMatch(s -> s.getAlias().startsWith(path)) && selections.stream().noneMatch(selection -> selection.getAlias().equals(el))) {
                    selections.add(joins.containsKey(parentPath) ? ((Join)joins.get(parentPath)).get(currentPath).alias(el) : JPASearchUtils.getPath(root, el).alias(el));
                }
            }
        }));
        return selections;
    }

    private static void toMap(Tuple tuple, Map<ClassID, Map<String, Object>> ids, Class<?> entityClass, List<Selection<?>> selections, Map<Class<?>, Map<String, Field>> idFields) {
        LinkedHashMap currentIds = new LinkedHashMap();
        idFields.forEach((currentEntityClass, currentIdMap) -> {
            JPAEntityId id = new JPAEntityId();
            id.setIds(new LinkedList<Object>());
            currentIdMap.keySet().forEach(k -> tuple.getElements().stream().filter(el -> el.getAlias().equals(k)).findAny().ifPresent(t -> id.getIds().add(tuple.get(k))));
            if (!id.getIds().isEmpty()) {
                ClassID classId = new ClassID((Class<?>)currentEntityClass, id);
                ids.putIfAbsent(classId, new LinkedHashMap());
                currentIds.put(currentEntityClass, Pair.of((Object)id, (Object)((Map)ids.get(classId))));
            }
        });
        for (Selection<?> selection : selections) {
            String[] path = selection.getAlias().split("\\.");
            Class<?> currentClass = entityClass;
            Map currentMap = (Map)((Pair)currentIds.get(currentClass)).getRight();
            Object value = tuple.get(selection.getAlias());
            for (int i = 0; i < path.length; ++i) {
                Field field;
                String currentPath = path[i];
                try {
                    field = currentClass.getDeclaredField(currentPath);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                field.setAccessible(true);
                if (i == path.length - 1) {
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        ((Collection)currentMap.computeIfAbsent(currentPath, k -> JPAProjectionProcessor.createCollection(field))).add(value);
                    } else {
                        currentMap.put(currentPath, value);
                    }
                } else if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection collection;
                    boolean newCollection = false;
                    if (!currentMap.containsKey(currentPath)) {
                        collection = JPAProjectionProcessor.createCollection(field);
                        currentMap.put(currentPath, collection);
                        newCollection = true;
                    } else {
                        collection = (Collection)currentMap.get(currentPath);
                    }
                    boolean toAdd = false;
                    if (!((Map)((Pair)currentIds.get(ReflectionUtils.getType(field))).getRight()).containsKey(path[i + 1])) {
                        currentMap = (Map)((Pair)currentIds.get(ReflectionUtils.getType(field))).getRight();
                        toAdd = currentMap.isEmpty();
                    } else {
                        currentMap = (Map)((Pair)currentIds.get(ReflectionUtils.getType(field))).getRight();
                    }
                    if (newCollection || toAdd) {
                        collection.add(currentMap);
                    }
                } else {
                    Map nestedMap;
                    Map tempCurrentMap = currentIds.containsKey(ReflectionUtils.getType(field)) ? (Map)((Pair)currentIds.get(ReflectionUtils.getType(field))).getRight() : new LinkedHashMap();
                    currentMap = nestedMap = (Map)currentMap.computeIfAbsent(currentPath, k -> tempCurrentMap);
                }
                currentClass = ReflectionUtils.getType(field);
            }
        }
    }

    public static List<Map<String, Object>> toMap(List<Tuple> tuple, Class<?> entityClass, List<Selection<?>> selections, Map<Class<?>, Map<String, Field>> idFields) {
        LinkedHashMap map = new LinkedHashMap();
        tuple.forEach(t -> JPAProjectionProcessor.toMap(t, map, entityClass, selections, idFields));
        return map.entrySet().stream().filter(e -> ((ClassID)e.getKey()).getClazz().equals(entityClass)).map(Map.Entry::getValue).toList();
    }

    private static Collection<Object> createCollection(Field field) {
        if (List.class.isAssignableFrom(field.getType())) {
            return new ArrayList<Object>();
        }
        if (Set.class.isAssignableFrom(field.getType())) {
            return new HashSet<Object>();
        }
        if (Queue.class.isAssignableFrom(field.getType())) {
            return new LinkedList<Object>();
        }
        return new ArrayList<Object>();
    }

    private static class ClassID {
        private Class<?> clazz;
        private JPAEntityId id;

        @Generated
        public Class<?> getClazz() {
            return this.clazz;
        }

        @Generated
        public JPAEntityId getId() {
            return this.id;
        }

        @Generated
        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Generated
        public void setId(JPAEntityId id) {
            this.id = id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassID)) {
                return false;
            }
            ClassID other = (ClassID)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            JPAEntityId this$id = this.getId();
            JPAEntityId other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClassID;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            JPAEntityId $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JPAProjectionProcessor.ClassID(clazz=" + String.valueOf(this.getClazz()) + ", id=" + String.valueOf(this.getId()) + ")";
        }

        @Generated
        public ClassID(Class<?> clazz, JPAEntityId id) {
            this.clazz = clazz;
            this.id = id;
        }
    }
}

