/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.core;

import app.tozzi.annotation.Searchable;
import app.tozzi.exception.InvalidValueException;
import app.tozzi.exception.JPASearchException;
import app.tozzi.model.JPASearchOperatorFilter;
import app.tozzi.model.JPASearchType;
import app.tozzi.util.GenericUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class JPASearchCoreValueProcessor {
    protected static Object processValue(JPASearchOperatorFilter operatorFilter, JPASearchType searchType, Searchable searchable, String field, Object value, Class<?> type, boolean lower) {
        if (operatorFilter.getAllowedValues() == 0) {
            return null;
        }
        Object objValue = JPASearchCoreValueProcessor.getValue(operatorFilter, searchType, searchable, field, value, type, lower);
        if (objValue == null) {
            throw new InvalidValueException("Invalid value [" + String.valueOf(value) + "]", field, value);
        }
        JPASearchCoreValueProcessor.searchableValidationsOnTargetValue(objValue, searchable, field, value, searchType, operatorFilter);
        JPASearchCoreValueProcessor.filterValidations(operatorFilter, field, objValue, searchType);
        return objValue;
    }

    private static void searchableValidationsOnTargetValue(Object targetValue, Searchable searchable, String field, Object value, JPASearchType searchType, JPASearchOperatorFilter filter) {
        int maxLength = JPASearchCoreValueProcessor.getMaxLength(searchType, targetValue);
        if (maxLength >= 0 && searchable.maxSize() >= 0 && maxLength > searchable.maxSize()) {
            throw new InvalidValueException("Value [" + String.valueOf(value) + "] exceeds maximum length [" + searchable.maxSize() + "] defined on field [" + field + "]", field, value);
        }
        int minLength = JPASearchCoreValueProcessor.getMinLength(searchType, targetValue);
        if (minLength >= 0 && searchable.minSize() >= 0 && minLength < searchable.minSize()) {
            throw new InvalidValueException("Value [" + String.valueOf(value) + "] less than minimum length [" + searchable.minSize() + "] defined on field [" + field + "]", field, value);
        }
        int maxDigits = JPASearchCoreValueProcessor.getMaxDigits(searchType, targetValue);
        if (maxDigits >= 0 && searchable.maxDigits() >= 0 && maxDigits > searchable.maxDigits()) {
            throw new InvalidValueException("Value [" + String.valueOf(value) + "] exceeds maximum digits count [" + searchable.maxDigits() + "] defined on field [" + field + "]", field, value);
        }
        int minDigits = JPASearchCoreValueProcessor.getMinDigits(searchType, targetValue);
        if (minLength >= 0 && searchable.minDigits() >= 0 && minDigits < searchable.minDigits()) {
            throw new InvalidValueException("Value [" + String.valueOf(value) + "] less than minimum digits count [" + searchable.minDigits() + "] defined on field [" + field + "]", field, value);
        }
        if (searchable.regexPattern() != null && !searchable.regexPattern().isBlank() && !JPASearchCoreValueProcessor.matchRegex(searchType, filter, targetValue, searchable.regexPattern())) {
            throw new InvalidValueException("Value [" + String.valueOf(value) + " does not match pattern [" + searchable.regexPattern() + " of field [" + field + "]", field, value);
        }
    }

    private static void filterValidations(JPASearchOperatorFilter searchOperatorFilter, String field, Object valueObj, JPASearchType searchType) {
        int values;
        boolean isCollection = Collection.class.isAssignableFrom(valueObj.getClass());
        Collection collection = isCollection ? (Collection)valueObj : null;
        int n = values = isCollection ? collection.size() : 1;
        if (searchOperatorFilter.getAllowedValues() != -1 && searchOperatorFilter.getAllowedValues() != values) {
            throw new InvalidValueException("Invalid values count: [" + values + "] for type [" + searchType.name() + "] of field [" + field + "]. Expected: [" + searchOperatorFilter.getAllowedValues() + "]; received: [" + values + "]", field, valueObj);
        }
    }

    private static Object getValue(JPASearchOperatorFilter jpaSearchOperatorFilter, JPASearchType searchType, Searchable searchable, String field, Object value, Class<?> type, boolean lower) {
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return coll.stream().map(el -> JPASearchCoreValueProcessor.getValue(jpaSearchOperatorFilter, searchType, searchable, field, el, type, lower)).toList();
        }
        try {
            Object res = switch (searchType) {
                default -> throw new IncompatibleClassChangeError();
                case JPASearchType.STRING -> String.valueOf(value);
                case JPASearchType.DATE -> GenericUtils.parseDate(field, value, searchable.datePattern());
                case JPASearchType.LOCALDATETIME -> GenericUtils.parseLocalDateTime(field, value, searchable.datePattern());
                case JPASearchType.LOCALDATE -> GenericUtils.parseLocalDate(field, value, searchable.datePattern());
                case JPASearchType.LOCALTIME -> GenericUtils.parseLocalTime(field, value, searchable.datePattern());
                case JPASearchType.OFFSETDATETIME -> GenericUtils.parseOffsetDateTime(field, value, searchable.datePattern());
                case JPASearchType.OFFSETTIME -> GenericUtils.parseOffsetTime(field, value, searchable.datePattern());
                case JPASearchType.BOOLEAN -> GenericUtils.parseBoolean(field, value);
                case JPASearchType.INTEGER, JPASearchType.LONG, JPASearchType.FLOAT, JPASearchType.DOUBLE, JPASearchType.BIGDECIMAL -> JPASearchCoreValueProcessor.formatNumber(field, value, searchable, searchType, jpaSearchOperatorFilter);
                case JPASearchType.ZONEDDATETIME -> GenericUtils.parseZonedDateTime(field, value, searchable.datePattern());
                case JPASearchType.UUID -> GenericUtils.parseUUID(field, value);
                case JPASearchType.INSTANT -> GenericUtils.parseInstant(field, value, searchable.datePattern());
                case JPASearchType.DATE_SQL -> GenericUtils.parseSQLDate(field, value, searchable.datePattern());
                case JPASearchType.TIME_SQL -> GenericUtils.parseSQLTime(field, value, searchable.datePattern());
                case JPASearchType.TIMESTAMP -> GenericUtils.parseSQLTimestamp(field, value, searchable.datePattern());
                case JPASearchType.ENUM -> GenericUtils.parseEnum(field, value, searchable.ordinalEnum(), type);
                case JPASearchType.UNTYPED -> throw new IllegalArgumentException();
            };
            return lower ? JPASearchCoreValueProcessor.toLowerCase(res) : res;
        }
        catch (Exception e) {
            if (e instanceof JPASearchException) {
                JPASearchException jse = (JPASearchException)e;
                throw jse;
            }
            throw new InvalidValueException("Unable to convert value [" + String.valueOf(value) + "] of field [" + field + "] to [" + searchType.name() + "] type", (Throwable)e, field, value);
        }
    }

    private static Object formatNumber(String field, Object number, Searchable searchable, JPASearchType searchType, JPASearchOperatorFilter operatorFilter) throws ParseException {
        if (operatorFilter.isNoNumberParsing()) {
            return GenericUtils.containsOnlyDigits(number) ? number : JPASearchCoreValueProcessor.loadNumber(field, number, searchType);
        }
        number = JPASearchCoreValueProcessor.loadNumber(field, number, searchType);
        Number formattedNumber = switch (searchType) {
            case JPASearchType.INTEGER -> GenericUtils.parseInteger(field, number);
            case JPASearchType.LONG -> GenericUtils.parseLong(field, number);
            case JPASearchType.FLOAT -> Float.valueOf(GenericUtils.formatNumber(JPASearchCoreValueProcessor.loadNumber(field, number, searchType), searchable.decimalFormat(), false).floatValue());
            case JPASearchType.DOUBLE -> GenericUtils.formatNumber(JPASearchCoreValueProcessor.loadNumber(field, number, searchType), searchable.decimalFormat(), false).doubleValue();
            case JPASearchType.BIGDECIMAL -> (BigDecimal)GenericUtils.formatNumber(JPASearchCoreValueProcessor.loadNumber(field, number, searchType), searchable.decimalFormat(), true);
            default -> throw new IllegalArgumentException();
        };
        if (!number.equals(formattedNumber)) {
            throw new InvalidValueException("Invalid decimal format [" + String.valueOf(number) + "] of field [" + field + "]", field, number);
        }
        return formattedNumber;
    }

    private static Number loadNumber(String field, Object number, JPASearchType searchType) {
        return switch (searchType) {
            case JPASearchType.INTEGER -> GenericUtils.parseInteger(field, number);
            case JPASearchType.LONG -> GenericUtils.parseLong(field, number);
            case JPASearchType.FLOAT -> GenericUtils.parseFloat(field, number);
            case JPASearchType.DOUBLE -> GenericUtils.parseDouble(field, number);
            case JPASearchType.BIGDECIMAL -> GenericUtils.parseBigDecimal(field, number);
            default -> throw new IllegalArgumentException();
        };
    }

    private static int getMaxLength(JPASearchType JPASearchType2, Object value) {
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return Collections.max(new ArrayList(coll).stream().map(e -> JPASearchCoreValueProcessor.getSize(JPASearchType2, e)).toList());
        }
        return JPASearchCoreValueProcessor.getSize(JPASearchType2, value);
    }

    private static int getMinLength(JPASearchType JPASearchType2, Object value) {
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return Collections.min(new ArrayList(coll).stream().map(e -> JPASearchCoreValueProcessor.getSize(JPASearchType2, e)).toList());
        }
        return JPASearchCoreValueProcessor.getSize(JPASearchType2, value);
    }

    private static int getMaxDigits(JPASearchType JPASearchType2, Object value) {
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return Collections.max(new ArrayList(coll).stream().map(e -> JPASearchCoreValueProcessor.getDigits(JPASearchType2, e)).toList());
        }
        return JPASearchCoreValueProcessor.getDigits(JPASearchType2, value);
    }

    private static int getMinDigits(JPASearchType JPASearchType2, Object value) {
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return Collections.min(new ArrayList(coll).stream().map(e -> JPASearchCoreValueProcessor.getDigits(JPASearchType2, e)).toList());
        }
        return JPASearchCoreValueProcessor.getDigits(JPASearchType2, value);
    }

    private static int getDigits(JPASearchType JPASearchType2, Object value) {
        return switch (JPASearchType2) {
            case JPASearchType.INTEGER, JPASearchType.LONG, JPASearchType.FLOAT, JPASearchType.DOUBLE, JPASearchType.BIGDECIMAL -> String.valueOf(value).length();
            default -> -1;
        };
    }

    private static int getSize(JPASearchType JPASearchType2, Object value) {
        return switch (JPASearchType2) {
            case JPASearchType.STRING -> String.valueOf(value).length();
            case JPASearchType.LONG -> {
                if (value instanceof String) {
                    String s = (String)value;
                    yield Long.valueOf(s).intValue();
                }
                yield ((Long)value).intValue();
            }
            case JPASearchType.INTEGER -> {
                Integer v1;
                if (value instanceof String) {
                    String s = (String)value;
                    v1 = Integer.valueOf(s);
                } else {
                    v1 = (Integer)value;
                }
                yield v1;
            }
            case JPASearchType.FLOAT -> ((Float)value).intValue();
            case JPASearchType.DOUBLE -> ((Double)value).intValue();
            case JPASearchType.BIGDECIMAL -> ((BigDecimal)value).intValue();
            default -> -1;
        };
    }

    private static boolean matchRegex(JPASearchType searchType, JPASearchOperatorFilter filter, Object value, String regex) {
        if (filter.isLike()) {
            return true;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return coll.stream().allMatch(v -> JPASearchCoreValueProcessor.matchRegex(searchType, filter, v, regex));
        }
        return switch (searchType) {
            case JPASearchType.STRING -> String.valueOf(value).matches(regex);
            default -> true;
        };
    }

    private static Object toLowerCase(Object object) {
        Object object2;
        if (object instanceof String) {
            String str = (String)object;
            object2 = str.toLowerCase();
        } else {
            object2 = object;
        }
        return object2;
    }
}

