/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.repository;

import app.tozzi.annotation.Searchable;
import app.tozzi.core.JPASearchCore;
import app.tozzi.model.input.JPASearchInput;
import app.tozzi.util.JPASearchUtils;
import app.tozzi.util.ReflectionUtils;
import io.micrometer.observation.annotation.Observed;
import jakarta.persistence.criteria.JoinType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

@Observed(contextualName="jpa-search-repository")
public interface JPASearchRepository<E>
extends JpaSpecificationExecutor<E> {
    default public List<E> findAll(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(JPASearchUtils.toObject(filters, false, false, false).getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), null, null);
        return this.findAll(specification);
    }

    default public List<E> findAll(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(input.getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), null, null);
        return this.findAll(specification);
    }

    default public List<E> findAll(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(JPASearchUtils.toObject(filters, false, false, false).getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), fetches, null);
        return this.findAll(specification);
    }

    default public List<E> findAll(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(input.getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), fetches, null);
        return this.findAll(specification);
    }

    default public List<E> findAll(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches, Map<String, String> entityFieldMap) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(JPASearchUtils.toObject(filters, false, false, false).getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), fetches, entityFieldMap);
        return this.findAll(specification);
    }

    default public List<E> findAll(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches, Map<String, String> entityFieldMap) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(input.getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), fetches, entityFieldMap);
        return this.findAll(specification);
    }

    default public List<E> findAllSorted(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        JPASearchInput input = JPASearchUtils.toObject(filters, false, true, false);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, null, null);
        Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, null);
        return this.findAll(specification, sort);
    }

    default public List<E> findAllSorted(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, null, null);
        Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, null);
        return this.findAll(specification, sort);
    }

    default public List<E> findAllSorted(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        JPASearchInput input = JPASearchUtils.toObject(filters, false, true, false);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, fetches, null);
        Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, null);
        return this.findAll(specification, sort);
    }

    default public List<E> findAllSorted(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, fetches, null);
        Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, null);
        return this.findAll(specification, sort);
    }

    default public List<E> findAllSorted(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches, Map<String, String> entityFieldMap) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        JPASearchInput input = JPASearchUtils.toObject(filters, false, true, false);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, fetches, entityFieldMap);
        Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, entityFieldMap);
        return this.findAll(specification, sort);
    }

    default public List<E> findAllSorted(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType, Map<String, JoinType> fetches, Map<String, String> entityFieldMap) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, fetches, entityFieldMap);
        Sort sort = JPASearchCore.loadSort(input.getOptions(), searchableFields, entityFieldMap);
        return this.findAll(specification, sort);
    }

    default public Page<E> findAllWithPaginationAndSorting(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        JPASearchInput input = JPASearchUtils.toObject(filters, true, true, false);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, null, null);
        PageRequest pageRequest = JPASearchCore.loadSortAndPagination(input.getOptions(), searchableFields, null);
        return this.findAll(specification, (Pageable)pageRequest);
    }

    default public Page<E> findAllWithPaginationAndSorting(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, null, null);
        PageRequest pageRequest = JPASearchCore.loadSortAndPagination(input.getOptions(), searchableFields, null);
        return this.findAll(specification, (Pageable)pageRequest);
    }

    default public Page<E> findAllWithPaginationAndSorting(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType, Map<String, String> entityFieldMap) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        JPASearchInput input = JPASearchUtils.toObject(filters, true, true, false);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, null, entityFieldMap);
        PageRequest pageRequest = JPASearchCore.loadSortAndPagination(input.getOptions(), searchableFields, entityFieldMap);
        return this.findAll(specification, (Pageable)pageRequest);
    }

    default public Page<E> findAllWithPaginationAndSorting(@NonNull JPASearchInput input, @NonNull Class<?> domainModelOrEntityType, Map<String, String> entityFieldMap) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Map<String, Pair<Searchable, Field>> searchableFields = ReflectionUtils.getAllSearchableFields(domainModelOrEntityType);
        Specification specification = JPASearchCore.specification(input.getFilter(), searchableFields, null, entityFieldMap);
        PageRequest pageRequest = JPASearchCore.loadSortAndPagination(input.getOptions(), searchableFields, entityFieldMap);
        return this.findAll(specification, (Pageable)pageRequest);
    }

    default public long count(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(JPASearchUtils.toObject(filters, false, false, false).getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), null, null);
        return this.count(specification);
    }

    default public long count(JPASearchInput input, @NonNull Class<?> domainModelOrEntityType) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(input.getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), null, null);
        return this.count(specification);
    }

    default public long count(Map<String, String> filters, @NonNull Class<?> domainModelOrEntityType, Map<String, String> entityFieldMap) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(JPASearchUtils.toObject(filters, false, false, false).getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), null, entityFieldMap);
        return this.count(specification);
    }

    default public long count(JPASearchInput input, @NonNull Class<?> domainModelOrEntityType, Map<String, String> entityFieldMap) {
        if (domainModelOrEntityType == null) {
            throw new NullPointerException("domainModelOrEntityType is marked non-null but is null");
        }
        Specification specification = JPASearchCore.specification(input.getFilter(), ReflectionUtils.getAllSearchableFields(domainModelOrEntityType), null, entityFieldMap);
        return this.count(specification);
    }
}

