/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import app.tozzi.annotation.NestedProjectable;
import app.tozzi.annotation.NestedSearchable;
import app.tozzi.annotation.Projectable;
import app.tozzi.annotation.Searchable;
import app.tozzi.exception.JPASearchException;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReflectionUtils {
    private static final ConcurrentHashMap<Class<?>, Map<String, Pair<Searchable, Field>>> SEARCHABLE_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Map<String, Pair<Projectable, Field>>> PROJECTABLE_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Map<String, Field>> ID_CACHE = new ConcurrentHashMap();

    public static Map<Class<?>, Map<String, Field>> getIdFields(Class<?> entityClass) {
        return ReflectionUtils.getIdFields(null, entityClass);
    }

    private static Map<Class<?>, Map<String, Field>> getIdFields(String prefix, Class<?> entityClass) {
        ID_CACHE.computeIfAbsent(entityClass, key -> {
            Field embeddedID = Stream.of(entityClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(EmbeddedId.class)).findAny().orElse(null);
            return Stream.of(embeddedID != null ? ReflectionUtils.getType(embeddedID).getDeclaredFields() : entityClass.getDeclaredFields()).filter(f -> embeddedID != null || f.isAnnotationPresent(Id.class)).collect(Collectors.toMap(f -> (String)(prefix != null ? prefix + "." : "") + (String)(embeddedID != null ? embeddedID.getName() + "." + f.getName() : f.getName()), f -> f));
        });
        Stream.of(entityClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(OneToMany.class) || f.isAnnotationPresent(OneToOne.class) || f.isAnnotationPresent(ManyToMany.class) || f.isAnnotationPresent(ManyToOne.class)).filter(f -> !ID_CACHE.containsKey(ReflectionUtils.getType(f))).forEach(field -> ReflectionUtils.getIdFields((String)(prefix != null ? prefix + "." : "") + field.getName(), ReflectionUtils.getType(field)));
        return ID_CACHE;
    }

    public static Map<String, Pair<Searchable, Field>> getAllSearchableFields(Class<?> beanClass) {
        return SEARCHABLE_CACHE.computeIfAbsent(beanClass, key -> {
            HashMap res = new HashMap();
            ReflectionUtils.getFields(new StringBuilder(), beanClass, Searchable.class, NestedSearchable.class, res, true);
            return res;
        });
    }

    public static Map<String, Pair<Projectable, Field>> getAllProjectableFields(Class<?> beanClass) {
        return PROJECTABLE_CACHE.computeIfAbsent(beanClass, key -> {
            HashMap res = new HashMap();
            ReflectionUtils.getFields(new StringBuilder(), beanClass, Projectable.class, NestedProjectable.class, res, true);
            return res;
        });
    }

    private static <A extends Annotation, N extends Annotation> void getFields(StringBuilder root, Class<?> beanClass, Class<A> annotationClass, Class<N> nestedAnnotationClass, Map<String, Pair<A, Field>> res, boolean evaluateNested) {
        Stream.of(FieldUtils.getAllFields(beanClass)).forEach(f -> {
            if (f.isAnnotationPresent(annotationClass)) {
                res.putIfAbsent((String)(root.isEmpty() ? f.getName() : String.valueOf(root) + "." + f.getName()), (Pair)Pair.of(f.getAnnotation(annotationClass), (Object)f));
            }
            if (evaluateNested && f.isAnnotationPresent(nestedAnnotationClass)) {
                if (!root.isEmpty()) {
                    root.append(".");
                }
                root.append(f.getName());
                Class<?> type = ReflectionUtils.getType(f);
                ReflectionUtils.getFields(root, type, annotationClass, nestedAnnotationClass, res, !type.equals(beanClass));
                if (root.indexOf(".") != -1) {
                    root.delete(root.lastIndexOf("."), root.length());
                } else {
                    root.setLength(0);
                }
            }
        });
    }

    public static Class<?> getType(Field f) {
        Class<?> type = f.getType();
        if (Collection.class.isAssignableFrom(f.getType())) {
            Type[] arr = ((ParameterizedType)f.getGenericType()).getActualTypeArguments();
            if (arr.length > 0) {
                Type type2 = arr[0];
                if (type2 instanceof Class) {
                    Class clazz = (Class)type2;
                    return clazz;
                }
                type2 = arr[0];
                if (type2 instanceof WildcardType) {
                    WildcardType wt = (WildcardType)type2;
                    if (wt.getLowerBounds() != null && wt.getLowerBounds().length > 0) {
                        return (Class)wt.getLowerBounds()[0];
                    }
                    if (wt.getUpperBounds() != null && wt.getUpperBounds().length > 0) {
                        return (Class)wt.getUpperBounds()[0];
                    }
                }
            }
            throw new JPASearchException("Invalid searchable type " + String.valueOf(f.getType()));
        }
        return type;
    }
}

