/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.core;

import app.tozzi.annotation.Searchable;
import app.tozzi.core.JPASearchCoreFieldProcessor;
import app.tozzi.core.JPASearchCoreValueProcessor;
import app.tozzi.exception.JPASearchException;
import app.tozzi.model.FieldDescriptor;
import app.tozzi.model.JPASearchOperatorFilter;
import app.tozzi.model.JPASearchOperatorGroup;
import app.tozzi.model.input.JPASearchInput;
import app.tozzi.util.JPASearchUtils;
import app.tozzi.util.ValidationUtils;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class JPASearchCore {
    public static <R> Specification<R> specification(JPASearchInput.RootFilter filter, Map<String, Pair<Searchable, Field>> searchableFields, Map<String, JoinType> fetchMap, Map<String, String> entityFieldMap) {
        if (filter == null) {
            return Specification.where(null);
        }
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Expression<?> expr = JPASearchCore.processExpression(filter, criteriaBuilder, JPASearchUtils.fetchManagement(fetchMap, root), searchableFields, entityFieldMap);
            if (expr == null) {
                return criteriaBuilder.conjunction();
            }
            if (expr instanceof Predicate) {
                Predicate predicate = (Predicate)expr;
                return predicate;
            }
            throw new JPASearchException("Not resulting a predicate: " + String.valueOf(expr));
        };
    }

    public static Sort loadSort(JPASearchInput.JPASearchOptions options, Map<String, Pair<Searchable, Field>> searchableFields, Map<String, String> entityFieldMap) {
        return JPASearchCore.loadSort(options, searchableFields, entityFieldMap, false);
    }

    public static PageRequest loadSortAndPagination(JPASearchInput.JPASearchOptions options, Map<String, Pair<Searchable, Field>> searchableFields, Map<String, String> entityFieldMap) {
        if (options == null || options.getPageSize() == null || options.getPageSize() <= 0) {
            throw new JPASearchException("Invalid or not present page size value");
        }
        PageRequest result = PageRequest.ofSize((int)options.getPageSize()).withPage(options.getPageOffset() != null && options.getPageOffset() >= 0 ? options.getPageOffset() : 0);
        Sort sort = JPASearchCore.loadSort(options, searchableFields, entityFieldMap, true);
        return sort != null ? result.withSort(sort) : result;
    }

    private static Sort loadSort(JPASearchInput.JPASearchOptions options, Map<String, Pair<Searchable, Field>> searchableFields, Map<String, String> entityFieldMap, boolean nullable) {
        if (options == null || options.getSortOptions() == null || options.getSortOptions().isEmpty()) {
            if (nullable) {
                return null;
            }
            throw new JPASearchException("Invalid sort options");
        }
        ArrayList orders = new ArrayList();
        options.getSortOptions().forEach(so -> {
            FieldDescriptor des = JPASearchCoreFieldProcessor.processField(so.getKey(), entityFieldMap, searchableFields, true, true, true);
            if (des == null) {
                if (nullable) {
                    return;
                }
                throw new JPASearchException("Invalid sort key");
            }
            orders.add(Boolean.TRUE.equals(so.getDesc()) ? Sort.Order.desc((String)des.getEntityKey()) : Sort.Order.asc((String)des.getEntityKey()));
        });
        return Sort.by(orders);
    }

    private static Expression<?> processExpression(JPASearchInput.Filter filter, CriteriaBuilder cb, Root<?> root, Map<String, Pair<Searchable, Field>> searchableFields, Map<String, String> entityFieldMap) {
        if (filter instanceof JPASearchInput.RootFilter) {
            JPASearchInput.RootFilter rootFilter = (JPASearchInput.RootFilter)filter;
            if (rootFilter.getFilters() == null || rootFilter.getFilters().isEmpty()) {
                return null;
            }
            JPASearchOperatorGroup operator = JPASearchOperatorGroup.load(rootFilter.getOperator());
            List<Expression> arguments = rootFilter.getFilters().stream().map(f -> JPASearchCore.process(f, cb, root, entityFieldMap, searchableFields)).filter(Objects::nonNull).toList();
            if (arguments.isEmpty()) {
                throw new JPASearchException("Invalid expression");
            }
            return operator.getFunction().apply(cb, arguments.toArray(new Expression[0]), new Object[0]);
        }
        throw new JPASearchException("Invalid expression");
    }

    private static Expression<?> process(JPASearchInput.Filter filter, CriteriaBuilder cb, Root<?> root, Map<String, String> entityFieldMap, Map<String, Pair<Searchable, Field>> searchableFields) {
        if (filter instanceof JPASearchInput.RootFilter) {
            return JPASearchCore.processExpression(filter, cb, root, searchableFields, entityFieldMap);
        }
        if (filter instanceof JPASearchInput.FieldFilter) {
            JPASearchInput.FieldFilter fieldFilter = (JPASearchInput.FieldFilter)filter;
            ArrayList<Expression> exps = new ArrayList<Expression>();
            JPASearchOperatorFilter searchFilter = JPASearchOperatorFilter.load(fieldFilter.getOperator());
            FieldDescriptor descriptor = JPASearchCoreFieldProcessor.processField(fieldFilter.getKey(), entityFieldMap, searchableFields, true, true, false);
            if (descriptor == null) {
                return null;
            }
            ValidationUtils.searchableValidations(descriptor.getSearchable(), descriptor.getPath(), searchFilter);
            Expression path = JPASearchUtils.getPath(root, descriptor.getEntityKey());
            Expression exp = null;
            boolean trim = false;
            boolean ignoreCase = false;
            if (descriptor.getSearchable().trim()) {
                exp = cb.trim(path.as(String.class));
                trim = true;
            }
            if (fieldFilter.getOptions() != null) {
                if (!trim && fieldFilter.getOptions().isTrim()) {
                    exp = cb.trim(path.as(String.class));
                }
                if (fieldFilter.getOptions().isIgnoreCase()) {
                    ignoreCase = true;
                    exp = exp != null ? cb.lower(exp.as(String.class)) : cb.lower(path.as(String.class));
                }
            }
            exps.add(exp != null ? exp : path);
            ArrayList<Object> obj = new ArrayList<Object>();
            if (fieldFilter instanceof JPASearchInput.FilterSingleValue) {
                JPASearchInput.FilterSingleValue fsv = (JPASearchInput.FilterSingleValue)fieldFilter;
                Object valueExp = JPASearchCoreValueProcessor.processValue(searchFilter, descriptor.getSearchType(), descriptor.getSearchable(), descriptor.getPath(), fsv.getValue(), descriptor.getType(), ignoreCase);
                if (valueExp != null) {
                    obj.add(valueExp);
                }
            } else if (fieldFilter instanceof JPASearchInput.FilterMultipleValues) {
                JPASearchInput.FilterMultipleValues fmv = (JPASearchInput.FilterMultipleValues)fieldFilter;
                Object valueExp = JPASearchCoreValueProcessor.processValue(searchFilter, descriptor.getSearchType(), descriptor.getSearchable(), descriptor.getPath(), fmv.getValues(), descriptor.getType(), ignoreCase);
                if (valueExp != null) {
                    if (valueExp instanceof Collection) {
                        Collection coll = (Collection)valueExp;
                        obj.addAll(coll);
                    } else {
                        obj.add(valueExp);
                    }
                }
            }
            return fieldFilter.getOptions() != null && fieldFilter.getOptions().isNegate() ? JPASearchOperatorGroup.NOT.getFunction().apply(cb, new Expression[]{searchFilter.getFunction().apply(cb, exps.toArray(new Expression[0]), obj.toArray(new Object[0]))}, new Object[0]) : searchFilter.getFunction().apply(cb, exps.toArray(new Expression[0]), obj.toArray(new Object[0]));
        }
        throw new JPASearchException("Invalid expression");
    }

    @Generated
    public JPASearchCore() {
    }
}

