/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.model;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;

public enum JPASearchType {
    UNTYPED(Collections.emptyList()),
    STRING(List.of(String.class)),
    LONG(List.of(Long.class, Long.TYPE)),
    INTEGER(List.of(Integer.class, Integer.TYPE)),
    DATE(List.of(java.util.Date.class)),
    LOCALDATE(List.of(LocalDate.class)),
    LOCALDATETIME(List.of(LocalDateTime.class)),
    LOCALTIME(List.of(LocalTime.class)),
    OFFSETDATETIME(List.of(OffsetDateTime.class)),
    OFFSETTIME(List.of(OffsetTime.class)),
    ZONEDDATETIME(List.of(ZonedDateTime.class)),
    FLOAT(List.of(Float.class, Float.TYPE)),
    DOUBLE(List.of(Double.class, Double.TYPE)),
    BIGDECIMAL(List.of(BigDecimal.class)),
    BOOLEAN(List.of(Boolean.class, Boolean.TYPE)),
    UUID(List.of(UUID.class)),
    INSTANT(List.of(Instant.class)),
    DATE_SQL(List.of(Date.class)),
    TIME_SQL(List.of(Time.class)),
    ENUM(List.of(Enum.class)),
    TIMESTAMP(List.of(Timestamp.class));

    private final List<Class<?>> defaultClasses;

    public static JPASearchType load(Class<?> clazz, JPASearchType defaultType) {
        return Stream.of(JPASearchType.values()).filter(s -> s.defaultClasses.contains(clazz)).findAny().orElse(defaultType);
    }

    @Generated
    private JPASearchType(List<Class<?>> defaultClasses) {
        this.defaultClasses = defaultClasses;
    }

    @Generated
    public List<Class<?>> getDefaultClasses() {
        return this.defaultClasses;
    }
}

