/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.mail.pec.util;

import app.tozzi.mail.pec.exception.PECParserException;
import app.tozzi.mail.pec.util.MimeMessageUtils;
import app.tozzi.mail.pec.util.MimeTypesUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.Part;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;

public class IOUtils {
    private static final String UNNAMED_FILE_NAME = "unnamed_file";
    private static final String UNNAMED_EMBEDDED_FILE_NAME = "embedded_unnamed_file";

    public static DataSource createDataSource(MimePart part) throws IOException, PECParserException {
        DataHandler dataHandler = MimeMessageUtils.getDataHandler((Part)part);
        DataSource dataSource = dataHandler.getDataSource();
        String fileName = MimeMessageUtils.getFileName((Part)part);
        fileName = fileName != null && !fileName.trim().isEmpty() ? MimeMessageUtils.decodeText(fileName) : IOUtils.getName((Part)part);
        String contentType = IOUtils.getBaseMimeType(dataSource, fileName);
        byte[] content = IOUtils.getContent(dataSource.getInputStream());
        ByteArrayDataSource result = new ByteArrayDataSource(content, contentType);
        result.setName(fileName);
        return result;
    }

    private static String getBaseMimeType(DataSource dataSource, String fileName) {
        String fullMimeType = dataSource.getContentType();
        if (fullMimeType == null || fullMimeType.trim().isEmpty()) {
            return IOUtils.getFileMimeType(fileName);
        }
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }

    private static String getFileMimeType(String fileName) {
        String fileExt;
        String result = null;
        int dotPos = fileName.lastIndexOf(".");
        result = dotPos < 0 ? "application/octet-stream" : ((fileExt = fileName.substring(dotPos + 1)).length() == 0 ? "application/octet-stream" : MimeTypesUtil.guessMimeType(fileExt));
        if ("application/octet-stream".equals(result)) {
            result = FileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
        }
        return result != null ? result : "application/octet-stream";
    }

    private static String getName(Part part) throws UnsupportedEncodingException, PECParserException {
        String fileName = MimeMessageUtils.getFileName(part);
        if (fileName != null && !fileName.trim().isEmpty()) {
            return MimeMessageUtils.decodeText(fileName);
        }
        String extension = IOUtils.getExtension(part);
        String string = extension = extension != null && !extension.trim().isEmpty() ? "." + extension : "";
        if ("inline".equals(MimeMessageUtils.getDisposition(part))) {
            return UNNAMED_EMBEDDED_FILE_NAME + extension;
        }
        return UNNAMED_FILE_NAME + extension;
    }

    private static byte[] getContent(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.fastCopy(is, os);
        byte[] result = os.toByteArray();
        return result;
    }

    public static void fastCopy(InputStream src, OutputStream dest) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(src);
        WritableByteChannel outputChannel = Channels.newChannel(dest);
        IOUtils.fastCopy(inputChannel, outputChannel);
        inputChannel.close();
        outputChannel.close();
    }

    private static void fastCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    private static String getExtension(Part part) {
        String fullMimeType;
        try {
            fullMimeType = MimeMessageUtils.getContentType(part);
        }
        catch (PECParserException e) {
            return null;
        }
        if (fullMimeType != null && !fullMimeType.trim().isEmpty()) {
            return MimeTypesUtil.guessExtension(fullMimeType);
        }
        return null;
    }
}

