/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.mail.pec.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MimeTypesUtil {
    public static final String CONTENT_TYPE_OCETSTREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final String CONTENT_TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String CONTENT_TYPE_MULTIPART = "multipart/*";
    public static final String CONTENT_TYPE_TEXT = "text/*";
    private static Map<String, List<String>> mimeTypesMap = new LinkedHashMap<String, List<String>>();

    public static String guessMimeType(String extension) {
        if (extension == null) {
            return null;
        }
        List<String> mimeType = mimeTypesMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(extension.toLowerCase())).map(e -> (String)e.getKey()).collect(Collectors.toList());
        if (mimeType.isEmpty()) {
            return CONTENT_TYPE_OCETSTREAM;
        }
        if (mimeType.size() == 1) {
            return (String)mimeType.get(0);
        }
        return MimeTypesUtil.excludeMimeTypes(Arrays.asList("/vnd.", "/x-"), mimeType);
    }

    private static String excludeMimeTypes(List<String> pattern, List<String> mimeTypes) {
        List<String> nMime = new ArrayList<String>(mimeTypes);
        for (String p : pattern) {
            ArrayList<String> nMime2 = new ArrayList<String>(nMime);
            if ((nMime = nMime.stream().filter(m -> !m.contains(p)).collect(Collectors.toList())).isEmpty()) {
                return (String)nMime2.get(0);
            }
            if (nMime.size() != 1) continue;
            return nMime.get(0);
        }
        return mimeTypes.get(0);
    }

    public static String guessExtension(String fullMimeType) {
        if (fullMimeType == null) {
            return null;
        }
        return mimeTypesMap.entrySet().stream().filter(e -> fullMimeType.toLowerCase().contains(((String)e.getKey()).toLowerCase())).findFirst().map(e -> (String)((List)e.getValue()).get(0)).orElse(null);
    }

    static {
        mimeTypesMap.put("application/applixware", Arrays.asList("aw"));
        mimeTypesMap.put("application/atom+xml", Arrays.asList("atom"));
        mimeTypesMap.put("application/atomcat+xml", Arrays.asList("atomcat"));
        mimeTypesMap.put("application/atomsvc+xml", Arrays.asList("atomsvc"));
        mimeTypesMap.put("application/base64", Arrays.asList("mme"));
        mimeTypesMap.put("application/book", Arrays.asList("boo", "book"));
        mimeTypesMap.put("application/ccxml+xml", Arrays.asList("ccxml"));
        mimeTypesMap.put("application/ccxml+xml,", Arrays.asList("ccxml"));
        mimeTypesMap.put("application/cdmi-capability", Arrays.asList("cdmia"));
        mimeTypesMap.put("application/cdmi-container", Arrays.asList("cdmic"));
        mimeTypesMap.put("application/cdmi-domain", Arrays.asList("cdmid"));
        mimeTypesMap.put("application/cdmi-object", Arrays.asList("cdmio"));
        mimeTypesMap.put("application/cdmi-queue", Arrays.asList("cdmiq"));
        mimeTypesMap.put("application/clariscad", Arrays.asList("ccad"));
        mimeTypesMap.put("application/commonground", Arrays.asList("dp"));
        mimeTypesMap.put("application/cu-seeme", Arrays.asList("cu"));
        mimeTypesMap.put("application/davmount+xml", Arrays.asList("davmount"));
        mimeTypesMap.put("application/drafting", Arrays.asList("drw"));
        mimeTypesMap.put("application/dssc+der", Arrays.asList("dssc"));
        mimeTypesMap.put("application/dssc+xml", Arrays.asList("xdssc"));
        mimeTypesMap.put("application/ecmascript", Arrays.asList("ecma", "es"));
        mimeTypesMap.put("application/emma+xml", Arrays.asList("emma"));
        mimeTypesMap.put("application/envoy", Arrays.asList("evy"));
        mimeTypesMap.put("application/epub+zip", Arrays.asList("epub"));
        mimeTypesMap.put("application/excel", Arrays.asList("xl"));
        mimeTypesMap.put("application/exi", Arrays.asList("exi"));
        mimeTypesMap.put("application/font-tdpfr", Arrays.asList("pfr"));
        mimeTypesMap.put("application/fractals", Arrays.asList("fif"));
        mimeTypesMap.put("application/freeloader", Arrays.asList("frl"));
        mimeTypesMap.put("application/futuresplash", Arrays.asList("spl"));
        mimeTypesMap.put("application/groupwise", Arrays.asList("vew"));
        mimeTypesMap.put("application/hta", Arrays.asList("hta"));
        mimeTypesMap.put("application/hyperstudio", Arrays.asList("stk"));
        mimeTypesMap.put("application/i-deas", Arrays.asList("unv"));
        mimeTypesMap.put("application/inf", Arrays.asList("inf"));
        mimeTypesMap.put("application/internet-property-stream", Arrays.asList("acx"));
        mimeTypesMap.put("application/ipfix", Arrays.asList("ipfix"));
        mimeTypesMap.put("application/java-archive", Arrays.asList("jar"));
        mimeTypesMap.put("application/java-serialized-object", Arrays.asList("ser"));
        mimeTypesMap.put("application/java-vm", Arrays.asList("class"));
        mimeTypesMap.put("application/javascript", Arrays.asList("js"));
        mimeTypesMap.put("application/json", Arrays.asList("json"));
        mimeTypesMap.put("application/lost+xml", Arrays.asList("lostxml"));
        mimeTypesMap.put("application/mac-binhex40", Arrays.asList("hqx"));
        mimeTypesMap.put("application/mac-compactpro", Arrays.asList("cpt"));
        mimeTypesMap.put("application/mads+xml", Arrays.asList("mads"));
        mimeTypesMap.put("application/marc", Arrays.asList("mrc"));
        mimeTypesMap.put("application/marcxml+xml", Arrays.asList("mrcx"));
        mimeTypesMap.put("application/mathematica", Arrays.asList("ma", "mb", "nb"));
        mimeTypesMap.put("application/mathml+xml", Arrays.asList("mathml"));
        mimeTypesMap.put("application/mbedlet", Arrays.asList("mbd"));
        mimeTypesMap.put("application/mbox", Arrays.asList("mbox"));
        mimeTypesMap.put("application/mediaservercontrol+xml", Arrays.asList("mscml"));
        mimeTypesMap.put("application/metalink4+xml", Arrays.asList("meta4"));
        mimeTypesMap.put("application/mets+xml", Arrays.asList("mets"));
        mimeTypesMap.put("application/mime", Arrays.asList("aps"));
        mimeTypesMap.put("application/mods+xml", Arrays.asList("mods"));
        mimeTypesMap.put("application/mp21", Arrays.asList("m21"));
        mimeTypesMap.put("application/mp4", Arrays.asList("mp4s", "mp4"));
        mimeTypesMap.put("application/mspowerpoint", Arrays.asList("ppz"));
        mimeTypesMap.put("application/msword", Arrays.asList("doc", "dot"));
        mimeTypesMap.put("application/mxf", Arrays.asList("mxf"));
        mimeTypesMap.put("application/netmc", Arrays.asList("mcp"));
        mimeTypesMap.put(CONTENT_TYPE_OCETSTREAM, Arrays.asList("bin", "class", "dms", "exe", "lha", "lzh"));
        mimeTypesMap.put("application/oda", Arrays.asList("oda"));
        mimeTypesMap.put("application/oebps-package+xml", Arrays.asList("opf"));
        mimeTypesMap.put("application/ogg", Arrays.asList("ogx"));
        mimeTypesMap.put("application/olescript", Arrays.asList("axs"));
        mimeTypesMap.put("application/onenote", Arrays.asList("onepkg", "onetmp", "onetoc", "onetoc2"));
        mimeTypesMap.put("application/patch-ops-error+xml", Arrays.asList("xer"));
        mimeTypesMap.put("application/pdf", Arrays.asList("pdf"));
        mimeTypesMap.put("application/pgp-encrypted", Arrays.asList("pgp"));
        mimeTypesMap.put("application/pgp-signature", Arrays.asList("asc", "sig", "pgp"));
        mimeTypesMap.put("application/pics-rules", Arrays.asList("prf"));
        mimeTypesMap.put("application/pkcs10", Arrays.asList("p10"));
        mimeTypesMap.put("application/pkcs7-mime", Arrays.asList("p7c", "p7m"));
        mimeTypesMap.put("application/pkcs7-signature", Arrays.asList("p7s"));
        mimeTypesMap.put("application/pkcs8", Arrays.asList("p8"));
        mimeTypesMap.put("application/pkix-attr-cert", Arrays.asList("ac"));
        mimeTypesMap.put("application/pkix-cert", Arrays.asList("cer"));
        mimeTypesMap.put("application/pkix-crl", Arrays.asList("crl"));
        mimeTypesMap.put("application/pkix-pkipath", Arrays.asList("pkipath"));
        mimeTypesMap.put("application/pkixcmp", Arrays.asList("pki"));
        mimeTypesMap.put("application/pls+xml", Arrays.asList("pls"));
        mimeTypesMap.put("application/postscript", Arrays.asList("ps", "eps", "ai"));
        mimeTypesMap.put("application/pro_eng", Arrays.asList("prt", "part"));
        mimeTypesMap.put("application/prs.cww", Arrays.asList("cww"));
        mimeTypesMap.put("application/pskc+xml", Arrays.asList("pskcxml"));
        mimeTypesMap.put("application/rdf+xml", Arrays.asList("rdf"));
        mimeTypesMap.put("application/reginfo+xml", Arrays.asList("rif"));
        mimeTypesMap.put("application/relax-ng-compact-syntax", Arrays.asList("rnc"));
        mimeTypesMap.put("application/resource-lists+xml", Arrays.asList("rl"));
        mimeTypesMap.put("application/resource-lists-diff+xml", Arrays.asList("rld"));
        mimeTypesMap.put("application/rls-services+xml", Arrays.asList("rs"));
        mimeTypesMap.put("application/rsd+xml", Arrays.asList("rsd"));
        mimeTypesMap.put("application/rss+xml", Arrays.asList("rss"));
        mimeTypesMap.put("application/rtf", Arrays.asList("rtf"));
        mimeTypesMap.put("application/sbml+xml", Arrays.asList("sbml"));
        mimeTypesMap.put("application/scvp-cv-request", Arrays.asList("scq"));
        mimeTypesMap.put("application/scvp-cv-response", Arrays.asList("scs"));
        mimeTypesMap.put("application/scvp-vp-request", Arrays.asList("spq"));
        mimeTypesMap.put("application/scvp-vp-response", Arrays.asList("spp"));
        mimeTypesMap.put("application/sdp", Arrays.asList("sdp"));
        mimeTypesMap.put("application/set", Arrays.asList("set"));
        mimeTypesMap.put("application/set-payment-initiation", Arrays.asList("setpay"));
        mimeTypesMap.put("application/set-registration-initiation", Arrays.asList("setreg"));
        mimeTypesMap.put("application/shf+xml", Arrays.asList("shf"));
        mimeTypesMap.put("application/smil", Arrays.asList("smi", "smil"));
        mimeTypesMap.put("application/smil+xml", Arrays.asList("smi", "smil"));
        mimeTypesMap.put("application/solids", Arrays.asList("sol"));
        mimeTypesMap.put("application/sounder", Arrays.asList("sdr"));
        mimeTypesMap.put("application/sparql-query", Arrays.asList("rq"));
        mimeTypesMap.put("application/sparql-results+xml", Arrays.asList("srx"));
        mimeTypesMap.put("application/srgs", Arrays.asList("gram"));
        mimeTypesMap.put("application/srgs+xml", Arrays.asList("grxml"));
        mimeTypesMap.put("application/sru+xml", Arrays.asList("sru"));
        mimeTypesMap.put("application/ssml+xml", Arrays.asList("ssml"));
        mimeTypesMap.put("application/step", Arrays.asList("step", "stp"));
        mimeTypesMap.put("application/streamingmedia", Arrays.asList("ssm"));
        mimeTypesMap.put("application/tei+xml", Arrays.asList("tei"));
        mimeTypesMap.put("application/thraud+xml", Arrays.asList("tfi"));
        mimeTypesMap.put("application/timestamped-data", Arrays.asList("tsd"));
        mimeTypesMap.put("application/vda", Arrays.asList("vda"));
        mimeTypesMap.put("application/vnd.3gpp.pic-bw-large", Arrays.asList("plb"));
        mimeTypesMap.put("application/vnd.3gpp.pic-bw-small", Arrays.asList("psb"));
        mimeTypesMap.put("application/vnd.3gpp.pic-bw-var", Arrays.asList("pvb"));
        mimeTypesMap.put("application/vnd.3gpp2.tcap", Arrays.asList("tcap"));
        mimeTypesMap.put("application/vnd.3m.post-it-notes", Arrays.asList("pwn"));
        mimeTypesMap.put("application/vnd.accpac.simply.aso", Arrays.asList("aso"));
        mimeTypesMap.put("application/vnd.accpac.simply.imp", Arrays.asList("imp"));
        mimeTypesMap.put("application/vnd.acucobol", Arrays.asList("acu"));
        mimeTypesMap.put("application/vnd.acucorp", Arrays.asList("acutc", "atc"));
        mimeTypesMap.put("application/vnd.adobe.air-application-installer-package+zip", Arrays.asList("air"));
        mimeTypesMap.put("application/vnd.adobe.fxp", Arrays.asList("fxp"));
        mimeTypesMap.put("application/vnd.adobe.xdp+xml", Arrays.asList("xdp"));
        mimeTypesMap.put("application/vnd.adobe.xfdf", Arrays.asList("xfdf"));
        mimeTypesMap.put("application/vnd.ahead.space", Arrays.asList("ahead"));
        mimeTypesMap.put("application/vnd.airzip.filesecure.azf", Arrays.asList("azf"));
        mimeTypesMap.put("application/vnd.airzip.filesecure.azs", Arrays.asList("azs"));
        mimeTypesMap.put("application/vnd.amazon.ebook", Arrays.asList("azw"));
        mimeTypesMap.put("application/vnd.americandynamics.acc", Arrays.asList("acc"));
        mimeTypesMap.put("application/vnd.amiga.ami", Arrays.asList("ami"));
        mimeTypesMap.put("application/vnd.android.package-archive", Arrays.asList("apk"));
        mimeTypesMap.put("application/vnd.anser-web-certificate-issue-initiation", Arrays.asList("cii"));
        mimeTypesMap.put("application/vnd.anser-web-funds-transfer-initiation", Arrays.asList("fti"));
        mimeTypesMap.put("application/vnd.antix.game-component", Arrays.asList("atx"));
        mimeTypesMap.put("application/vnd.apple.installer+xml", Arrays.asList("mpkg"));
        mimeTypesMap.put("application/vnd.apple.mpegurl", Arrays.asList("m3u8"));
        mimeTypesMap.put("application/vnd.arastra.swi", Arrays.asList("swi"));
        mimeTypesMap.put("application/vnd.aristanetworks.swi", Arrays.asList("swi"));
        mimeTypesMap.put("application/vnd.audiograph", Arrays.asList("aep"));
        mimeTypesMap.put("application/vnd.blueice.multipass", Arrays.asList("mpm"));
        mimeTypesMap.put("application/vnd.bmi", Arrays.asList("bmi"));
        mimeTypesMap.put("application/vnd.businessobjects", Arrays.asList("rep"));
        mimeTypesMap.put("application/vnd.chemdraw+xml", Arrays.asList("cdxml"));
        mimeTypesMap.put("application/vnd.chipnuts.karaoke-mmd", Arrays.asList("mmd"));
        mimeTypesMap.put("application/vnd.cinderella", Arrays.asList("cdy"));
        mimeTypesMap.put("application/vnd.claymore", Arrays.asList("cla"));
        mimeTypesMap.put("application/vnd.cloanto.rp9", Arrays.asList("rp9"));
        mimeTypesMap.put("application/vnd.clonk.c4group", Arrays.asList("c4d", "c4f", "c4g", "c4p", "c4u"));
        mimeTypesMap.put("application/vnd.cluetrust.cartomobile-config", Arrays.asList("c11amc"));
        mimeTypesMap.put("application/vnd.cluetrust.cartomobile-config-pkg", Arrays.asList("c11amz"));
        mimeTypesMap.put("application/vnd.commonspace", Arrays.asList("csp"));
        mimeTypesMap.put("application/vnd.contact.cmsg", Arrays.asList("cdbcmsg"));
        mimeTypesMap.put("application/vnd.cosmocaller", Arrays.asList("cmc"));
        mimeTypesMap.put("application/vnd.crick.clicker", Arrays.asList("clkx"));
        mimeTypesMap.put("application/vnd.crick.clicker.keyboard", Arrays.asList("clkk"));
        mimeTypesMap.put("application/vnd.crick.clicker.palette", Arrays.asList("clkp"));
        mimeTypesMap.put("application/vnd.crick.clicker.template", Arrays.asList("clkt"));
        mimeTypesMap.put("application/vnd.crick.clicker.wordbank", Arrays.asList("clkw"));
        mimeTypesMap.put("application/vnd.criticaltools.wbs+xml", Arrays.asList("wbs"));
        mimeTypesMap.put("application/vnd.ctc-posml", Arrays.asList("pml"));
        mimeTypesMap.put("application/vnd.cups-ppd", Arrays.asList("ppd"));
        mimeTypesMap.put("application/vnd.curl.car", Arrays.asList("car"));
        mimeTypesMap.put("application/vnd.curl.pcurl", Arrays.asList("pcurl"));
        mimeTypesMap.put("application/vnd.data-vision.rdz", Arrays.asList("rdz"));
        mimeTypesMap.put("application/vnd.denovo.fcselayout-link", Arrays.asList("fe_launch"));
        mimeTypesMap.put("application/vnd.dna", Arrays.asList("dna"));
        mimeTypesMap.put("application/vnd.dolby.mlp", Arrays.asList("mlp"));
        mimeTypesMap.put("application/vnd.dpgraph", Arrays.asList("dpg"));
        mimeTypesMap.put("application/vnd.dreamfactory", Arrays.asList("dfac"));
        mimeTypesMap.put("application/vnd.dvb.ait", Arrays.asList("ait"));
        mimeTypesMap.put("application/vnd.dvb.service", Arrays.asList("svc"));
        mimeTypesMap.put("application/vnd.dynageo", Arrays.asList("geo"));
        mimeTypesMap.put("application/vnd.ecowin.chart", Arrays.asList("mag"));
        mimeTypesMap.put("application/vnd.enliven", Arrays.asList("nml"));
        mimeTypesMap.put("application/vnd.epson.esf", Arrays.asList("esf"));
        mimeTypesMap.put("application/vnd.epson.msf", Arrays.asList("msf"));
        mimeTypesMap.put("application/vnd.epson.quickanime", Arrays.asList("qam"));
        mimeTypesMap.put("application/vnd.epson.salt", Arrays.asList("slt"));
        mimeTypesMap.put("application/vnd.epson.ssf", Arrays.asList("ssf"));
        mimeTypesMap.put("application/vnd.eszigno3+xml", Arrays.asList("es3", "et3"));
        mimeTypesMap.put("application/vnd.ezpix-album", Arrays.asList("ez2"));
        mimeTypesMap.put("application/vnd.ezpix-package", Arrays.asList("ez3"));
        mimeTypesMap.put("application/vnd.fdf", Arrays.asList("fdf"));
        mimeTypesMap.put("application/vnd.fdsn.mseed", Arrays.asList("mseed"));
        mimeTypesMap.put("application/vnd.fdsn.seed", Arrays.asList("dataless", "seed"));
        mimeTypesMap.put("application/vnd.flographit", Arrays.asList("gph"));
        mimeTypesMap.put("application/vnd.fluxtime.clip", Arrays.asList("ftc"));
        mimeTypesMap.put("application/vnd.framemaker", Arrays.asList("book", "fm", "frame", "maker"));
        mimeTypesMap.put("application/vnd.frogans.fnc", Arrays.asList("fnc"));
        mimeTypesMap.put("application/vnd.frogans.ltf", Arrays.asList("ltf"));
        mimeTypesMap.put("application/vnd.fsc.weblaunch", Arrays.asList("fsc"));
        mimeTypesMap.put("application/vnd.fujitsu.oasys", Arrays.asList("oas"));
        mimeTypesMap.put("application/vnd.fujitsu.oasys2", Arrays.asList("oa2"));
        mimeTypesMap.put("application/vnd.fujitsu.oasys3", Arrays.asList("oa3"));
        mimeTypesMap.put("application/vnd.fujitsu.oasysgp", Arrays.asList("fg5"));
        mimeTypesMap.put("application/vnd.fujitsu.oasysprs", Arrays.asList("bh2"));
        mimeTypesMap.put("application/vnd.fujixerox.ddd", Arrays.asList("ddd"));
        mimeTypesMap.put("application/vnd.fujixerox.docuworks", Arrays.asList("xdw"));
        mimeTypesMap.put("application/vnd.fujixerox.docuworks.binder", Arrays.asList("xbd"));
        mimeTypesMap.put("application/vnd.fuzzysheet", Arrays.asList("fzs"));
        mimeTypesMap.put("application/vnd.genomatix.tuxedo", Arrays.asList("txd"));
        mimeTypesMap.put("application/vnd.geogebra.file", Arrays.asList("ggb"));
        mimeTypesMap.put("application/vnd.geogebra.tool", Arrays.asList("ggt"));
        mimeTypesMap.put("application/vnd.geometry-explorer", Arrays.asList("gex", "gre"));
        mimeTypesMap.put("application/vnd.geonext", Arrays.asList("gxt"));
        mimeTypesMap.put("application/vnd.geoplan", Arrays.asList("g2w"));
        mimeTypesMap.put("application/vnd.geospace", Arrays.asList("g3w"));
        mimeTypesMap.put("application/vnd.gmx", Arrays.asList("gmx"));
        mimeTypesMap.put("application/vnd.google-earth.kml+xml", Arrays.asList("kml"));
        mimeTypesMap.put("application/vnd.google-earth.kmz", Arrays.asList("kmz"));
        mimeTypesMap.put("application/vnd.grafeq", Arrays.asList("gqf", "gqs"));
        mimeTypesMap.put("application/vnd.groove-account", Arrays.asList("gac"));
        mimeTypesMap.put("application/vnd.groove-help", Arrays.asList("ghf"));
        mimeTypesMap.put("application/vnd.groove-identity-message", Arrays.asList("gim"));
        mimeTypesMap.put("application/vnd.groove-injector", Arrays.asList("grv"));
        mimeTypesMap.put("application/vnd.groove-tool-message", Arrays.asList("gtm"));
        mimeTypesMap.put("application/vnd.groove-tool-template", Arrays.asList("tpl"));
        mimeTypesMap.put("application/vnd.groove-vcard", Arrays.asList("vcg"));
        mimeTypesMap.put("application/vnd.hal+xml", Arrays.asList("hal"));
        mimeTypesMap.put("application/vnd.handheld-entertainment+xml", Arrays.asList("zmm"));
        mimeTypesMap.put("application/vnd.hbci", Arrays.asList("hbci"));
        mimeTypesMap.put("application/vnd.hhe.lesson-player", Arrays.asList("les"));
        mimeTypesMap.put("application/vnd.hp-hpgl", Arrays.asList("hpgl", "hgl", "hpg"));
        mimeTypesMap.put("application/vnd.hp-hpid", Arrays.asList("hpid"));
        mimeTypesMap.put("application/vnd.hp-hps", Arrays.asList("hps"));
        mimeTypesMap.put("application/vnd.hp-jlyt", Arrays.asList("jlt"));
        mimeTypesMap.put("application/vnd.hp-pcl", Arrays.asList("pcl"));
        mimeTypesMap.put("application/vnd.hp-pclxl", Arrays.asList("pclxl"));
        mimeTypesMap.put("application/vnd.hydrostatix.sof-data", Arrays.asList("sfd-hdstx"));
        mimeTypesMap.put("application/vnd.hzn-3d-crossword", Arrays.asList("x3d"));
        mimeTypesMap.put("application/vnd.ibm.minipay", Arrays.asList("mpy"));
        mimeTypesMap.put("application/vnd.ibm.modcap", Arrays.asList("afp", "list3820", "listafp"));
        mimeTypesMap.put("application/vnd.ibm.rights-management", Arrays.asList("irm"));
        mimeTypesMap.put("application/vnd.ibm.secure-container", Arrays.asList("sc"));
        mimeTypesMap.put("application/vnd.iccprofile", Arrays.asList("icc", "icm"));
        mimeTypesMap.put("application/vnd.igloader", Arrays.asList("igl"));
        mimeTypesMap.put("application/vnd.immervision-ivp", Arrays.asList("ivp"));
        mimeTypesMap.put("application/vnd.immervision-ivu", Arrays.asList("ivu"));
        mimeTypesMap.put("application/vnd.insors.igm", Arrays.asList("igm"));
        mimeTypesMap.put("application/vnd.intercon.formnet", Arrays.asList("xpw", "xpx"));
        mimeTypesMap.put("application/vnd.intergeo", Arrays.asList("i2g"));
        mimeTypesMap.put("application/vnd.intu.qbo", Arrays.asList("qbo"));
        mimeTypesMap.put("application/vnd.intu.qfx", Arrays.asList("qfx"));
        mimeTypesMap.put("application/vnd.ipunplugged.rcprofile", Arrays.asList("rcprofile"));
        mimeTypesMap.put("application/vnd.irepository.package+xml", Arrays.asList("irp"));
        mimeTypesMap.put("application/vnd.is-xpr", Arrays.asList("xpr"));
        mimeTypesMap.put("application/vnd.isac.fcs", Arrays.asList("fcs"));
        mimeTypesMap.put("application/vnd.jam", Arrays.asList("jam"));
        mimeTypesMap.put("application/vnd.jcp.javame.midlet-rms", Arrays.asList("rms"));
        mimeTypesMap.put("application/vnd.jisp", Arrays.asList("jisp"));
        mimeTypesMap.put("application/vnd.joost.joda-archive", Arrays.asList("joda"));
        mimeTypesMap.put("application/vnd.kahootz", Arrays.asList("ktr", "ktz"));
        mimeTypesMap.put("application/vnd.kde.karbon", Arrays.asList("karbon"));
        mimeTypesMap.put("application/vnd.kde.kchart", Arrays.asList("chrt"));
        mimeTypesMap.put("application/vnd.kde.kformula", Arrays.asList("kfo"));
        mimeTypesMap.put("application/vnd.kde.kivio", Arrays.asList("flw"));
        mimeTypesMap.put("application/vnd.kde.kontour", Arrays.asList("kon"));
        mimeTypesMap.put("application/vnd.kde.kpresenter", Arrays.asList("kpr", "kpt"));
        mimeTypesMap.put("application/vnd.kde.kspread", Arrays.asList("ksp"));
        mimeTypesMap.put("application/vnd.kde.kword", Arrays.asList("kwd", "kwt"));
        mimeTypesMap.put("application/vnd.kenameaapp", Arrays.asList("htke"));
        mimeTypesMap.put("application/vnd.kidspiration", Arrays.asList("kia"));
        mimeTypesMap.put("application/vnd.kinar", Arrays.asList("kne", "knp"));
        mimeTypesMap.put("application/vnd.koan", Arrays.asList("skd", "skt", "skm", "skp"));
        mimeTypesMap.put("application/vnd.kodak-descriptor", Arrays.asList("sse"));
        mimeTypesMap.put("application/vnd.las.las+xml", Arrays.asList("lasxml"));
        mimeTypesMap.put("application/vnd.llamagraphics.life-balance.desktop", Arrays.asList("lbd"));
        mimeTypesMap.put("application/vnd.llamagraphics.life-balance.exchange+xml", Arrays.asList("lbe"));
        mimeTypesMap.put("application/vnd.lotus-1-2-3", Arrays.asList("123"));
        mimeTypesMap.put("application/vnd.lotus-approach", Arrays.asList("apr"));
        mimeTypesMap.put("application/vnd.lotus-freelance", Arrays.asList("pre"));
        mimeTypesMap.put("application/vnd.lotus-notes", Arrays.asList("nsf"));
        mimeTypesMap.put("application/vnd.lotus-organizer", Arrays.asList("org"));
        mimeTypesMap.put("application/vnd.lotus-screencam", Arrays.asList("scm"));
        mimeTypesMap.put("application/vnd.lotus-wordpro", Arrays.asList("lwp"));
        mimeTypesMap.put("application/vnd.macports.portpkg", Arrays.asList("portpkg"));
        mimeTypesMap.put("application/vnd.mcd", Arrays.asList("mcd"));
        mimeTypesMap.put("application/vnd.medcalcdata", Arrays.asList("mc1"));
        mimeTypesMap.put("application/vnd.mediastation.cdkey", Arrays.asList("cdkey"));
        mimeTypesMap.put("application/vnd.mfer", Arrays.asList("mwf"));
        mimeTypesMap.put("application/vnd.mfmp", Arrays.asList("mfm"));
        mimeTypesMap.put("application/vnd.micrografx.flo", Arrays.asList("flo"));
        mimeTypesMap.put("application/vnd.micrografx.igx", Arrays.asList("igx"));
        mimeTypesMap.put("application/vnd.mif", Arrays.asList("mif"));
        mimeTypesMap.put("application/vnd.mobius.daf", Arrays.asList("daf"));
        mimeTypesMap.put("application/vnd.mobius.dis", Arrays.asList("dis"));
        mimeTypesMap.put("application/vnd.mobius.mbk", Arrays.asList("mbk"));
        mimeTypesMap.put("application/vnd.mobius.mqy", Arrays.asList("mqy"));
        mimeTypesMap.put("application/vnd.mobius.msl", Arrays.asList("msl"));
        mimeTypesMap.put("application/vnd.mobius.plc", Arrays.asList("plc"));
        mimeTypesMap.put("application/vnd.mobius.txf", Arrays.asList("txf"));
        mimeTypesMap.put("application/vnd.mophun.application", Arrays.asList("mpn"));
        mimeTypesMap.put("application/vnd.mophun.certificate", Arrays.asList("mpc"));
        mimeTypesMap.put("application/vnd.mozilla.xul+xml", Arrays.asList("xul"));
        mimeTypesMap.put("application/vnd.ms-artgalry", Arrays.asList("cil"));
        mimeTypesMap.put("application/vnd.ms-cab-compressed", Arrays.asList("cab"));
        mimeTypesMap.put("application/vnd.ms-excel", Arrays.asList("xls", "xla", "xlc", "xlm", "xlt", "xlw"));
        mimeTypesMap.put("application/vnd.ms-excel.addin.macroenabled.12", Arrays.asList("xlam"));
        mimeTypesMap.put("application/vnd.ms-excel.sheet.binary.macroenabled.12", Arrays.asList("xlsb"));
        mimeTypesMap.put("application/vnd.ms-excel.sheet.macroenabled.12", Arrays.asList("xlsm"));
        mimeTypesMap.put("application/vnd.ms-excel.template.macroenabled.12", Arrays.asList("xltm"));
        mimeTypesMap.put("application/vnd.ms-fontobject", Arrays.asList("eot"));
        mimeTypesMap.put("application/vnd.ms-htmlhelp", Arrays.asList("chm"));
        mimeTypesMap.put("application/vnd.ms-ims", Arrays.asList("ims"));
        mimeTypesMap.put("application/vnd.ms-lrm", Arrays.asList("lrm"));
        mimeTypesMap.put("application/vnd.ms-officetheme", Arrays.asList("thmx"));
        mimeTypesMap.put("application/vnd.ms-outlook", Arrays.asList("msg"));
        mimeTypesMap.put("application/vnd.ms-pki.certstore", Arrays.asList("sst"));
        mimeTypesMap.put("application/vnd.ms-pki.pko", Arrays.asList("pko"));
        mimeTypesMap.put("application/vnd.ms-pki.seccat", Arrays.asList("cat"));
        mimeTypesMap.put("application/vnd.ms-pki.stl", Arrays.asList("stl"));
        mimeTypesMap.put("application/vnd.ms-pkicertstore", Arrays.asList("sst"));
        mimeTypesMap.put("application/vnd.ms-pkiseccat", Arrays.asList("cat"));
        mimeTypesMap.put("application/vnd.ms-pkistl", Arrays.asList("stl"));
        mimeTypesMap.put("application/vnd.ms-powerpoint", Arrays.asList("ppt", "pps", "pot"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.addin.macroenabled.12", Arrays.asList("ppam"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.presentation.macroenabled.12", Arrays.asList("pptm"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.slide.macroenabled.12", Arrays.asList("sldm"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.slideshow.macroenabled.12", Arrays.asList("ppsm"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.template.macroenabled.12", Arrays.asList("potm"));
        mimeTypesMap.put("application/vnd.ms-project", Arrays.asList("mpp"));
        mimeTypesMap.put("application/vnd.ms-word.document.macroenabled.12", Arrays.asList("docm"));
        mimeTypesMap.put("application/vnd.ms-word.template.macroenabled.12", Arrays.asList("dotm"));
        mimeTypesMap.put("application/vnd.ms-works", Arrays.asList("wps", "wks", "wdb", "wcm"));
        mimeTypesMap.put("application/vnd.ms-wpl", Arrays.asList("wpl"));
        mimeTypesMap.put("application/vnd.ms-xpsdocument", Arrays.asList("xps"));
        mimeTypesMap.put("application/vnd.mseq", Arrays.asList("mseq"));
        mimeTypesMap.put("application/vnd.musician", Arrays.asList("mus"));
        mimeTypesMap.put("application/vnd.muvee.style", Arrays.asList("msty"));
        mimeTypesMap.put("application/vnd.neurolanguage.nlu", Arrays.asList("nlu"));
        mimeTypesMap.put("application/vnd.noblenet-directory", Arrays.asList("nnd"));
        mimeTypesMap.put("application/vnd.noblenet-sealer", Arrays.asList("nns"));
        mimeTypesMap.put("application/vnd.noblenet-web", Arrays.asList("nnw"));
        mimeTypesMap.put("application/vnd.nokia.configuration-message", Arrays.asList("ncm"));
        mimeTypesMap.put("application/vnd.nokia.n-gage.data", Arrays.asList("ngdat"));
        mimeTypesMap.put("application/vnd.nokia.n-gage.symbian.install", Arrays.asList("n-gage"));
        mimeTypesMap.put("application/vnd.nokia.radio-preset", Arrays.asList("rpst"));
        mimeTypesMap.put("application/vnd.nokia.radio-presets", Arrays.asList("rpss"));
        mimeTypesMap.put("application/vnd.nokia.ringing-tone", Arrays.asList("rng"));
        mimeTypesMap.put("application/vnd.novadigm.edm", Arrays.asList("edm"));
        mimeTypesMap.put("application/vnd.novadigm.edx", Arrays.asList("edx"));
        mimeTypesMap.put("application/vnd.novadigm.ext", Arrays.asList("ext"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.chart", Arrays.asList("odc"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.chart-template", Arrays.asList("otc"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.database", Arrays.asList("odb"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.formula", Arrays.asList("odf"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.formula-template", Arrays.asList("odft"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.graphics", Arrays.asList("odg"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.graphics-template", Arrays.asList("otg"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.image", Arrays.asList("odi"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.image-template", Arrays.asList("oti"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.presentation", Arrays.asList("odp"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.presentation-template", Arrays.asList("otp"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.spreadsheet", Arrays.asList("ods"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.spreadsheet-template", Arrays.asList("ots"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text", Arrays.asList("odt"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text-master", Arrays.asList("otm", "odm"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text-template", Arrays.asList("ott"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text-web", Arrays.asList("oth"));
        mimeTypesMap.put("application/vnd.olpc-sugar", Arrays.asList("xo"));
        mimeTypesMap.put("application/vnd.oma.dd2+xml", Arrays.asList("dd2"));
        mimeTypesMap.put("application/vnd.openofficeorg.extension", Arrays.asList("oxt"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", Arrays.asList("pptx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.slide", Arrays.asList("sldx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.slideshow", Arrays.asList("ppsx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.template", Arrays.asList("potx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", Arrays.asList("xlsx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.template", Arrays.asList("xltx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", Arrays.asList("docx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.template", Arrays.asList("dotx"));
        mimeTypesMap.put("application/vnd.osgeo.mapguide.package", Arrays.asList("mgp"));
        mimeTypesMap.put("application/vnd.osgi.dp", Arrays.asList("dp"));
        mimeTypesMap.put("application/vnd.palm", Arrays.asList("oprc", "pqa", "pdb"));
        mimeTypesMap.put("application/vnd.pawaafile", Arrays.asList("paw"));
        mimeTypesMap.put("application/vnd.pg.format", Arrays.asList("str"));
        mimeTypesMap.put("application/vnd.pg.osasli", Arrays.asList("ei6"));
        mimeTypesMap.put("application/vnd.picsel", Arrays.asList("efif"));
        mimeTypesMap.put("application/vnd.pmi.widget", Arrays.asList("wg"));
        mimeTypesMap.put("application/vnd.pocketlearn", Arrays.asList("plf"));
        mimeTypesMap.put("application/vnd.powerbuilder6", Arrays.asList("pbd"));
        mimeTypesMap.put("application/vnd.previewsystems.box", Arrays.asList("box"));
        mimeTypesMap.put("application/vnd.proteus.magazine", Arrays.asList("mgz"));
        mimeTypesMap.put("application/vnd.publishare-delta-tree", Arrays.asList("qps"));
        mimeTypesMap.put("application/vnd.pvi.ptid1", Arrays.asList("ptid"));
        mimeTypesMap.put("application/vnd.quark.quarkxpress", Arrays.asList("qwd", "qwt", "qxb", "qxd", "qxl", "qxt"));
        mimeTypesMap.put("application/vnd.realvnc.bed", Arrays.asList("bed"));
        mimeTypesMap.put("application/vnd.recordare.musicxml", Arrays.asList("mxl"));
        mimeTypesMap.put("application/vnd.recordare.musicxml+xml", Arrays.asList("musicxml"));
        mimeTypesMap.put("application/vnd.rig.cryptonote", Arrays.asList("cryptonote"));
        mimeTypesMap.put("application/vnd.rim.cod", Arrays.asList("cod"));
        mimeTypesMap.put("application/vnd.rn-realmedia", Arrays.asList("rm"));
        mimeTypesMap.put("application/vnd.rn-realplayer", Arrays.asList("rnx"));
        mimeTypesMap.put("application/vnd.route66.link66+xml", Arrays.asList("link66"));
        mimeTypesMap.put("application/vnd.sailingtracker.track", Arrays.asList("st"));
        mimeTypesMap.put("application/vnd.seemail", Arrays.asList("see"));
        mimeTypesMap.put("application/vnd.sema", Arrays.asList("sema"));
        mimeTypesMap.put("application/vnd.semd", Arrays.asList("semd"));
        mimeTypesMap.put("application/vnd.semf", Arrays.asList("semf"));
        mimeTypesMap.put("application/vnd.shana.informed.formdata", Arrays.asList("ifm"));
        mimeTypesMap.put("application/vnd.shana.informed.formtemplate", Arrays.asList("itp"));
        mimeTypesMap.put("application/vnd.shana.informed.interchange", Arrays.asList("iif"));
        mimeTypesMap.put("application/vnd.shana.informed.package", Arrays.asList("ipk"));
        mimeTypesMap.put("application/vnd.simtech-mindmapper", Arrays.asList("twd", "twds"));
        mimeTypesMap.put("application/vnd.smaf", Arrays.asList("mmf"));
        mimeTypesMap.put("application/vnd.smart.teacher", Arrays.asList("teacher"));
        mimeTypesMap.put("application/vnd.solent.sdkm+xml", Arrays.asList("sdkd", "sdkm"));
        mimeTypesMap.put("application/vnd.spotfire.dxp", Arrays.asList("dxp"));
        mimeTypesMap.put("application/vnd.spotfire.sfs", Arrays.asList("sfs"));
        mimeTypesMap.put("application/vnd.stardivision.calc", Arrays.asList("sdc"));
        mimeTypesMap.put("application/vnd.stardivision.draw", Arrays.asList("sda"));
        mimeTypesMap.put("application/vnd.stardivision.impress", Arrays.asList("sdd"));
        mimeTypesMap.put("application/vnd.stardivision.math", Arrays.asList("smf"));
        mimeTypesMap.put("application/vnd.stardivision.writer", Arrays.asList("sdw", "vor"));
        mimeTypesMap.put("application/vnd.stardivision.writer-global", Arrays.asList("sgl"));
        mimeTypesMap.put("application/vnd.stepmania.stepchart", Arrays.asList("sm"));
        mimeTypesMap.put("application/vnd.sun.xml.calc", Arrays.asList("sxc"));
        mimeTypesMap.put("application/vnd.sun.xml.calc.template", Arrays.asList("stc"));
        mimeTypesMap.put("application/vnd.sun.xml.draw", Arrays.asList("sxd"));
        mimeTypesMap.put("application/vnd.sun.xml.draw.template", Arrays.asList("std"));
        mimeTypesMap.put("application/vnd.sun.xml.impress", Arrays.asList("sxi"));
        mimeTypesMap.put("application/vnd.sun.xml.impress.template", Arrays.asList("sti"));
        mimeTypesMap.put("application/vnd.sun.xml.math", Arrays.asList("sxm"));
        mimeTypesMap.put("application/vnd.sun.xml.writer", Arrays.asList("sxw"));
        mimeTypesMap.put("application/vnd.sun.xml.writer.global", Arrays.asList("sxg"));
        mimeTypesMap.put("application/vnd.sun.xml.writer.template", Arrays.asList("stw"));
        mimeTypesMap.put("application/vnd.sus-calendar", Arrays.asList("sus", "susp"));
        mimeTypesMap.put("application/vnd.svd", Arrays.asList("svd"));
        mimeTypesMap.put("application/vnd.symbian.install", Arrays.asList("sis", "sisx"));
        mimeTypesMap.put("application/vnd.syncml+xml", Arrays.asList("xsm"));
        mimeTypesMap.put("application/vnd.syncml.dm+wbxml", Arrays.asList("bdm"));
        mimeTypesMap.put("application/vnd.syncml.dm+xml", Arrays.asList("xdm"));
        mimeTypesMap.put("application/vnd.tao.intent-module-archive", Arrays.asList("tao"));
        mimeTypesMap.put("application/vnd.tmobile-livetv", Arrays.asList("tmo"));
        mimeTypesMap.put("application/vnd.trid.tpt", Arrays.asList("tpt"));
        mimeTypesMap.put("application/vnd.triscape.mxs", Arrays.asList("mxs"));
        mimeTypesMap.put("application/vnd.trueapp", Arrays.asList("tra"));
        mimeTypesMap.put("application/vnd.ufdl", Arrays.asList("ufd", "ufdl"));
        mimeTypesMap.put("application/vnd.uiq.theme", Arrays.asList("utz"));
        mimeTypesMap.put("application/vnd.umajin", Arrays.asList("umj"));
        mimeTypesMap.put("application/vnd.unity", Arrays.asList("unityweb"));
        mimeTypesMap.put("application/vnd.uoml+xml", Arrays.asList("uoml"));
        mimeTypesMap.put("application/vnd.vcx", Arrays.asList("vcx"));
        mimeTypesMap.put("application/vnd.visio", Arrays.asList("vsd", "vsw", "vss", "vst"));
        mimeTypesMap.put("application/vnd.visio2013", Arrays.asList("vsdx"));
        mimeTypesMap.put("application/vnd.visionary", Arrays.asList("vis"));
        mimeTypesMap.put("application/vnd.vsf", Arrays.asList("vsf"));
        mimeTypesMap.put("application/vnd.wap.sic", Arrays.asList("sic"));
        mimeTypesMap.put("application/vnd.wap.slc", Arrays.asList("slc"));
        mimeTypesMap.put("application/vnd.wap.wbxml", Arrays.asList("wbxml"));
        mimeTypesMap.put("application/vnd.wap.wmlc", Arrays.asList("wmlc"));
        mimeTypesMap.put("application/vnd.wap.wmlscriptc", Arrays.asList("wmlsc"));
        mimeTypesMap.put("application/vnd.webturbo", Arrays.asList("wtb"));
        mimeTypesMap.put("application/vnd.wolfram.player", Arrays.asList("nbp"));
        mimeTypesMap.put("application/vnd.wordperfect", Arrays.asList("wpd"));
        mimeTypesMap.put("application/vnd.wqd", Arrays.asList("wqd"));
        mimeTypesMap.put("application/vnd.wt.stf", Arrays.asList("stf"));
        mimeTypesMap.put("application/vnd.xara", Arrays.asList("web", "xar"));
        mimeTypesMap.put("application/vnd.xfdl", Arrays.asList("xfdl"));
        mimeTypesMap.put("application/vnd.yamaha.hv-dic", Arrays.asList("hvd"));
        mimeTypesMap.put("application/vnd.yamaha.hv-script", Arrays.asList("hvs"));
        mimeTypesMap.put("application/vnd.yamaha.hv-voice", Arrays.asList("hvp"));
        mimeTypesMap.put("application/vnd.yamaha.openscoreformat", Arrays.asList("osf"));
        mimeTypesMap.put("application/vnd.yamaha.openscoreformat.osfpvg+xml", Arrays.asList("osfpvg"));
        mimeTypesMap.put("application/vnd.yamaha.smaf-audio", Arrays.asList("saf"));
        mimeTypesMap.put("application/vnd.yamaha.smaf-phrase", Arrays.asList("spf"));
        mimeTypesMap.put("application/vnd.yellowriver-custom-menu", Arrays.asList("cmp"));
        mimeTypesMap.put("application/vnd.zul", Arrays.asList("zir", "zirz"));
        mimeTypesMap.put("application/vnd.zzazz.deck+xml", Arrays.asList("zaz"));
        mimeTypesMap.put("application/vocaltec-media-desc", Arrays.asList("vmd"));
        mimeTypesMap.put("application/vocaltec-media-file", Arrays.asList("vmf"));
        mimeTypesMap.put("application/voicexml+xml", Arrays.asList("vxml"));
        mimeTypesMap.put("application/widget", Arrays.asList("wgt"));
        mimeTypesMap.put("application/winhlp", Arrays.asList("hlp"));
        mimeTypesMap.put("application/wordperfect", Arrays.asList("wp", "wp6"));
        mimeTypesMap.put("application/wordperfect6.0", Arrays.asList("w60", "wp5"));
        mimeTypesMap.put("application/wordperfect6.1", Arrays.asList("w61"));
        mimeTypesMap.put("application/wsdl+xml", Arrays.asList("wsdl"));
        mimeTypesMap.put("application/wspolicy+xml", Arrays.asList("wspolicy"));
        mimeTypesMap.put("application/x-123", Arrays.asList("wk1"));
        mimeTypesMap.put("application/x-7z-compressed", Arrays.asList("7z"));
        mimeTypesMap.put("application/x-abiword", Arrays.asList("abw"));
        mimeTypesMap.put("application/x-ace-compressed", Arrays.asList("ace"));
        mimeTypesMap.put("application/x-aim", Arrays.asList("aim"));
        mimeTypesMap.put("application/x-apple-diskimage", Arrays.asList("dmg"));
        mimeTypesMap.put("application/x-authorware-bin", Arrays.asList("aab"));
        mimeTypesMap.put("application/x-authorware-map", Arrays.asList("aam"));
        mimeTypesMap.put("application/x-authorware-seg", Arrays.asList("aas"));
        mimeTypesMap.put("application/x-bcpio", Arrays.asList("bcpio"));
        mimeTypesMap.put("application/x-bittorrent", Arrays.asList("torrent"));
        mimeTypesMap.put("application/x-bsh", Arrays.asList("bsh"));
        mimeTypesMap.put("application/x-bytecode.python", Arrays.asList("pyc"));
        mimeTypesMap.put("application/x-bzip", Arrays.asList("bz"));
        mimeTypesMap.put("application/x-bzip2", Arrays.asList("boz", "bz2"));
        mimeTypesMap.put("application/x-cdf", Arrays.asList("cdf"));
        mimeTypesMap.put("application/x-cdlink", Arrays.asList("vcd"));
        mimeTypesMap.put("application/x-chat", Arrays.asList("cha", "chat"));
        mimeTypesMap.put("application/x-chess-pgn", Arrays.asList("pgn"));
        mimeTypesMap.put("application/x-cocoa", Arrays.asList("cco"));
        mimeTypesMap.put("application/x-compress", Arrays.asList("z"));
        mimeTypesMap.put("application/x-compressed", Arrays.asList("tgz"));
        mimeTypesMap.put("application/x-conference", Arrays.asList("nsc"));
        mimeTypesMap.put("application/x-cpio", Arrays.asList("cpio"));
        mimeTypesMap.put("application/x-cpt", Arrays.asList("cpt"));
        mimeTypesMap.put("application/x-csh", Arrays.asList("csh"));
        mimeTypesMap.put("application/x-debian-package", Arrays.asList("deb", "udeb"));
        mimeTypesMap.put("application/x-deepv", Arrays.asList("deepv"));
        mimeTypesMap.put("application/x-director", Arrays.asList("dir", "dcr", "dxr"));
        mimeTypesMap.put("application/x-doom", Arrays.asList("wad"));
        mimeTypesMap.put("application/x-dtbncx+xml", Arrays.asList("ncx"));
        mimeTypesMap.put("application/x-dtbook+xml", Arrays.asList("dtb"));
        mimeTypesMap.put("application/x-dtbresource+xml", Arrays.asList("res"));
        mimeTypesMap.put("application/x-dvi", Arrays.asList("dvi"));
        mimeTypesMap.put("application/x-elc", Arrays.asList("elc"));
        mimeTypesMap.put("application/x-envoy", Arrays.asList("env", "evy"));
        mimeTypesMap.put("application/x-esrehber", Arrays.asList("es"));
        mimeTypesMap.put("application/x-excel", Arrays.asList("xlc", "xlb", "xld", "xlk", "xlm", "xll", "xlt", "xlv"));
        mimeTypesMap.put("application/x-font-bdf", Arrays.asList("bdf"));
        mimeTypesMap.put("application/x-font-ghostscript", Arrays.asList("gsf"));
        mimeTypesMap.put("application/x-font-linux-psf", Arrays.asList("psf"));
        mimeTypesMap.put("application/x-font-otf", Arrays.asList("otf"));
        mimeTypesMap.put("application/x-font-pcf", Arrays.asList("pcf"));
        mimeTypesMap.put("application/x-font-snf", Arrays.asList("snf"));
        mimeTypesMap.put("application/x-font-ttf", Arrays.asList("ttc", "ttf"));
        mimeTypesMap.put("application/x-font-type1", Arrays.asList("afm", "pfm", "pfa", "pfb"));
        mimeTypesMap.put("application/x-font-woff", Arrays.asList("woff"));
        mimeTypesMap.put("application/x-freelance", Arrays.asList("pre"));
        mimeTypesMap.put("application/x-futuresplash", Arrays.asList("spl"));
        mimeTypesMap.put("application/x-gnumeric", Arrays.asList("gnumeric"));
        mimeTypesMap.put("application/x-gsp", Arrays.asList("gsp"));
        mimeTypesMap.put("application/x-gss", Arrays.asList("gss"));
        mimeTypesMap.put("application/x-gtar", Arrays.asList("gtar"));
        mimeTypesMap.put("application/x-gzip", Arrays.asList("gz"));
        mimeTypesMap.put("application/x-hdf", Arrays.asList("hdf"));
        mimeTypesMap.put("application/x-helpfile", Arrays.asList("help"));
        mimeTypesMap.put("application/x-httpd-imap", Arrays.asList("imap"));
        mimeTypesMap.put("application/x-ima", Arrays.asList("ima"));
        mimeTypesMap.put("application/x-internet-signup", Arrays.asList("ins", "isp"));
        mimeTypesMap.put("application/x-internett-signup", Arrays.asList("ins"));
        mimeTypesMap.put("application/x-inventor", Arrays.asList("iv"));
        mimeTypesMap.put("application/x-ip2", Arrays.asList("ip"));
        mimeTypesMap.put("application/x-iphone", Arrays.asList("iii"));
        mimeTypesMap.put("application/x-java-class", Arrays.asList("class"));
        mimeTypesMap.put("application/x-java-commerce", Arrays.asList("jcm"));
        mimeTypesMap.put("application/x-java-jnlp-file", Arrays.asList("jnlp"));
        mimeTypesMap.put("application/x-javascript", Arrays.asList("js"));
        mimeTypesMap.put("application/x-killustrator", Arrays.asList("kil"));
        mimeTypesMap.put("application/x-koan", Arrays.asList("skd", "skm", "skp", "skt"));
        mimeTypesMap.put("application/x-latex", Arrays.asList("latex"));
        mimeTypesMap.put("application/x-lha", Arrays.asList("lha"));
        mimeTypesMap.put("application/x-livescreen", Arrays.asList("ivy"));
        mimeTypesMap.put("application/x-lotus", Arrays.asList("wq1"));
        mimeTypesMap.put("application/x-lzh", Arrays.asList("lzh"));
        mimeTypesMap.put("application/x-lzx", Arrays.asList("lzx"));
        mimeTypesMap.put("application/x-mac-binhex40", Arrays.asList("hqx"));
        mimeTypesMap.put("application/x-macbinary", Arrays.asList("bin"));
        mimeTypesMap.put("application/x-magic-cap-package-1.0", Arrays.asList("mc$"));
        mimeTypesMap.put("application/x-mathcad", Arrays.asList("mcd"));
        mimeTypesMap.put("application/x-meme", Arrays.asList("mm"));
        mimeTypesMap.put("application/x-mif", Arrays.asList("mif"));
        mimeTypesMap.put("application/x-mix-transfer", Arrays.asList("nix"));
        mimeTypesMap.put("application/x-mobipocket-ebook", Arrays.asList("mobi", "prc"));
        mimeTypesMap.put("application/x-ms-application", Arrays.asList("application"));
        mimeTypesMap.put("application/x-ms-wmd", Arrays.asList("wmd"));
        mimeTypesMap.put("application/x-ms-wmz", Arrays.asList("wmz"));
        mimeTypesMap.put("application/x-ms-xbap", Arrays.asList("xbap"));
        mimeTypesMap.put("application/x-msaccess", Arrays.asList("mdb"));
        mimeTypesMap.put("application/x-msbinder", Arrays.asList("obd"));
        mimeTypesMap.put("application/x-mscardfile", Arrays.asList("crd"));
        mimeTypesMap.put("application/x-msclip", Arrays.asList("clp"));
        mimeTypesMap.put("application/x-msdownload", Arrays.asList("dll", "exe"));
        mimeTypesMap.put("application/x-msexcel", Arrays.asList("xla", "xls", "xlw"));
        mimeTypesMap.put("application/x-msmediaview", Arrays.asList("mvb", "m13", "m14"));
        mimeTypesMap.put("application/x-msmetafile", Arrays.asList("wmf"));
        mimeTypesMap.put("application/x-msmoney", Arrays.asList("mny"));
        mimeTypesMap.put("application/x-mspowerpoint", Arrays.asList("ppt"));
        mimeTypesMap.put("application/x-mspublisher", Arrays.asList("pub"));
        mimeTypesMap.put("application/x-msschedule", Arrays.asList("scd"));
        mimeTypesMap.put("application/x-msterminal", Arrays.asList("trm"));
        mimeTypesMap.put("application/x-mswrite", Arrays.asList("wri"));
        mimeTypesMap.put("application/x-navi-animation", Arrays.asList("ani"));
        mimeTypesMap.put("application/x-navidoc", Arrays.asList("nvd"));
        mimeTypesMap.put("application/x-navimap", Arrays.asList("map"));
        mimeTypesMap.put("application/x-navistyle", Arrays.asList("stl"));
        mimeTypesMap.put("application/x-netcdf", Arrays.asList("cdf", "nc"));
        mimeTypesMap.put("application/x-newton-compatible-pkg", Arrays.asList("pkg"));
        mimeTypesMap.put("application/x-nokia-9000-communicator-add-on-software", Arrays.asList("aos"));
        mimeTypesMap.put("application/x-omc", Arrays.asList("omc"));
        mimeTypesMap.put("application/x-omcdatamaker", Arrays.asList("omcd"));
        mimeTypesMap.put("application/x-omcregerator", Arrays.asList("omcr"));
        mimeTypesMap.put("application/x-pagemaker", Arrays.asList("pm4", "pm5"));
        mimeTypesMap.put("application/x-pcl", Arrays.asList("pcl"));
        mimeTypesMap.put("application/x-perfmon", Arrays.asList("pma", "pmc", "pml", "pmr", "pmw"));
        mimeTypesMap.put("application/x-pixclscript", Arrays.asList("plx"));
        mimeTypesMap.put("application/x-pkcs10", Arrays.asList("p10"));
        mimeTypesMap.put("application/x-pkcs12", Arrays.asList("p12", "pfx"));
        mimeTypesMap.put("application/x-pkcs7-certificates", Arrays.asList("p7b", "spc"));
        mimeTypesMap.put("application/x-pkcs7-certreqresp", Arrays.asList("p7r"));
        mimeTypesMap.put("application/x-pkcs7-mime", Arrays.asList("p7m", "p7c"));
        mimeTypesMap.put("application/x-pkcs7-signature", Arrays.asList("p7s"));
        mimeTypesMap.put("application/x-project", Arrays.asList("mpc", "mpt", "mpv", "mpx"));
        mimeTypesMap.put("application/x-python-code", Arrays.asList("pyc", "pyo"));
        mimeTypesMap.put("application/x-qpro", Arrays.asList("wb1"));
        mimeTypesMap.put("application/x-rar-compressed", Arrays.asList("rar"));
        mimeTypesMap.put("application/x-rpm", Arrays.asList("rpm"));
        mimeTypesMap.put("application/x-sdp", Arrays.asList("sdp"));
        mimeTypesMap.put("application/x-sea", Arrays.asList("sea"));
        mimeTypesMap.put("application/x-seelogo", Arrays.asList("sl"));
        mimeTypesMap.put("application/x-sh", Arrays.asList("sh"));
        mimeTypesMap.put("application/x-shar", Arrays.asList("shar"));
        mimeTypesMap.put("application/x-shockwave-flash", Arrays.asList("swf"));
        mimeTypesMap.put("application/x-silverlight-app", Arrays.asList("xap"));
        mimeTypesMap.put("application/x-sprite", Arrays.asList("spr", "sprite"));
        mimeTypesMap.put("application/x-stuffit", Arrays.asList("sit"));
        mimeTypesMap.put("application/x-stuffitx", Arrays.asList("sitx"));
        mimeTypesMap.put("application/x-sv4cpio", Arrays.asList("sv4cpio"));
        mimeTypesMap.put("application/x-sv4crc", Arrays.asList("sv4crc"));
        mimeTypesMap.put("application/x-tar", Arrays.asList("tar"));
        mimeTypesMap.put("application/x-tbook", Arrays.asList("sbk", "tbk"));
        mimeTypesMap.put("application/x-tcl", Arrays.asList("tcl"));
        mimeTypesMap.put("application/x-tex", Arrays.asList("tex"));
        mimeTypesMap.put("application/x-tex-tfm", Arrays.asList("tfm"));
        mimeTypesMap.put("application/x-texinfo", Arrays.asList("texinfo", "texi"));
        mimeTypesMap.put("application/x-troff", Arrays.asList("roff", "t", "tr"));
        mimeTypesMap.put("application/x-troff-man", Arrays.asList("man"));
        mimeTypesMap.put("application/x-troff-me", Arrays.asList("me"));
        mimeTypesMap.put("application/x-troff-ms", Arrays.asList("ms"));
        mimeTypesMap.put("application/x-ustar", Arrays.asList("ustar"));
        mimeTypesMap.put("application/x-visio", Arrays.asList("vsd", "vsw", "vst"));
        mimeTypesMap.put("application/x-vnd.audioexplosion.mzz", Arrays.asList("mzz"));
        mimeTypesMap.put("application/x-vnd.ls-xpix", Arrays.asList("xpix"));
        mimeTypesMap.put("application/x-wais-source", Arrays.asList("src"));
        mimeTypesMap.put("application/x-winhelp", Arrays.asList("hlp"));
        mimeTypesMap.put("application/x-wintalk", Arrays.asList("wtk"));
        mimeTypesMap.put("application/x-wpwin", Arrays.asList("wpd"));
        mimeTypesMap.put("application/x-wri", Arrays.asList("wri"));
        mimeTypesMap.put("application/x-x509-ca-cert", Arrays.asList("crt", "cer", "der"));
        mimeTypesMap.put("application/x-x509-user-cert", Arrays.asList("crt"));
        mimeTypesMap.put("application/x-xfig", Arrays.asList("fig"));
        mimeTypesMap.put("application/x-xpinstall", Arrays.asList("xpi"));
        mimeTypesMap.put("application/xcap-diff+xml", Arrays.asList("xdf"));
        mimeTypesMap.put("application/xenc+xml", Arrays.asList("xenc"));
        mimeTypesMap.put("application/xhtml+xml", Arrays.asList("xhtml"));
        mimeTypesMap.put(CONTENT_TYPE_APPLICATION_XML, Arrays.asList("xml"));
        mimeTypesMap.put("application/xml-dtd", Arrays.asList("dtd"));
        mimeTypesMap.put("application/xop+xml", Arrays.asList("xop"));
        mimeTypesMap.put("application/xslt+xml", Arrays.asList("xslt"));
        mimeTypesMap.put("application/xspf+xml", Arrays.asList("xspf"));
        mimeTypesMap.put("application/xv+xml", Arrays.asList("mxml", "xhvml", "xvm", "xvml"));
        mimeTypesMap.put("application/yang", Arrays.asList("yang"));
        mimeTypesMap.put("application/yin+xml", Arrays.asList("yin"));
        mimeTypesMap.put("application/ynd.ms-pkipko", Arrays.asList("pko"));
        mimeTypesMap.put("application/zip", Arrays.asList("zip"));
        mimeTypesMap.put("audio/adpcm", Arrays.asList("adp"));
        mimeTypesMap.put("audio/basic", Arrays.asList("au", "snd"));
        mimeTypesMap.put("audio/it", Arrays.asList("it"));
        mimeTypesMap.put("audio/make", Arrays.asList("funk", "my"));
        mimeTypesMap.put("audio/make.my.funk", Arrays.asList("pfunk"));
        mimeTypesMap.put("audio/mid", Arrays.asList("mid", "rmi"));
        mimeTypesMap.put("audio/midi", Arrays.asList("kar", "rmi", "mid", "midi"));
        mimeTypesMap.put("audio/mp4", Arrays.asList("mp4a"));
        mimeTypesMap.put("audio/mpeg", Arrays.asList("mp3", "mpga"));
        mimeTypesMap.put("audio/ogg", Arrays.asList("oga", "ogg", "spx"));
        mimeTypesMap.put("audio/s3m", Arrays.asList("s3m"));
        mimeTypesMap.put("audio/tsp-audio", Arrays.asList("tsi"));
        mimeTypesMap.put("audio/tsplayer", Arrays.asList("tsp"));
        mimeTypesMap.put("audio/vnd.dece.audio", Arrays.asList("uva"));
        mimeTypesMap.put("audio/vnd.digital-winds", Arrays.asList("eol"));
        mimeTypesMap.put("audio/vnd.dra", Arrays.asList("dra"));
        mimeTypesMap.put("audio/vnd.dts", Arrays.asList("dts"));
        mimeTypesMap.put("audio/vnd.dts.hd", Arrays.asList("dtshd"));
        mimeTypesMap.put("audio/vnd.lucent.voice", Arrays.asList("lvp"));
        mimeTypesMap.put("audio/vnd.ms-playready.media.pya", Arrays.asList("pya"));
        mimeTypesMap.put("audio/vnd.nuera.ecelp4800", Arrays.asList("ecelp4800"));
        mimeTypesMap.put("audio/vnd.nuera.ecelp7470", Arrays.asList("ecelp7470"));
        mimeTypesMap.put("audio/vnd.nuera.ecelp9600", Arrays.asList("ecelp9600"));
        mimeTypesMap.put("audio/vnd.qcelp", Arrays.asList("qcp"));
        mimeTypesMap.put("audio/vnd.rip", Arrays.asList("rip"));
        mimeTypesMap.put("audio/voxware", Arrays.asList("vox"));
        mimeTypesMap.put("audio/webm", Arrays.asList("weba"));
        mimeTypesMap.put("audio/x-aac", Arrays.asList("aac"));
        mimeTypesMap.put("audio/x-adpcm", Arrays.asList("snd"));
        mimeTypesMap.put("audio/x-aiff", Arrays.asList("aif", "aifc", "aiff"));
        mimeTypesMap.put("audio/x-au", Arrays.asList("au"));
        mimeTypesMap.put("audio/x-gsm", Arrays.asList("gsd", "gsm"));
        mimeTypesMap.put("audio/x-jam", Arrays.asList("jam"));
        mimeTypesMap.put("audio/x-liveaudio", Arrays.asList("lam"));
        mimeTypesMap.put("audio/x-mod", Arrays.asList("mod"));
        mimeTypesMap.put("audio/x-mpegurl", Arrays.asList("m3u"));
        mimeTypesMap.put("audio/x-mpequrl", Arrays.asList("m3u"));
        mimeTypesMap.put("audio/x-ms-wax", Arrays.asList("wax"));
        mimeTypesMap.put("audio/x-ms-wma", Arrays.asList("wma"));
        mimeTypesMap.put("audio/x-nspaudio", Arrays.asList("lma", "la"));
        mimeTypesMap.put("audio/x-pn-realaudio", Arrays.asList("ra", "ram"));
        mimeTypesMap.put("audio/x-pn-realaudio-plugin", Arrays.asList("rpm", "rmp"));
        mimeTypesMap.put("audio/x-psid", Arrays.asList("sid"));
        mimeTypesMap.put("audio/x-realaudio", Arrays.asList("ra"));
        mimeTypesMap.put("audio/x-twinvq", Arrays.asList("vqf"));
        mimeTypesMap.put("audio/x-twinvq-plugin", Arrays.asList("vqe", "vql"));
        mimeTypesMap.put("audio/x-vnd.audioexplosion.mjuicemediafile", Arrays.asList("mjf"));
        mimeTypesMap.put("audio/x-voc", Arrays.asList("voc"));
        mimeTypesMap.put("audio/x-wav", Arrays.asList("wav"));
        mimeTypesMap.put("audio/xm", Arrays.asList("xm"));
        mimeTypesMap.put("chemical/x-cdx", Arrays.asList("cdx"));
        mimeTypesMap.put("chemical/x-cif", Arrays.asList("cif"));
        mimeTypesMap.put("chemical/x-cmdf", Arrays.asList("cmdf"));
        mimeTypesMap.put("chemical/x-cml", Arrays.asList("cml"));
        mimeTypesMap.put("chemical/x-csml", Arrays.asList("csml"));
        mimeTypesMap.put("chemical/x-pdb", Arrays.asList("pdb", "xyz"));
        mimeTypesMap.put("chemical/x-xyz", Arrays.asList("xyz"));
        mimeTypesMap.put("i-world/i-vrml", Arrays.asList("ivr"));
        mimeTypesMap.put("image/bmp", Arrays.asList("bmp"));
        mimeTypesMap.put("image/cgm", Arrays.asList("cgm"));
        mimeTypesMap.put("image/cis-cod", Arrays.asList("cod"));
        mimeTypesMap.put("image/cmu-raster", Arrays.asList("rast"));
        mimeTypesMap.put("image/fif", Arrays.asList("fif"));
        mimeTypesMap.put("image/florian", Arrays.asList("flo", "turbot"));
        mimeTypesMap.put("image/g3fax", Arrays.asList("g3"));
        mimeTypesMap.put("image/gif", Arrays.asList("gif"));
        mimeTypesMap.put("image/ief", Arrays.asList("ief"));
        mimeTypesMap.put("image/jpeg", Arrays.asList("jpeg", "jpe", "jpg"));
        mimeTypesMap.put("image/jutvision", Arrays.asList("jut"));
        mimeTypesMap.put("image/ktx", Arrays.asList("ktx"));
        mimeTypesMap.put("image/naplps", Arrays.asList("nap", "naplps"));
        mimeTypesMap.put("image/pict", Arrays.asList("pic", "pict"));
        mimeTypesMap.put("image/pipeg", Arrays.asList("jfif"));
        mimeTypesMap.put("image/pjpeg", Arrays.asList("jpg", "jpe", "jpeg", "jfif", "pjpeg"));
        mimeTypesMap.put("image/png", Arrays.asList("png", "x-png"));
        mimeTypesMap.put("image/prs.btif", Arrays.asList("btif"));
        mimeTypesMap.put("image/svg+xml", Arrays.asList("svg"));
        mimeTypesMap.put("image/tiff", Arrays.asList("tif", "tiff"));
        mimeTypesMap.put("image/vnd.adobe.photoshop", Arrays.asList("psd"));
        mimeTypesMap.put("image/vnd.dece.graphic", Arrays.asList("uvi"));
        mimeTypesMap.put("image/vnd.djvu", Arrays.asList("djv", "djvu"));
        mimeTypesMap.put("image/vnd.dvb.subtitle", Arrays.asList("sub"));
        mimeTypesMap.put("image/vnd.dwg", Arrays.asList("dwg"));
        mimeTypesMap.put("image/vnd.dxf", Arrays.asList("dxf"));
        mimeTypesMap.put("image/vnd.fastbidsheet", Arrays.asList("fbs"));
        mimeTypesMap.put("image/vnd.fpx", Arrays.asList("fpx"));
        mimeTypesMap.put("image/vnd.fst", Arrays.asList("fst"));
        mimeTypesMap.put("image/vnd.fujixerox.edmics-mmr", Arrays.asList("mmr"));
        mimeTypesMap.put("image/vnd.fujixerox.edmics-rlc", Arrays.asList("rlc"));
        mimeTypesMap.put("image/vnd.ms-modi", Arrays.asList("mdi"));
        mimeTypesMap.put("image/vnd.net-fpx", Arrays.asList("fpx", "npx"));
        mimeTypesMap.put("image/vnd.rn-realflash", Arrays.asList("rf"));
        mimeTypesMap.put("image/vnd.rn-realpix", Arrays.asList("rp"));
        mimeTypesMap.put("image/vnd.wap.wbmp", Arrays.asList("wbmp"));
        mimeTypesMap.put("image/vnd.xiff", Arrays.asList("xif"));
        mimeTypesMap.put("image/webp", Arrays.asList("webp"));
        mimeTypesMap.put("image/x-citrix-jpeg", Arrays.asList("jpeg", "jpg"));
        mimeTypesMap.put("image/x-citrix-png", Arrays.asList("png"));
        mimeTypesMap.put("image/x-cmu-raster", Arrays.asList("ras"));
        mimeTypesMap.put("image/x-cmx", Arrays.asList("cmx"));
        mimeTypesMap.put("image/x-dwg", Arrays.asList("dwg", "dxf", "svf"));
        mimeTypesMap.put("image/x-freehand", Arrays.asList("fh", "fhc", "fh4", "fh5", "fh7"));
        mimeTypesMap.put("image/x-icon", Arrays.asList("ico"));
        mimeTypesMap.put("image/x-jg", Arrays.asList("art"));
        mimeTypesMap.put("image/x-jps", Arrays.asList("jps"));
        mimeTypesMap.put("image/x-niff", Arrays.asList("nif", "niff"));
        mimeTypesMap.put("image/x-pcx", Arrays.asList("pcx"));
        mimeTypesMap.put("image/x-pict", Arrays.asList("pct", "pic"));
        mimeTypesMap.put("image/x-png", Arrays.asList("png"));
        mimeTypesMap.put("image/x-portable-anymap", Arrays.asList("pnm"));
        mimeTypesMap.put("image/x-portable-bitmap", Arrays.asList("pbm"));
        mimeTypesMap.put("image/x-portable-graymap", Arrays.asList("pgm"));
        mimeTypesMap.put("image/x-portable-greymap", Arrays.asList("pgm"));
        mimeTypesMap.put("image/x-portable-pixmap", Arrays.asList("ppm"));
        mimeTypesMap.put("image/x-quicktime", Arrays.asList("qti", "qif", "qtif"));
        mimeTypesMap.put("image/x-rgb", Arrays.asList("rgb"));
        mimeTypesMap.put("image/x-tiff", Arrays.asList("tif", "tiff"));
        mimeTypesMap.put("image/x-windows-bmp", Arrays.asList("bmp"));
        mimeTypesMap.put("image/x-xbitmap", Arrays.asList("xbm"));
        mimeTypesMap.put("image/x-xpixmap", Arrays.asList("xpm"));
        mimeTypesMap.put("image/x-xwindowdump", Arrays.asList("xwd"));
        mimeTypesMap.put("image/xbm", Arrays.asList("xbm"));
        mimeTypesMap.put("image/xpm", Arrays.asList("xpm"));
        mimeTypesMap.put(CONTENT_TYPE_MESSAGE_RFC822, Arrays.asList("eml", "mht", "mhtml"));
        mimeTypesMap.put("model/iges", Arrays.asList("iges", "igs"));
        mimeTypesMap.put("model/mesh", Arrays.asList("mesh", "silo", "msh"));
        mimeTypesMap.put("model/vnd.collada+xml", Arrays.asList("dae"));
        mimeTypesMap.put("model/vnd.dwf", Arrays.asList("dwf"));
        mimeTypesMap.put("model/vnd.gdl", Arrays.asList("gdl"));
        mimeTypesMap.put("model/vnd.gtw", Arrays.asList("gtw"));
        mimeTypesMap.put("model/vnd.mts", Arrays.asList("mts"));
        mimeTypesMap.put("model/vnd.vtu", Arrays.asList("vtu"));
        mimeTypesMap.put("model/vrml", Arrays.asList("vrml", "wrl"));
        mimeTypesMap.put("model/x-pov", Arrays.asList("pov"));
        mimeTypesMap.put("multipart/x-gzip", Arrays.asList("gzip"));
        mimeTypesMap.put("multipart/x-ustar", Arrays.asList("ustar"));
        mimeTypesMap.put("multipart/x-zip", Arrays.asList("zip"));
        mimeTypesMap.put("music/x-karaoke", Arrays.asList("kar"));
        mimeTypesMap.put("paleovu/x-pv", Arrays.asList("pvu"));
        mimeTypesMap.put("text/asp", Arrays.asList("asp"));
        mimeTypesMap.put("text/calendar", Arrays.asList("ics", "ifb"));
        mimeTypesMap.put("text/css", Arrays.asList("css"));
        mimeTypesMap.put("text/csv", Arrays.asList("csv"));
        mimeTypesMap.put("text/ecmascript", Arrays.asList("js"));
        mimeTypesMap.put("text/h323", Arrays.asList("323"));
        mimeTypesMap.put(CONTENT_TYPE_TEXT_HTML, Arrays.asList("html", "htm", "stm"));
        mimeTypesMap.put("text/iuls", Arrays.asList("uls"));
        mimeTypesMap.put("text/mcf", Arrays.asList("mcf"));
        mimeTypesMap.put("text/n3", Arrays.asList("n3"));
        mimeTypesMap.put("text/pascal", Arrays.asList("pas"));
        mimeTypesMap.put(CONTENT_TYPE_TEXT_PLAIN, Arrays.asList("txt", "h", "c", "bas"));
        mimeTypesMap.put("text/plain-bas", Arrays.asList("par"));
        mimeTypesMap.put("text/prs.lines.tag", Arrays.asList("dsc"));
        mimeTypesMap.put("text/richtext", Arrays.asList("rtx"));
        mimeTypesMap.put("text/scriplet", Arrays.asList("wsc"));
        mimeTypesMap.put("text/scriptlet", Arrays.asList("sct"));
        mimeTypesMap.put("text/sgml", Arrays.asList("sgm", "sgml"));
        mimeTypesMap.put("text/tab-separated-values", Arrays.asList("tsv"));
        mimeTypesMap.put("text/troff", Arrays.asList("man", "tr", "me", "ms", "roff", "t"));
        mimeTypesMap.put("text/turtle", Arrays.asList("ttl"));
        mimeTypesMap.put("text/uri-list", Arrays.asList("uni", "unis", "uris", "uri"));
        mimeTypesMap.put("text/vnd.abc", Arrays.asList("abc"));
        mimeTypesMap.put("text/vnd.curl", Arrays.asList("curl"));
        mimeTypesMap.put("text/vnd.curl.dcurl", Arrays.asList("dcurl"));
        mimeTypesMap.put("text/vnd.curl.mcurl", Arrays.asList("mcurl"));
        mimeTypesMap.put("text/vnd.curl.scurl", Arrays.asList("scurl"));
        mimeTypesMap.put("text/vnd.fly", Arrays.asList("fly"));
        mimeTypesMap.put("text/vnd.fmi.flexstor", Arrays.asList("flx"));
        mimeTypesMap.put("text/vnd.graphviz", Arrays.asList("gv"));
        mimeTypesMap.put("text/vnd.in3d.3dml", Arrays.asList("3dml"));
        mimeTypesMap.put("text/vnd.in3d.spot", Arrays.asList("spot"));
        mimeTypesMap.put("text/vnd.rn-realtext", Arrays.asList("rt"));
        mimeTypesMap.put("text/vnd.sun.j2me.app-descriptor", Arrays.asList("jad"));
        mimeTypesMap.put("text/vnd.wap.si", Arrays.asList("si"));
        mimeTypesMap.put("text/vnd.wap.sl", Arrays.asList("sl"));
        mimeTypesMap.put("text/vnd.wap.wml", Arrays.asList("wml"));
        mimeTypesMap.put("text/vnd.wap.wmlscript", Arrays.asList("wmls"));
        mimeTypesMap.put("text/webviewhtml", Arrays.asList("htt"));
        mimeTypesMap.put("text/x-asm", Arrays.asList("asm", "s"));
        mimeTypesMap.put("text/x-audiosoft-intra", Arrays.asList("aip"));
        mimeTypesMap.put("text/x-c", Arrays.asList("c", "cpp", "cc"));
        mimeTypesMap.put("text/x-component", Arrays.asList("htc"));
        mimeTypesMap.put("text/x-fortran", Arrays.asList("f77", "f90", "f", "for"));
        mimeTypesMap.put("text/x-h", Arrays.asList("h", "hh"));
        mimeTypesMap.put("text/x-java-source", Arrays.asList("java", "jav"));
        mimeTypesMap.put("text/x-java-source,java", Arrays.asList("java"));
        mimeTypesMap.put("text/x-la-asf", Arrays.asList("lsx"));
        mimeTypesMap.put("text/x-m", Arrays.asList("m"));
        mimeTypesMap.put("text/x-pascal", Arrays.asList("p"));
        mimeTypesMap.put("text/x-python", Arrays.asList("py"));
        mimeTypesMap.put("text/x-script", Arrays.asList("hlb"));
        mimeTypesMap.put("text/x-script.csh", Arrays.asList("csh"));
        mimeTypesMap.put("text/x-script.elisp", Arrays.asList("el"));
        mimeTypesMap.put("text/x-script.ksh", Arrays.asList("ksh"));
        mimeTypesMap.put("text/x-script.lisp", Arrays.asList("lsp"));
        mimeTypesMap.put("text/x-script.perl", Arrays.asList("pl"));
        mimeTypesMap.put("text/x-script.perl-module", Arrays.asList("pm"));
        mimeTypesMap.put("text/x-script.phyton", Arrays.asList("py"));
        mimeTypesMap.put("text/x-script.rexx", Arrays.asList("rexx"));
        mimeTypesMap.put("text/x-script.sh", Arrays.asList("sh"));
        mimeTypesMap.put("text/x-script.tcl", Arrays.asList("tcl"));
        mimeTypesMap.put("text/x-script.tcsh", Arrays.asList("tcsh"));
        mimeTypesMap.put("text/x-script.zsh", Arrays.asList("zsh"));
        mimeTypesMap.put("text/x-server-parsed-html", Arrays.asList("shtml", "ssi"));
        mimeTypesMap.put("text/x-setext", Arrays.asList("etx"));
        mimeTypesMap.put("text/x-sgml", Arrays.asList("sgm", "sgml"));
        mimeTypesMap.put("text/x-speech", Arrays.asList("spc", "talk"));
        mimeTypesMap.put("text/x-uil", Arrays.asList("uil"));
        mimeTypesMap.put("text/x-uuencode", Arrays.asList("uu", "uue"));
        mimeTypesMap.put("text/x-vcalendar", Arrays.asList("vcs"));
        mimeTypesMap.put("text/x-vcard", Arrays.asList("vcf"));
        mimeTypesMap.put("text/xml", Arrays.asList("xml"));
        mimeTypesMap.put("text/yaml", Arrays.asList("yaml", "yml"));
        mimeTypesMap.put("video/3gpp", Arrays.asList("3gp"));
        mimeTypesMap.put("video/3gpp2", Arrays.asList("3g2"));
        mimeTypesMap.put("video/animaflex", Arrays.asList("afl"));
        mimeTypesMap.put("video/avs-video", Arrays.asList("avs"));
        mimeTypesMap.put("video/h261", Arrays.asList("h261"));
        mimeTypesMap.put("video/h263", Arrays.asList("h263"));
        mimeTypesMap.put("video/h264", Arrays.asList("h264"));
        mimeTypesMap.put("video/jpeg", Arrays.asList("jpgv"));
        mimeTypesMap.put("video/jpm", Arrays.asList("jpgm", "jpm"));
        mimeTypesMap.put("video/mj2", Arrays.asList("mj2", "mjp2"));
        mimeTypesMap.put("video/mp4", Arrays.asList("mp4"));
        mimeTypesMap.put("video/mpeg", Arrays.asList("mpeg", "mp2", "mpa", "mpe", "mpg", "mpv2"));
        mimeTypesMap.put("video/ogg", Arrays.asList("ogv"));
        mimeTypesMap.put("video/quicktime", Arrays.asList("mov", "qt"));
        mimeTypesMap.put("video/vdo", Arrays.asList("vdo"));
        mimeTypesMap.put("video/vnd.dece.hd", Arrays.asList("uvh"));
        mimeTypesMap.put("video/vnd.dece.mobile", Arrays.asList("uvm"));
        mimeTypesMap.put("video/vnd.dece.pd", Arrays.asList("uvp"));
        mimeTypesMap.put("video/vnd.dece.sd", Arrays.asList("uvs"));
        mimeTypesMap.put("video/vnd.dece.video", Arrays.asList("uvv"));
        mimeTypesMap.put("video/vnd.fvt", Arrays.asList("fvt"));
        mimeTypesMap.put("video/vnd.mpegurl", Arrays.asList("m4u", "mxu"));
        mimeTypesMap.put("video/vnd.ms-playready.media.pyv", Arrays.asList("pyv"));
        mimeTypesMap.put("video/vnd.rn-realvideo", Arrays.asList("rv"));
        mimeTypesMap.put("video/vnd.uvvu.mp4", Arrays.asList("uvu"));
        mimeTypesMap.put("video/vnd.vivo", Arrays.asList("viv", "vivo"));
        mimeTypesMap.put("video/vosaic", Arrays.asList("vos"));
        mimeTypesMap.put("video/webm", Arrays.asList("webm"));
        mimeTypesMap.put("video/x-amt-demorun", Arrays.asList("xdr"));
        mimeTypesMap.put("video/x-amt-showrun", Arrays.asList("xsr"));
        mimeTypesMap.put("video/x-atomic3d-feature", Arrays.asList("fmf"));
        mimeTypesMap.put("video/x-dl", Arrays.asList("dl"));
        mimeTypesMap.put("video/x-dv", Arrays.asList("dif", "dv"));
        mimeTypesMap.put("video/x-f4v", Arrays.asList("f4v"));
        mimeTypesMap.put("video/x-fli", Arrays.asList("fli"));
        mimeTypesMap.put("video/x-flv", Arrays.asList("flv"));
        mimeTypesMap.put("video/x-gl", Arrays.asList("gl"));
        mimeTypesMap.put("video/x-isvideo", Arrays.asList("isu"));
        mimeTypesMap.put("video/x-la-asf", Arrays.asList("lsf", "lsx"));
        mimeTypesMap.put("video/x-m4v", Arrays.asList("m4v"));
        mimeTypesMap.put("video/x-motion-jpeg", Arrays.asList("mjpg"));
        mimeTypesMap.put("video/x-mpeg", Arrays.asList("mp3"));
        mimeTypesMap.put("video/x-mpeq2a", Arrays.asList("mp2"));
        mimeTypesMap.put("video/x-ms-asf", Arrays.asList("asf", "asr", "asx"));
        mimeTypesMap.put("video/x-ms-asf-plugin", Arrays.asList("asx"));
        mimeTypesMap.put("video/x-ms-wm", Arrays.asList("wm"));
        mimeTypesMap.put("video/x-ms-wmv", Arrays.asList("wmv"));
        mimeTypesMap.put("video/x-ms-wmx", Arrays.asList("wmx"));
        mimeTypesMap.put("video/x-ms-wvx", Arrays.asList("wvx"));
        mimeTypesMap.put("video/x-msvideo", Arrays.asList("avi"));
        mimeTypesMap.put("video/x-qtc", Arrays.asList("qtc"));
        mimeTypesMap.put("video/x-scm", Arrays.asList("scm"));
        mimeTypesMap.put("video/x-sgi-movie", Arrays.asList("movie"));
        mimeTypesMap.put("windows/metafile", Arrays.asList("wmf"));
        mimeTypesMap.put("www/mime", Arrays.asList("mime"));
        mimeTypesMap.put("x-conference/x-cooltalk", Arrays.asList("ice"));
        mimeTypesMap.put("x-music/x-midi", Arrays.asList("mid", "midi"));
        mimeTypesMap.put("x-world/x-3dmf", Arrays.asList("3dmf", "3dm", "qd3d", "qd3"));
        mimeTypesMap.put("x-world/x-svr", Arrays.asList("svr"));
        mimeTypesMap.put("x-world/x-vrml", Arrays.asList("vrml", "flr", "wrl", "wrz", "xaf", "xof"));
        mimeTypesMap.put("x-world/x-vrt", Arrays.asList("vrt"));
        mimeTypesMap.put("xgl/drawing", Arrays.asList("xgz"));
        mimeTypesMap.put("xgl/movie", Arrays.asList("xmz"));
        mimeTypesMap.put("application/andrew-inset", Arrays.asList("ez"));
    }
}

