/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.mail.pec.util;

import app.tozzi.mail.pec.exception.PECParserException;
import app.tozzi.mail.pec.util.IOUtils;
import jakarta.activation.DataHandler;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(MimeMessageUtils.class);
    private static final String FORMATO_DATA = "dd-MM-yyyy HH:mm";
    private static final ZoneId ZI = ZoneId.of("Europe/Rome");
    private static final String BODYSTRUCTURE_LOADING_ERROR = "Unable to load BODYSTRUCTURE";

    public static boolean isRicevuta(MimeMessage mimeMessage) throws PECParserException {
        try {
            return mimeMessage.getHeader("X-Ricevuta") != null;
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dell'header", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dell'header", (Exception)((Object)e));
        }
    }

    public static boolean isEmailOrdinaria(MimeMessage mimeMessage) throws PECParserException {
        try {
            return mimeMessage.getHeader("X-Trasporto", ",") == null && mimeMessage.getHeader("X-Ricevuta", ",") == null;
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dell'header", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dell'header", (Exception)((Object)e));
        }
    }

    public static boolean isPEC(MimeMessage mimeMessage) throws PECParserException {
        try {
            return mimeMessage.getHeader("X-Trasporto", ",") != null;
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dell'header", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dell'header", (Exception)((Object)e));
        }
    }

    public static MimeMessage createMimeMessage(InputStream inputStream, Properties properties) throws PECParserException {
        try {
            return new MimeMessage(Session.getDefaultInstance((Properties)(properties != null ? properties : System.getProperties())), inputStream);
        }
        catch (MessagingException e) {
            log.error("Errore durante la creazione del MimeMessage", (Throwable)e);
            throw new PECParserException("Errore durante la creazione del MimeMessage", (Exception)((Object)e));
        }
    }

    public static boolean isMimeType(Part part, String mimeType) throws PECParserException {
        try {
            return part.isMimeType(mimeType);
        }
        catch (MessagingException e) {
            log.error("Errore durante la verifica del mime type {} per: {}", (Object)mimeType, (Object)MimeMessageUtils.getDescription(part));
            throw new PECParserException("Errore durante la verifica del mime type " + mimeType + " per: " + MimeMessageUtils.getDescription(part), (Exception)((Object)e));
        }
    }

    public static String getDescription(Part part) {
        try {
            return part.getDescription();
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione della descrizione", (Throwable)e);
            return "[NON_DISPONIBILE]";
        }
    }

    public static String getDisposition(Part part) throws PECParserException {
        try {
            return part.getDisposition();
        }
        catch (MessagingException e) {
            log.error("Errore durante la lettura della disposition per: {}", (Object)MimeMessageUtils.getDescription(part), (Object)e);
            throw new PECParserException("Errore durante la lettura della disposition per: " + MimeMessageUtils.getDescription(part), (Exception)((Object)e));
        }
    }

    public static String decodeText(String text) throws PECParserException {
        try {
            return MimeUtility.decodeText((String)text);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Errore durante la decodifica del testo: {}", (Object)text, (Object)e);
            throw new PECParserException("Errore durante la decodifica del testo: " + text, e);
        }
    }

    public static int getCount(Multipart multiPart) throws PECParserException {
        try {
            return multiPart.getCount();
        }
        catch (MessagingException e) {
            log.error("Errore durante la lettura del parametro count", (Throwable)e);
            throw new PECParserException("Errore durante la lettura del parametro count", (Exception)((Object)e));
        }
    }

    public static String getFileName(Part part) throws PECParserException {
        try {
            return part.getFileName();
        }
        catch (MessagingException e) {
            log.error("Errore durante la lettura del nome del file di: {}", (Object)MimeMessageUtils.getDescription(part), (Object)e);
            throw new PECParserException("Errore durante la lettura del nome del file di: " + MimeMessageUtils.getDescription(part), (Exception)((Object)e));
        }
    }

    public static BodyPart getBodyPart(Multipart multiPart, int index) throws PECParserException {
        try {
            return multiPart.getBodyPart(index);
        }
        catch (MessagingException e) {
            log.error("Errore durante la lettura della parte numero {}", (Object)index, (Object)e);
            throw new PECParserException("Errore durante la lettura della parte numero: " + index, (Exception)((Object)e));
        }
    }

    public static String getXAttachmentID(MimePart part) {
        List<String> values;
        try {
            values = MimeMessageUtils.getHeaderValues("X-Attachment-Id", (Part)part);
        }
        catch (PECParserException e) {
            return null;
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public static String getHeaderValue(String headerKey, Part part) throws PECParserException {
        List<String> values;
        try {
            values = MimeMessageUtils.getHeaderValues(headerKey, part);
        }
        catch (PECParserException e) {
            return null;
        }
        return values.isEmpty() ? null : values.get(0);
    }

    public static List<String> getHeaderValues(String headerKey, Part part) throws PECParserException {
        try {
            String[] res = part.getHeader(headerKey);
            if (res != null) {
                return Stream.of(res).collect(Collectors.toList());
            }
            return new ArrayList<String>();
        }
        catch (MessagingException e) {
            log.error("Errore durante l'estrazione dell'header: {} per di {}", new Object[]{headerKey, MimeMessageUtils.getDescription(part), e});
            throw new PECParserException("Errore durante l'estrazione del'header " + headerKey + " data handler per: " + MimeMessageUtils.getDescription(part), (Exception)((Object)e));
        }
    }

    public static DataHandler getDataHandler(Part part) throws PECParserException {
        try {
            return part.getDataHandler();
        }
        catch (MessagingException e) {
            log.error("Errore durante l'estrazione del data handler per: {}", (Object)MimeMessageUtils.getDescription(part), (Object)e);
            throw new PECParserException("Errore durante l'estrazione del data handler per: " + MimeMessageUtils.getDescription(part), (Exception)((Object)e));
        }
    }

    public static String getContentType(Part part) throws PECParserException {
        try {
            return part.getContentType();
        }
        catch (MessagingException e) {
            log.error("Errore durante l'estrazione del content type: {}", (Object)MimeMessageUtils.getDescription(part), (Object)e);
            throw new PECParserException("Errore durante l'estrazione del content type: " + MimeMessageUtils.getDescription(part), (Exception)((Object)e));
        }
    }

    public static Object getContent(Part part) throws PECParserException {
        Object content;
        try {
            content = part.getContent();
        }
        catch (MessagingException | IOException e) {
            if (part instanceof MimeMessage && BODYSTRUCTURE_LOADING_ERROR.equalsIgnoreCase(e.getMessage())) {
                try {
                    content = new MimeMessage((MimeMessage)part).getContent();
                }
                catch (MessagingException | IOException e1) {
                    log.error("Errore durante la lettura del contenuto di: {}", (Object)MimeMessageUtils.getDescription(part), (Object)e);
                    throw new PECParserException("Errore durante la lettura del contenuto di: " + MimeMessageUtils.getDescription(part), (Exception)e);
                }
            }
            if (MimeMessageUtils.isMimeType(part, "text/*")) {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    IOUtils.fastCopy(part.getInputStream(), os);
                    content = new String(os.toByteArray(), StandardCharsets.US_ASCII);
                }
                catch (MessagingException | IOException e1) {
                    throw new PECParserException("Errore durante la lettura del contenuto di: " + MimeMessageUtils.getDescription(part), (Exception)e);
                }
            }
            log.error("Errore durante la lettura del contenuto di: {}", (Object)MimeMessageUtils.getDescription(part), (Object)e);
            throw new PECParserException("Errore durante la lettura del contenuto di: " + MimeMessageUtils.getDescription(part), (Exception)e);
        }
        return content;
    }

    public static String getUniqueMessageID(MimeMessage mimeMessage) throws PECParserException {
        SimpleDateFormat df = new SimpleDateFormat(FORMATO_DATA);
        StringBuilder res = new StringBuilder();
        try {
            if (mimeMessage.getSender() != null && mimeMessage.getSender() instanceof InternetAddress) {
                InternetAddress ia = (InternetAddress)mimeMessage.getSender();
                res.append(ia.getAddress()).append("_");
            }
        }
        catch (MessagingException ia) {
            // empty catch block
        }
        try {
            List destinatari;
            if (mimeMessage.getAllRecipients() != null && !(destinatari = Stream.of(mimeMessage.getAllRecipients()).filter(r -> r != null && r instanceof InternetAddress).map(r -> ((InternetAddress)r).getAddress()).collect(Collectors.toList())).isEmpty()) {
                res.append(String.join((CharSequence)"_", destinatari));
            }
        }
        catch (MessagingException destinatari) {
            // empty catch block
        }
        boolean sd = false;
        boolean rd = false;
        try {
            if (mimeMessage.getSentDate() != null) {
                res.append(df.format(mimeMessage.getSentDate())).append("_");
                sd = true;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            if (mimeMessage.getReceivedDate() != null) {
                res.append(df.format(mimeMessage.getReceivedDate())).append("_");
                rd = true;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        if (res.length() == 0 || !rd && !sd) {
            return Timestamp.from(ZonedDateTime.now(ZI).toInstant()).hashCode() + UUID.randomUUID().toString();
        }
        try {
            return new String(MessageDigest.getInstance("SHA-256").digest(res.toString().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PECParserException("Errore in fase di elaborazione del messageID", e);
        }
    }
}

