/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MimeTypesUtil {
    public static final String CONTENT_TYPE_OCTETSTREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final String CONTENT_TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String CONTENT_TYPE_MULTIPART = "multipart/*";
    public static final String CONTENT_TYPE_DELIVERY_STATUS = "message/delivery-status";
    private static Map<String, List<String>> mimeTypesMap = new LinkedHashMap<String, List<String>>();

    public static String guessMimeType(String extension) {
        if (extension == null) {
            return null;
        }
        List<String> mimeType = mimeTypesMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(extension.toLowerCase())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (mimeType.isEmpty()) {
            return CONTENT_TYPE_OCTETSTREAM;
        }
        if (mimeType.size() == 1) {
            return (String)mimeType.get(0);
        }
        return MimeTypesUtil.excludeMimeTypes(List.of("/vnd.", "/x-"), mimeType);
    }

    static String excludeMimeTypes(List<String> pattern, List<String> mimeTypes) {
        List<String> nMime = new ArrayList<String>(mimeTypes);
        for (String p : pattern) {
            ArrayList<String> nMime2 = new ArrayList<String>(nMime);
            if ((nMime = nMime.stream().filter(m -> !m.contains(p)).toList()).isEmpty()) {
                return (String)nMime2.get(0);
            }
            if (nMime.size() != 1) continue;
            return nMime.get(0);
        }
        return mimeTypes.get(0);
    }

    public static String guessExtension(String fullMimeType) {
        if (fullMimeType == null) {
            return null;
        }
        return mimeTypesMap.entrySet().stream().filter(e -> fullMimeType.toLowerCase().contains(((String)e.getKey()).toLowerCase())).findFirst().map(e -> (String)((List)e.getValue()).get(0)).orElse(null);
    }

    static {
        mimeTypesMap.put("application/applixware", List.of("aw"));
        mimeTypesMap.put("application/atom+xml", List.of("atom"));
        mimeTypesMap.put("application/atomcat+xml", List.of("atomcat"));
        mimeTypesMap.put("application/atomsvc+xml", List.of("atomsvc"));
        mimeTypesMap.put("application/base64", List.of("mme"));
        mimeTypesMap.put("application/book", List.of("boo", "book"));
        mimeTypesMap.put("application/ccxml+xml", List.of("ccxml"));
        mimeTypesMap.put("application/ccxml+xml,", List.of("ccxml"));
        mimeTypesMap.put("application/cdmi-capability", List.of("cdmia"));
        mimeTypesMap.put("application/cdmi-container", List.of("cdmic"));
        mimeTypesMap.put("application/cdmi-domain", List.of("cdmid"));
        mimeTypesMap.put("application/cdmi-object", List.of("cdmio"));
        mimeTypesMap.put("application/cdmi-queue", List.of("cdmiq"));
        mimeTypesMap.put("application/clariscad", List.of("ccad"));
        mimeTypesMap.put("application/commonground", List.of("dp"));
        mimeTypesMap.put("application/cu-seeme", List.of("cu"));
        mimeTypesMap.put("application/davmount+xml", List.of("davmount"));
        mimeTypesMap.put("application/drafting", List.of("drw"));
        mimeTypesMap.put("application/dssc+der", List.of("dssc"));
        mimeTypesMap.put("application/dssc+xml", List.of("xdssc"));
        mimeTypesMap.put("application/ecmascript", List.of("ecma", "es"));
        mimeTypesMap.put("application/emma+xml", List.of("emma"));
        mimeTypesMap.put("application/envoy", List.of("evy"));
        mimeTypesMap.put("application/epub+zip", List.of("epub"));
        mimeTypesMap.put("application/excel", List.of("xl"));
        mimeTypesMap.put("application/exi", List.of("exi"));
        mimeTypesMap.put("application/font-tdpfr", List.of("pfr"));
        mimeTypesMap.put("application/fractals", List.of("fif"));
        mimeTypesMap.put("application/freeloader", List.of("frl"));
        mimeTypesMap.put("application/futuresplash", List.of("spl"));
        mimeTypesMap.put("application/groupwise", List.of("vew"));
        mimeTypesMap.put("application/hta", List.of("hta"));
        mimeTypesMap.put("application/hyperstudio", List.of("stk"));
        mimeTypesMap.put("application/i-deas", List.of("unv"));
        mimeTypesMap.put("application/inf", List.of("inf"));
        mimeTypesMap.put("application/internet-property-stream", List.of("acx"));
        mimeTypesMap.put("application/ipfix", List.of("ipfix"));
        mimeTypesMap.put("application/java-archive", List.of("jar"));
        mimeTypesMap.put("application/java-serialized-object", List.of("ser"));
        mimeTypesMap.put("application/java-vm", List.of("class"));
        mimeTypesMap.put("application/javascript", List.of("js"));
        mimeTypesMap.put("application/json", List.of("json"));
        mimeTypesMap.put("application/lost+xml", List.of("lostxml"));
        mimeTypesMap.put("application/mac-binhex40", List.of("hqx"));
        mimeTypesMap.put("application/mac-compactpro", List.of("cpt"));
        mimeTypesMap.put("application/mads+xml", List.of("mads"));
        mimeTypesMap.put("application/marc", List.of("mrc"));
        mimeTypesMap.put("application/marcxml+xml", List.of("mrcx"));
        mimeTypesMap.put("application/mathematica", List.of("ma", "mb", "nb"));
        mimeTypesMap.put("application/mathml+xml", List.of("mathml"));
        mimeTypesMap.put("application/mbedlet", List.of("mbd"));
        mimeTypesMap.put("application/mbox", List.of("mbox"));
        mimeTypesMap.put("application/mediaservercontrol+xml", List.of("mscml"));
        mimeTypesMap.put("application/metalink4+xml", List.of("meta4"));
        mimeTypesMap.put("application/mets+xml", List.of("mets"));
        mimeTypesMap.put("application/mime", List.of("aps"));
        mimeTypesMap.put("application/mods+xml", List.of("mods"));
        mimeTypesMap.put("application/mp21", List.of("m21"));
        mimeTypesMap.put("application/mp4", List.of("mp4s", "mp4"));
        mimeTypesMap.put("application/mspowerpoint", List.of("ppz"));
        mimeTypesMap.put("application/msword", List.of("doc", "dot"));
        mimeTypesMap.put("application/mxf", List.of("mxf"));
        mimeTypesMap.put("application/netmc", List.of("mcp"));
        mimeTypesMap.put(CONTENT_TYPE_OCTETSTREAM, List.of("bin", "class", "dms", "exe", "lha", "lzh"));
        mimeTypesMap.put("application/oda", List.of("oda"));
        mimeTypesMap.put("application/oebps-package+xml", List.of("opf"));
        mimeTypesMap.put("application/ogg", List.of("ogx"));
        mimeTypesMap.put("application/olescript", List.of("axs"));
        mimeTypesMap.put("application/onenote", List.of("onepkg", "onetmp", "onetoc", "onetoc2"));
        mimeTypesMap.put("application/patch-ops-error+xml", List.of("xer"));
        mimeTypesMap.put("application/pdf", List.of("pdf"));
        mimeTypesMap.put("application/pgp-encrypted", List.of("pgp"));
        mimeTypesMap.put("application/pgp-signature", List.of("asc", "sig", "pgp"));
        mimeTypesMap.put("application/pics-rules", List.of("prf"));
        mimeTypesMap.put("application/pkcs10", List.of("p10"));
        mimeTypesMap.put("application/pkcs7-mime", List.of("p7c", "p7m"));
        mimeTypesMap.put("application/pkcs7-signature", List.of("p7s"));
        mimeTypesMap.put("application/pkcs8", List.of("p8"));
        mimeTypesMap.put("application/pkix-attr-cert", List.of("ac"));
        mimeTypesMap.put("application/pkix-cert", List.of("cer"));
        mimeTypesMap.put("application/pkix-crl", List.of("crl"));
        mimeTypesMap.put("application/pkix-pkipath", List.of("pkipath"));
        mimeTypesMap.put("application/pkixcmp", List.of("pki"));
        mimeTypesMap.put("application/pls+xml", List.of("pls"));
        mimeTypesMap.put("application/postscript", List.of("ps", "eps", "ai"));
        mimeTypesMap.put("application/pro_eng", List.of("prt", "part"));
        mimeTypesMap.put("application/prs.cww", List.of("cww"));
        mimeTypesMap.put("application/pskc+xml", List.of("pskcxml"));
        mimeTypesMap.put("application/rdf+xml", List.of("rdf"));
        mimeTypesMap.put("application/reginfo+xml", List.of("rif"));
        mimeTypesMap.put("application/relax-ng-compact-syntax", List.of("rnc"));
        mimeTypesMap.put("application/resource-lists+xml", List.of("rl"));
        mimeTypesMap.put("application/resource-lists-diff+xml", List.of("rld"));
        mimeTypesMap.put("application/rls-services+xml", List.of("rs"));
        mimeTypesMap.put("application/rsd+xml", List.of("rsd"));
        mimeTypesMap.put("application/rss+xml", List.of("rss"));
        mimeTypesMap.put("application/rtf", List.of("rtf"));
        mimeTypesMap.put("application/sbml+xml", List.of("sbml"));
        mimeTypesMap.put("application/scvp-cv-request", List.of("scq"));
        mimeTypesMap.put("application/scvp-cv-response", List.of("scs"));
        mimeTypesMap.put("application/scvp-vp-request", List.of("spq"));
        mimeTypesMap.put("application/scvp-vp-response", List.of("spp"));
        mimeTypesMap.put("application/sdp", List.of("sdp"));
        mimeTypesMap.put("application/set", List.of("set"));
        mimeTypesMap.put("application/set-payment-initiation", List.of("setpay"));
        mimeTypesMap.put("application/set-registration-initiation", List.of("setreg"));
        mimeTypesMap.put("application/shf+xml", List.of("shf"));
        mimeTypesMap.put("application/smil", List.of("smi", "smil"));
        mimeTypesMap.put("application/smil+xml", List.of("smi", "smil"));
        mimeTypesMap.put("application/solids", List.of("sol"));
        mimeTypesMap.put("application/sounder", List.of("sdr"));
        mimeTypesMap.put("application/sparql-query", List.of("rq"));
        mimeTypesMap.put("application/sparql-results+xml", List.of("srx"));
        mimeTypesMap.put("application/srgs", List.of("gram"));
        mimeTypesMap.put("application/srgs+xml", List.of("grxml"));
        mimeTypesMap.put("application/sru+xml", List.of("sru"));
        mimeTypesMap.put("application/ssml+xml", List.of("ssml"));
        mimeTypesMap.put("application/step", List.of("step", "stp"));
        mimeTypesMap.put("application/streamingmedia", List.of("ssm"));
        mimeTypesMap.put("application/tei+xml", List.of("tei"));
        mimeTypesMap.put("application/thraud+xml", List.of("tfi"));
        mimeTypesMap.put("application/timestamped-data", List.of("tsd"));
        mimeTypesMap.put("application/vda", List.of("vda"));
        mimeTypesMap.put("application/vnd.3gpp.pic-bw-large", List.of("plb"));
        mimeTypesMap.put("application/vnd.3gpp.pic-bw-small", List.of("psb"));
        mimeTypesMap.put("application/vnd.3gpp.pic-bw-var", List.of("pvb"));
        mimeTypesMap.put("application/vnd.3gpp2.tcap", List.of("tcap"));
        mimeTypesMap.put("application/vnd.3m.post-it-notes", List.of("pwn"));
        mimeTypesMap.put("application/vnd.accpac.simply.aso", List.of("aso"));
        mimeTypesMap.put("application/vnd.accpac.simply.imp", List.of("imp"));
        mimeTypesMap.put("application/vnd.acucobol", List.of("acu"));
        mimeTypesMap.put("application/vnd.acucorp", List.of("acutc", "atc"));
        mimeTypesMap.put("application/vnd.adobe.air-application-installer-package+zip", List.of("air"));
        mimeTypesMap.put("application/vnd.adobe.fxp", List.of("fxp"));
        mimeTypesMap.put("application/vnd.adobe.xdp+xml", List.of("xdp"));
        mimeTypesMap.put("application/vnd.adobe.xfdf", List.of("xfdf"));
        mimeTypesMap.put("application/vnd.ahead.space", List.of("ahead"));
        mimeTypesMap.put("application/vnd.airzip.filesecure.azf", List.of("azf"));
        mimeTypesMap.put("application/vnd.airzip.filesecure.azs", List.of("azs"));
        mimeTypesMap.put("application/vnd.amazon.ebook", List.of("azw"));
        mimeTypesMap.put("application/vnd.americandynamics.acc", List.of("acc"));
        mimeTypesMap.put("application/vnd.amiga.ami", List.of("ami"));
        mimeTypesMap.put("application/vnd.android.package-archive", List.of("apk"));
        mimeTypesMap.put("application/vnd.anser-web-certificate-issue-initiation", List.of("cii"));
        mimeTypesMap.put("application/vnd.anser-web-funds-transfer-initiation", List.of("fti"));
        mimeTypesMap.put("application/vnd.antix.game-component", List.of("atx"));
        mimeTypesMap.put("application/vnd.apple.installer+xml", List.of("mpkg"));
        mimeTypesMap.put("application/vnd.apple.mpegurl", List.of("m3u8"));
        mimeTypesMap.put("application/vnd.arastra.swi", List.of("swi"));
        mimeTypesMap.put("application/vnd.aristanetworks.swi", List.of("swi"));
        mimeTypesMap.put("application/vnd.audiograph", List.of("aep"));
        mimeTypesMap.put("application/vnd.blueice.multipass", List.of("mpm"));
        mimeTypesMap.put("application/vnd.bmi", List.of("bmi"));
        mimeTypesMap.put("application/vnd.businessobjects", List.of("rep"));
        mimeTypesMap.put("application/vnd.chemdraw+xml", List.of("cdxml"));
        mimeTypesMap.put("application/vnd.chipnuts.karaoke-mmd", List.of("mmd"));
        mimeTypesMap.put("application/vnd.cinderella", List.of("cdy"));
        mimeTypesMap.put("application/vnd.claymore", List.of("cla"));
        mimeTypesMap.put("application/vnd.cloanto.rp9", List.of("rp9"));
        mimeTypesMap.put("application/vnd.clonk.c4group", List.of("c4d", "c4f", "c4g", "c4p", "c4u"));
        mimeTypesMap.put("application/vnd.cluetrust.cartomobile-config", List.of("c11amc"));
        mimeTypesMap.put("application/vnd.cluetrust.cartomobile-config-pkg", List.of("c11amz"));
        mimeTypesMap.put("application/vnd.commonspace", List.of("csp"));
        mimeTypesMap.put("application/vnd.contact.cmsg", List.of("cdbcmsg"));
        mimeTypesMap.put("application/vnd.cosmocaller", List.of("cmc"));
        mimeTypesMap.put("application/vnd.crick.clicker", List.of("clkx"));
        mimeTypesMap.put("application/vnd.crick.clicker.keyboard", List.of("clkk"));
        mimeTypesMap.put("application/vnd.crick.clicker.palette", List.of("clkp"));
        mimeTypesMap.put("application/vnd.crick.clicker.template", List.of("clkt"));
        mimeTypesMap.put("application/vnd.crick.clicker.wordbank", List.of("clkw"));
        mimeTypesMap.put("application/vnd.criticaltools.wbs+xml", List.of("wbs"));
        mimeTypesMap.put("application/vnd.ctc-posml", List.of("pml"));
        mimeTypesMap.put("application/vnd.cups-ppd", List.of("ppd"));
        mimeTypesMap.put("application/vnd.curl.car", List.of("car"));
        mimeTypesMap.put("application/vnd.curl.pcurl", List.of("pcurl"));
        mimeTypesMap.put("application/vnd.data-vision.rdz", List.of("rdz"));
        mimeTypesMap.put("application/vnd.denovo.fcselayout-link", List.of("fe_launch"));
        mimeTypesMap.put("application/vnd.dna", List.of("dna"));
        mimeTypesMap.put("application/vnd.dolby.mlp", List.of("mlp"));
        mimeTypesMap.put("application/vnd.dpgraph", List.of("dpg"));
        mimeTypesMap.put("application/vnd.dreamfactory", List.of("dfac"));
        mimeTypesMap.put("application/vnd.dvb.ait", List.of("ait"));
        mimeTypesMap.put("application/vnd.dvb.service", List.of("svc"));
        mimeTypesMap.put("application/vnd.dynageo", List.of("geo"));
        mimeTypesMap.put("application/vnd.ecowin.chart", List.of("mag"));
        mimeTypesMap.put("application/vnd.enliven", List.of("nml"));
        mimeTypesMap.put("application/vnd.epson.esf", List.of("esf"));
        mimeTypesMap.put("application/vnd.epson.msf", List.of("msf"));
        mimeTypesMap.put("application/vnd.epson.quickanime", List.of("qam"));
        mimeTypesMap.put("application/vnd.epson.salt", List.of("slt"));
        mimeTypesMap.put("application/vnd.epson.ssf", List.of("ssf"));
        mimeTypesMap.put("application/vnd.eszigno3+xml", List.of("es3", "et3"));
        mimeTypesMap.put("application/vnd.ezpix-album", List.of("ez2"));
        mimeTypesMap.put("application/vnd.ezpix-package", List.of("ez3"));
        mimeTypesMap.put("application/vnd.fdf", List.of("fdf"));
        mimeTypesMap.put("application/vnd.fdsn.mseed", List.of("mseed"));
        mimeTypesMap.put("application/vnd.fdsn.seed", List.of("dataless", "seed"));
        mimeTypesMap.put("application/vnd.flographit", List.of("gph"));
        mimeTypesMap.put("application/vnd.fluxtime.clip", List.of("ftc"));
        mimeTypesMap.put("application/vnd.framemaker", List.of("book", "fm", "frame", "maker"));
        mimeTypesMap.put("application/vnd.frogans.fnc", List.of("fnc"));
        mimeTypesMap.put("application/vnd.frogans.ltf", List.of("ltf"));
        mimeTypesMap.put("application/vnd.fsc.weblaunch", List.of("fsc"));
        mimeTypesMap.put("application/vnd.fujitsu.oasys", List.of("oas"));
        mimeTypesMap.put("application/vnd.fujitsu.oasys2", List.of("oa2"));
        mimeTypesMap.put("application/vnd.fujitsu.oasys3", List.of("oa3"));
        mimeTypesMap.put("application/vnd.fujitsu.oasysgp", List.of("fg5"));
        mimeTypesMap.put("application/vnd.fujitsu.oasysprs", List.of("bh2"));
        mimeTypesMap.put("application/vnd.fujixerox.ddd", List.of("ddd"));
        mimeTypesMap.put("application/vnd.fujixerox.docuworks", List.of("xdw"));
        mimeTypesMap.put("application/vnd.fujixerox.docuworks.binder", List.of("xbd"));
        mimeTypesMap.put("application/vnd.fuzzysheet", List.of("fzs"));
        mimeTypesMap.put("application/vnd.genomatix.tuxedo", List.of("txd"));
        mimeTypesMap.put("application/vnd.geogebra.file", List.of("ggb"));
        mimeTypesMap.put("application/vnd.geogebra.tool", List.of("ggt"));
        mimeTypesMap.put("application/vnd.geometry-explorer", List.of("gex", "gre"));
        mimeTypesMap.put("application/vnd.geonext", List.of("gxt"));
        mimeTypesMap.put("application/vnd.geoplan", List.of("g2w"));
        mimeTypesMap.put("application/vnd.geospace", List.of("g3w"));
        mimeTypesMap.put("application/vnd.gmx", List.of("gmx"));
        mimeTypesMap.put("application/vnd.google-earth.kml+xml", List.of("kml"));
        mimeTypesMap.put("application/vnd.google-earth.kmz", List.of("kmz"));
        mimeTypesMap.put("application/vnd.grafeq", List.of("gqf", "gqs"));
        mimeTypesMap.put("application/vnd.groove-account", List.of("gac"));
        mimeTypesMap.put("application/vnd.groove-help", List.of("ghf"));
        mimeTypesMap.put("application/vnd.groove-identity-message", List.of("gim"));
        mimeTypesMap.put("application/vnd.groove-injector", List.of("grv"));
        mimeTypesMap.put("application/vnd.groove-tool-message", List.of("gtm"));
        mimeTypesMap.put("application/vnd.groove-tool-template", List.of("tpl"));
        mimeTypesMap.put("application/vnd.groove-vcard", List.of("vcg"));
        mimeTypesMap.put("application/vnd.hal+xml", List.of("hal"));
        mimeTypesMap.put("application/vnd.handheld-entertainment+xml", List.of("zmm"));
        mimeTypesMap.put("application/vnd.hbci", List.of("hbci"));
        mimeTypesMap.put("application/vnd.hhe.lesson-player", List.of("les"));
        mimeTypesMap.put("application/vnd.hp-hpgl", List.of("hpgl", "hgl", "hpg"));
        mimeTypesMap.put("application/vnd.hp-hpid", List.of("hpid"));
        mimeTypesMap.put("application/vnd.hp-hps", List.of("hps"));
        mimeTypesMap.put("application/vnd.hp-jlyt", List.of("jlt"));
        mimeTypesMap.put("application/vnd.hp-pcl", List.of("pcl"));
        mimeTypesMap.put("application/vnd.hp-pclxl", List.of("pclxl"));
        mimeTypesMap.put("application/vnd.hydrostatix.sof-data", List.of("sfd-hdstx"));
        mimeTypesMap.put("application/vnd.hzn-3d-crossword", List.of("x3d"));
        mimeTypesMap.put("application/vnd.ibm.minipay", List.of("mpy"));
        mimeTypesMap.put("application/vnd.ibm.modcap", List.of("afp", "list3820", "listafp"));
        mimeTypesMap.put("application/vnd.ibm.rights-management", List.of("irm"));
        mimeTypesMap.put("application/vnd.ibm.secure-container", List.of("sc"));
        mimeTypesMap.put("application/vnd.iccprofile", List.of("icc", "icm"));
        mimeTypesMap.put("application/vnd.igloader", List.of("igl"));
        mimeTypesMap.put("application/vnd.immervision-ivp", List.of("ivp"));
        mimeTypesMap.put("application/vnd.immervision-ivu", List.of("ivu"));
        mimeTypesMap.put("application/vnd.insors.igm", List.of("igm"));
        mimeTypesMap.put("application/vnd.intercon.formnet", List.of("xpw", "xpx"));
        mimeTypesMap.put("application/vnd.intergeo", List.of("i2g"));
        mimeTypesMap.put("application/vnd.intu.qbo", List.of("qbo"));
        mimeTypesMap.put("application/vnd.intu.qfx", List.of("qfx"));
        mimeTypesMap.put("application/vnd.ipunplugged.rcprofile", List.of("rcprofile"));
        mimeTypesMap.put("application/vnd.irepository.package+xml", List.of("irp"));
        mimeTypesMap.put("application/vnd.is-xpr", List.of("xpr"));
        mimeTypesMap.put("application/vnd.isac.fcs", List.of("fcs"));
        mimeTypesMap.put("application/vnd.jam", List.of("jam"));
        mimeTypesMap.put("application/vnd.jcp.javame.midlet-rms", List.of("rms"));
        mimeTypesMap.put("application/vnd.jisp", List.of("jisp"));
        mimeTypesMap.put("application/vnd.joost.joda-archive", List.of("joda"));
        mimeTypesMap.put("application/vnd.kahootz", List.of("ktr", "ktz"));
        mimeTypesMap.put("application/vnd.kde.karbon", List.of("karbon"));
        mimeTypesMap.put("application/vnd.kde.kchart", List.of("chrt"));
        mimeTypesMap.put("application/vnd.kde.kformula", List.of("kfo"));
        mimeTypesMap.put("application/vnd.kde.kivio", List.of("flw"));
        mimeTypesMap.put("application/vnd.kde.kontour", List.of("kon"));
        mimeTypesMap.put("application/vnd.kde.kpresenter", List.of("kpr", "kpt"));
        mimeTypesMap.put("application/vnd.kde.kspread", List.of("ksp"));
        mimeTypesMap.put("application/vnd.kde.kword", List.of("kwd", "kwt"));
        mimeTypesMap.put("application/vnd.kenameaapp", List.of("htke"));
        mimeTypesMap.put("application/vnd.kidspiration", List.of("kia"));
        mimeTypesMap.put("application/vnd.kinar", List.of("kne", "knp"));
        mimeTypesMap.put("application/vnd.koan", List.of("skd", "skt", "skm", "skp"));
        mimeTypesMap.put("application/vnd.kodak-descriptor", List.of("sse"));
        mimeTypesMap.put("application/vnd.las.las+xml", List.of("lasxml"));
        mimeTypesMap.put("application/vnd.llamagraphics.life-balance.desktop", List.of("lbd"));
        mimeTypesMap.put("application/vnd.llamagraphics.life-balance.exchange+xml", List.of("lbe"));
        mimeTypesMap.put("application/vnd.lotus-1-2-3", List.of("123"));
        mimeTypesMap.put("application/vnd.lotus-approach", List.of("apr"));
        mimeTypesMap.put("application/vnd.lotus-freelance", List.of("pre"));
        mimeTypesMap.put("application/vnd.lotus-notes", List.of("nsf"));
        mimeTypesMap.put("application/vnd.lotus-organizer", List.of("org"));
        mimeTypesMap.put("application/vnd.lotus-screencam", List.of("scm"));
        mimeTypesMap.put("application/vnd.lotus-wordpro", List.of("lwp"));
        mimeTypesMap.put("application/vnd.macports.portpkg", List.of("portpkg"));
        mimeTypesMap.put("application/vnd.mcd", List.of("mcd"));
        mimeTypesMap.put("application/vnd.medcalcdata", List.of("mc1"));
        mimeTypesMap.put("application/vnd.mediastation.cdkey", List.of("cdkey"));
        mimeTypesMap.put("application/vnd.mfer", List.of("mwf"));
        mimeTypesMap.put("application/vnd.mfmp", List.of("mfm"));
        mimeTypesMap.put("application/vnd.micrografx.flo", List.of("flo"));
        mimeTypesMap.put("application/vnd.micrografx.igx", List.of("igx"));
        mimeTypesMap.put("application/vnd.mif", List.of("mif"));
        mimeTypesMap.put("application/vnd.mobius.daf", List.of("daf"));
        mimeTypesMap.put("application/vnd.mobius.dis", List.of("dis"));
        mimeTypesMap.put("application/vnd.mobius.mbk", List.of("mbk"));
        mimeTypesMap.put("application/vnd.mobius.mqy", List.of("mqy"));
        mimeTypesMap.put("application/vnd.mobius.msl", List.of("msl"));
        mimeTypesMap.put("application/vnd.mobius.plc", List.of("plc"));
        mimeTypesMap.put("application/vnd.mobius.txf", List.of("txf"));
        mimeTypesMap.put("application/vnd.mophun.application", List.of("mpn"));
        mimeTypesMap.put("application/vnd.mophun.certificate", List.of("mpc"));
        mimeTypesMap.put("application/vnd.mozilla.xul+xml", List.of("xul"));
        mimeTypesMap.put("application/vnd.ms-artgalry", List.of("cil"));
        mimeTypesMap.put("application/vnd.ms-cab-compressed", List.of("cab"));
        mimeTypesMap.put("application/vnd.ms-excel", List.of("xls", "xla", "xlc", "xlm", "xlt", "xlw"));
        mimeTypesMap.put("application/vnd.ms-excel.addin.macroenabled.12", List.of("xlam"));
        mimeTypesMap.put("application/vnd.ms-excel.sheet.binary.macroenabled.12", List.of("xlsb"));
        mimeTypesMap.put("application/vnd.ms-excel.sheet.macroenabled.12", List.of("xlsm"));
        mimeTypesMap.put("application/vnd.ms-excel.template.macroenabled.12", List.of("xltm"));
        mimeTypesMap.put("application/vnd.ms-fontobject", List.of("eot"));
        mimeTypesMap.put("application/vnd.ms-htmlhelp", List.of("chm"));
        mimeTypesMap.put("application/vnd.ms-ims", List.of("ims"));
        mimeTypesMap.put("application/vnd.ms-lrm", List.of("lrm"));
        mimeTypesMap.put("application/vnd.ms-officetheme", List.of("thmx"));
        mimeTypesMap.put("application/vnd.ms-outlook", List.of("msg"));
        mimeTypesMap.put("application/vnd.ms-pki.certstore", List.of("sst"));
        mimeTypesMap.put("application/vnd.ms-pki.pko", List.of("pko"));
        mimeTypesMap.put("application/vnd.ms-pki.seccat", List.of("cat"));
        mimeTypesMap.put("application/vnd.ms-pki.stl", List.of("stl"));
        mimeTypesMap.put("application/vnd.ms-pkicertstore", List.of("sst"));
        mimeTypesMap.put("application/vnd.ms-pkiseccat", List.of("cat"));
        mimeTypesMap.put("application/vnd.ms-pkistl", List.of("stl"));
        mimeTypesMap.put("application/vnd.ms-powerpoint", List.of("ppt", "pps", "pot"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.addin.macroenabled.12", List.of("ppam"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.presentation.macroenabled.12", List.of("pptm"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.slide.macroenabled.12", List.of("sldm"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.slideshow.macroenabled.12", List.of("ppsm"));
        mimeTypesMap.put("application/vnd.ms-powerpoint.template.macroenabled.12", List.of("potm"));
        mimeTypesMap.put("application/vnd.ms-project", List.of("mpp"));
        mimeTypesMap.put("application/vnd.ms-word.document.macroenabled.12", List.of("docm"));
        mimeTypesMap.put("application/vnd.ms-word.template.macroenabled.12", List.of("dotm"));
        mimeTypesMap.put("application/vnd.ms-works", List.of("wps", "wks", "wdb", "wcm"));
        mimeTypesMap.put("application/vnd.ms-wpl", List.of("wpl"));
        mimeTypesMap.put("application/vnd.ms-xpsdocument", List.of("xps"));
        mimeTypesMap.put("application/vnd.mseq", List.of("mseq"));
        mimeTypesMap.put("application/vnd.musician", List.of("mus"));
        mimeTypesMap.put("application/vnd.muvee.style", List.of("msty"));
        mimeTypesMap.put("application/vnd.neurolanguage.nlu", List.of("nlu"));
        mimeTypesMap.put("application/vnd.noblenet-directory", List.of("nnd"));
        mimeTypesMap.put("application/vnd.noblenet-sealer", List.of("nns"));
        mimeTypesMap.put("application/vnd.noblenet-web", List.of("nnw"));
        mimeTypesMap.put("application/vnd.nokia.configuration-message", List.of("ncm"));
        mimeTypesMap.put("application/vnd.nokia.n-gage.data", List.of("ngdat"));
        mimeTypesMap.put("application/vnd.nokia.n-gage.symbian.install", List.of("n-gage"));
        mimeTypesMap.put("application/vnd.nokia.radio-preset", List.of("rpst"));
        mimeTypesMap.put("application/vnd.nokia.radio-presets", List.of("rpss"));
        mimeTypesMap.put("application/vnd.nokia.ringing-tone", List.of("rng"));
        mimeTypesMap.put("application/vnd.novadigm.edm", List.of("edm"));
        mimeTypesMap.put("application/vnd.novadigm.edx", List.of("edx"));
        mimeTypesMap.put("application/vnd.novadigm.ext", List.of("ext"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.chart", List.of("odc"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.chart-template", List.of("otc"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.database", List.of("odb"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.formula", List.of("odf"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.formula-template", List.of("odft"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.graphics", List.of("odg"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.graphics-template", List.of("otg"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.image", List.of("odi"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.image-template", List.of("oti"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.presentation", List.of("odp"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.presentation-template", List.of("otp"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.spreadsheet", List.of("ods"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.spreadsheet-template", List.of("ots"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text", List.of("odt"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text-master", List.of("otm", "odm"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text-template", List.of("ott"));
        mimeTypesMap.put("application/vnd.oasis.opendocument.text-web", List.of("oth"));
        mimeTypesMap.put("application/vnd.olpc-sugar", List.of("xo"));
        mimeTypesMap.put("application/vnd.oma.dd2+xml", List.of("dd2"));
        mimeTypesMap.put("application/vnd.openofficeorg.extension", List.of("oxt"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", List.of("pptx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.slide", List.of("sldx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.slideshow", List.of("ppsx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.presentationml.template", List.of("potx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", List.of("xlsx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.spreadsheetml.template", List.of("xltx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", List.of("docx"));
        mimeTypesMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.template", List.of("dotx"));
        mimeTypesMap.put("application/vnd.osgeo.mapguide.package", List.of("mgp"));
        mimeTypesMap.put("application/vnd.osgi.dp", List.of("dp"));
        mimeTypesMap.put("application/vnd.palm", List.of("oprc", "pqa", "pdb"));
        mimeTypesMap.put("application/vnd.pawaafile", List.of("paw"));
        mimeTypesMap.put("application/vnd.pg.format", List.of("str"));
        mimeTypesMap.put("application/vnd.pg.osasli", List.of("ei6"));
        mimeTypesMap.put("application/vnd.picsel", List.of("efif"));
        mimeTypesMap.put("application/vnd.pmi.widget", List.of("wg"));
        mimeTypesMap.put("application/vnd.pocketlearn", List.of("plf"));
        mimeTypesMap.put("application/vnd.powerbuilder6", List.of("pbd"));
        mimeTypesMap.put("application/vnd.previewsystems.box", List.of("box"));
        mimeTypesMap.put("application/vnd.proteus.magazine", List.of("mgz"));
        mimeTypesMap.put("application/vnd.publishare-delta-tree", List.of("qps"));
        mimeTypesMap.put("application/vnd.pvi.ptid1", List.of("ptid"));
        mimeTypesMap.put("application/vnd.quark.quarkxpress", List.of("qwd", "qwt", "qxb", "qxd", "qxl", "qxt"));
        mimeTypesMap.put("application/vnd.realvnc.bed", List.of("bed"));
        mimeTypesMap.put("application/vnd.recordare.musicxml", List.of("mxl"));
        mimeTypesMap.put("application/vnd.recordare.musicxml+xml", List.of("musicxml"));
        mimeTypesMap.put("application/vnd.rig.cryptonote", List.of("cryptonote"));
        mimeTypesMap.put("application/vnd.rim.cod", List.of("cod"));
        mimeTypesMap.put("application/vnd.rn-realmedia", List.of("rm"));
        mimeTypesMap.put("application/vnd.rn-realplayer", List.of("rnx"));
        mimeTypesMap.put("application/vnd.route66.link66+xml", List.of("link66"));
        mimeTypesMap.put("application/vnd.sailingtracker.track", List.of("st"));
        mimeTypesMap.put("application/vnd.seemail", List.of("see"));
        mimeTypesMap.put("application/vnd.sema", List.of("sema"));
        mimeTypesMap.put("application/vnd.semd", List.of("semd"));
        mimeTypesMap.put("application/vnd.semf", List.of("semf"));
        mimeTypesMap.put("application/vnd.shana.informed.formdata", List.of("ifm"));
        mimeTypesMap.put("application/vnd.shana.informed.formtemplate", List.of("itp"));
        mimeTypesMap.put("application/vnd.shana.informed.interchange", List.of("iif"));
        mimeTypesMap.put("application/vnd.shana.informed.package", List.of("ipk"));
        mimeTypesMap.put("application/vnd.simtech-mindmapper", List.of("twd", "twds"));
        mimeTypesMap.put("application/vnd.smaf", List.of("mmf"));
        mimeTypesMap.put("application/vnd.smart.teacher", List.of("teacher"));
        mimeTypesMap.put("application/vnd.solent.sdkm+xml", List.of("sdkd", "sdkm"));
        mimeTypesMap.put("application/vnd.spotfire.dxp", List.of("dxp"));
        mimeTypesMap.put("application/vnd.spotfire.sfs", List.of("sfs"));
        mimeTypesMap.put("application/vnd.stardivision.calc", List.of("sdc"));
        mimeTypesMap.put("application/vnd.stardivision.draw", List.of("sda"));
        mimeTypesMap.put("application/vnd.stardivision.impress", List.of("sdd"));
        mimeTypesMap.put("application/vnd.stardivision.math", List.of("smf"));
        mimeTypesMap.put("application/vnd.stardivision.writer", List.of("sdw", "vor"));
        mimeTypesMap.put("application/vnd.stardivision.writer-global", List.of("sgl"));
        mimeTypesMap.put("application/vnd.stepmania.stepchart", List.of("sm"));
        mimeTypesMap.put("application/vnd.sun.xml.calc", List.of("sxc"));
        mimeTypesMap.put("application/vnd.sun.xml.calc.template", List.of("stc"));
        mimeTypesMap.put("application/vnd.sun.xml.draw", List.of("sxd"));
        mimeTypesMap.put("application/vnd.sun.xml.draw.template", List.of("std"));
        mimeTypesMap.put("application/vnd.sun.xml.impress", List.of("sxi"));
        mimeTypesMap.put("application/vnd.sun.xml.impress.template", List.of("sti"));
        mimeTypesMap.put("application/vnd.sun.xml.math", List.of("sxm"));
        mimeTypesMap.put("application/vnd.sun.xml.writer", List.of("sxw"));
        mimeTypesMap.put("application/vnd.sun.xml.writer.global", List.of("sxg"));
        mimeTypesMap.put("application/vnd.sun.xml.writer.template", List.of("stw"));
        mimeTypesMap.put("application/vnd.sus-calendar", List.of("sus", "susp"));
        mimeTypesMap.put("application/vnd.svd", List.of("svd"));
        mimeTypesMap.put("application/vnd.symbian.install", List.of("sis", "sisx"));
        mimeTypesMap.put("application/vnd.syncml+xml", List.of("xsm"));
        mimeTypesMap.put("application/vnd.syncml.dm+wbxml", List.of("bdm"));
        mimeTypesMap.put("application/vnd.syncml.dm+xml", List.of("xdm"));
        mimeTypesMap.put("application/vnd.tao.intent-module-archive", List.of("tao"));
        mimeTypesMap.put("application/vnd.tmobile-livetv", List.of("tmo"));
        mimeTypesMap.put("application/vnd.trid.tpt", List.of("tpt"));
        mimeTypesMap.put("application/vnd.triscape.mxs", List.of("mxs"));
        mimeTypesMap.put("application/vnd.trueapp", List.of("tra"));
        mimeTypesMap.put("application/vnd.ufdl", List.of("ufd", "ufdl"));
        mimeTypesMap.put("application/vnd.uiq.theme", List.of("utz"));
        mimeTypesMap.put("application/vnd.umajin", List.of("umj"));
        mimeTypesMap.put("application/vnd.unity", List.of("unityweb"));
        mimeTypesMap.put("application/vnd.uoml+xml", List.of("uoml"));
        mimeTypesMap.put("application/vnd.vcx", List.of("vcx"));
        mimeTypesMap.put("application/vnd.visio", List.of("vsd", "vsw", "vss", "vst"));
        mimeTypesMap.put("application/vnd.visio2013", List.of("vsdx"));
        mimeTypesMap.put("application/vnd.visionary", List.of("vis"));
        mimeTypesMap.put("application/vnd.vsf", List.of("vsf"));
        mimeTypesMap.put("application/vnd.wap.sic", List.of("sic"));
        mimeTypesMap.put("application/vnd.wap.slc", List.of("slc"));
        mimeTypesMap.put("application/vnd.wap.wbxml", List.of("wbxml"));
        mimeTypesMap.put("application/vnd.wap.wmlc", List.of("wmlc"));
        mimeTypesMap.put("application/vnd.wap.wmlscriptc", List.of("wmlsc"));
        mimeTypesMap.put("application/vnd.webturbo", List.of("wtb"));
        mimeTypesMap.put("application/vnd.wolfram.player", List.of("nbp"));
        mimeTypesMap.put("application/vnd.wordperfect", List.of("wpd"));
        mimeTypesMap.put("application/vnd.wqd", List.of("wqd"));
        mimeTypesMap.put("application/vnd.wt.stf", List.of("stf"));
        mimeTypesMap.put("application/vnd.xara", List.of("web", "xar"));
        mimeTypesMap.put("application/vnd.xfdl", List.of("xfdl"));
        mimeTypesMap.put("application/vnd.yamaha.hv-dic", List.of("hvd"));
        mimeTypesMap.put("application/vnd.yamaha.hv-script", List.of("hvs"));
        mimeTypesMap.put("application/vnd.yamaha.hv-voice", List.of("hvp"));
        mimeTypesMap.put("application/vnd.yamaha.openscoreformat", List.of("osf"));
        mimeTypesMap.put("application/vnd.yamaha.openscoreformat.osfpvg+xml", List.of("osfpvg"));
        mimeTypesMap.put("application/vnd.yamaha.smaf-audio", List.of("saf"));
        mimeTypesMap.put("application/vnd.yamaha.smaf-phrase", List.of("spf"));
        mimeTypesMap.put("application/vnd.yellowriver-custom-menu", List.of("cmp"));
        mimeTypesMap.put("application/vnd.zul", List.of("zir", "zirz"));
        mimeTypesMap.put("application/vnd.zzazz.deck+xml", List.of("zaz"));
        mimeTypesMap.put("application/vocaltec-media-desc", List.of("vmd"));
        mimeTypesMap.put("application/vocaltec-media-file", List.of("vmf"));
        mimeTypesMap.put("application/voicexml+xml", List.of("vxml"));
        mimeTypesMap.put("application/widget", List.of("wgt"));
        mimeTypesMap.put("application/winhlp", List.of("hlp"));
        mimeTypesMap.put("application/wordperfect", List.of("wp", "wp6"));
        mimeTypesMap.put("application/wordperfect6.0", List.of("w60", "wp5"));
        mimeTypesMap.put("application/wordperfect6.1", List.of("w61"));
        mimeTypesMap.put("application/wsdl+xml", List.of("wsdl"));
        mimeTypesMap.put("application/wspolicy+xml", List.of("wspolicy"));
        mimeTypesMap.put("application/x-123", List.of("wk1"));
        mimeTypesMap.put("application/x-7z-compressed", List.of("7z"));
        mimeTypesMap.put("application/x-abiword", List.of("abw"));
        mimeTypesMap.put("application/x-ace-compressed", List.of("ace"));
        mimeTypesMap.put("application/x-aim", List.of("aim"));
        mimeTypesMap.put("application/x-apple-diskimage", List.of("dmg"));
        mimeTypesMap.put("application/x-authorware-bin", List.of("aab"));
        mimeTypesMap.put("application/x-authorware-map", List.of("aam"));
        mimeTypesMap.put("application/x-authorware-seg", List.of("aas"));
        mimeTypesMap.put("application/x-bcpio", List.of("bcpio"));
        mimeTypesMap.put("application/x-bittorrent", List.of("torrent"));
        mimeTypesMap.put("application/x-bsh", List.of("bsh"));
        mimeTypesMap.put("application/x-bytecode.python", List.of("pyc"));
        mimeTypesMap.put("application/x-bzip", List.of("bz"));
        mimeTypesMap.put("application/x-bzip2", List.of("boz", "bz2"));
        mimeTypesMap.put("application/x-cdf", List.of("cdf"));
        mimeTypesMap.put("application/x-cdlink", List.of("vcd"));
        mimeTypesMap.put("application/x-chat", List.of("cha", "chat"));
        mimeTypesMap.put("application/x-chess-pgn", List.of("pgn"));
        mimeTypesMap.put("application/x-cocoa", List.of("cco"));
        mimeTypesMap.put("application/x-compress", List.of("z"));
        mimeTypesMap.put("application/x-compressed", List.of("tgz"));
        mimeTypesMap.put("application/x-conference", List.of("nsc"));
        mimeTypesMap.put("application/x-cpio", List.of("cpio"));
        mimeTypesMap.put("application/x-cpt", List.of("cpt"));
        mimeTypesMap.put("application/x-csh", List.of("csh"));
        mimeTypesMap.put("application/x-debian-package", List.of("deb", "udeb"));
        mimeTypesMap.put("application/x-deepv", List.of("deepv"));
        mimeTypesMap.put("application/x-director", List.of("dir", "dcr", "dxr"));
        mimeTypesMap.put("application/x-doom", List.of("wad"));
        mimeTypesMap.put("application/x-dtbncx+xml", List.of("ncx"));
        mimeTypesMap.put("application/x-dtbook+xml", List.of("dtb"));
        mimeTypesMap.put("application/x-dtbresource+xml", List.of("res"));
        mimeTypesMap.put("application/x-dvi", List.of("dvi"));
        mimeTypesMap.put("application/x-elc", List.of("elc"));
        mimeTypesMap.put("application/x-envoy", List.of("env", "evy"));
        mimeTypesMap.put("application/x-esrehber", List.of("es"));
        mimeTypesMap.put("application/x-excel", List.of("xlc", "xlb", "xld", "xlk", "xlm", "xll", "xlt", "xlv"));
        mimeTypesMap.put("application/x-font-bdf", List.of("bdf"));
        mimeTypesMap.put("application/x-font-ghostscript", List.of("gsf"));
        mimeTypesMap.put("application/x-font-linux-psf", List.of("psf"));
        mimeTypesMap.put("application/x-font-otf", List.of("otf"));
        mimeTypesMap.put("application/x-font-pcf", List.of("pcf"));
        mimeTypesMap.put("application/x-font-snf", List.of("snf"));
        mimeTypesMap.put("application/x-font-ttf", List.of("ttc", "ttf"));
        mimeTypesMap.put("application/x-font-type1", List.of("afm", "pfm", "pfa", "pfb"));
        mimeTypesMap.put("application/x-font-woff", List.of("woff"));
        mimeTypesMap.put("application/x-freelance", List.of("pre"));
        mimeTypesMap.put("application/x-futuresplash", List.of("spl"));
        mimeTypesMap.put("application/x-gnumeric", List.of("gnumeric"));
        mimeTypesMap.put("application/x-gsp", List.of("gsp"));
        mimeTypesMap.put("application/x-gss", List.of("gss"));
        mimeTypesMap.put("application/x-gtar", List.of("gtar"));
        mimeTypesMap.put("application/x-gzip", List.of("gz"));
        mimeTypesMap.put("application/x-hdf", List.of("hdf"));
        mimeTypesMap.put("application/x-helpfile", List.of("help"));
        mimeTypesMap.put("application/x-httpd-imap", List.of("imap"));
        mimeTypesMap.put("application/x-ima", List.of("ima"));
        mimeTypesMap.put("application/x-internet-signup", List.of("ins", "isp"));
        mimeTypesMap.put("application/x-internett-signup", List.of("ins"));
        mimeTypesMap.put("application/x-inventor", List.of("iv"));
        mimeTypesMap.put("application/x-ip2", List.of("ip"));
        mimeTypesMap.put("application/x-iphone", List.of("iii"));
        mimeTypesMap.put("application/x-java-class", List.of("class"));
        mimeTypesMap.put("application/x-java-commerce", List.of("jcm"));
        mimeTypesMap.put("application/x-java-jnlp-file", List.of("jnlp"));
        mimeTypesMap.put("application/x-javascript", List.of("js"));
        mimeTypesMap.put("application/x-killustrator", List.of("kil"));
        mimeTypesMap.put("application/x-koan", List.of("skd", "skm", "skp", "skt"));
        mimeTypesMap.put("application/x-latex", List.of("latex"));
        mimeTypesMap.put("application/x-lha", List.of("lha"));
        mimeTypesMap.put("application/x-livescreen", List.of("ivy"));
        mimeTypesMap.put("application/x-lotus", List.of("wq1"));
        mimeTypesMap.put("application/x-lzh", List.of("lzh"));
        mimeTypesMap.put("application/x-lzx", List.of("lzx"));
        mimeTypesMap.put("application/x-mac-binhex40", List.of("hqx"));
        mimeTypesMap.put("application/x-macbinary", List.of("bin"));
        mimeTypesMap.put("application/x-magic-cap-package-1.0", List.of("mc$"));
        mimeTypesMap.put("application/x-mathcad", List.of("mcd"));
        mimeTypesMap.put("application/x-meme", List.of("mm"));
        mimeTypesMap.put("application/x-mif", List.of("mif"));
        mimeTypesMap.put("application/x-mix-transfer", List.of("nix"));
        mimeTypesMap.put("application/x-mobipocket-ebook", List.of("mobi", "prc"));
        mimeTypesMap.put("application/x-ms-application", List.of("application"));
        mimeTypesMap.put("application/x-ms-wmd", List.of("wmd"));
        mimeTypesMap.put("application/x-ms-wmz", List.of("wmz"));
        mimeTypesMap.put("application/x-ms-xbap", List.of("xbap"));
        mimeTypesMap.put("application/x-msaccess", List.of("mdb"));
        mimeTypesMap.put("application/x-msbinder", List.of("obd"));
        mimeTypesMap.put("application/x-mscardfile", List.of("crd"));
        mimeTypesMap.put("application/x-msclip", List.of("clp"));
        mimeTypesMap.put("application/x-msdownload", List.of("dll", "exe"));
        mimeTypesMap.put("application/x-msexcel", List.of("xla", "xls", "xlw"));
        mimeTypesMap.put("application/x-msmediaview", List.of("mvb", "m13", "m14"));
        mimeTypesMap.put("application/x-msmetafile", List.of("wmf"));
        mimeTypesMap.put("application/x-msmoney", List.of("mny"));
        mimeTypesMap.put("application/x-mspowerpoint", List.of("ppt"));
        mimeTypesMap.put("application/x-mspublisher", List.of("pub"));
        mimeTypesMap.put("application/x-msschedule", List.of("scd"));
        mimeTypesMap.put("application/x-msterminal", List.of("trm"));
        mimeTypesMap.put("application/x-mswrite", List.of("wri"));
        mimeTypesMap.put("application/x-navi-animation", List.of("ani"));
        mimeTypesMap.put("application/x-navidoc", List.of("nvd"));
        mimeTypesMap.put("application/x-navimap", List.of("map"));
        mimeTypesMap.put("application/x-navistyle", List.of("stl"));
        mimeTypesMap.put("application/x-netcdf", List.of("cdf", "nc"));
        mimeTypesMap.put("application/x-newton-compatible-pkg", List.of("pkg"));
        mimeTypesMap.put("application/x-nokia-9000-communicator-add-on-software", List.of("aos"));
        mimeTypesMap.put("application/x-omc", List.of("omc"));
        mimeTypesMap.put("application/x-omcdatamaker", List.of("omcd"));
        mimeTypesMap.put("application/x-omcregerator", List.of("omcr"));
        mimeTypesMap.put("application/x-pagemaker", List.of("pm4", "pm5"));
        mimeTypesMap.put("application/x-pcl", List.of("pcl"));
        mimeTypesMap.put("application/x-perfmon", List.of("pma", "pmc", "pml", "pmr", "pmw"));
        mimeTypesMap.put("application/x-pixclscript", List.of("plx"));
        mimeTypesMap.put("application/x-pkcs10", List.of("p10"));
        mimeTypesMap.put("application/x-pkcs12", List.of("p12", "pfx"));
        mimeTypesMap.put("application/x-pkcs7-certificates", List.of("p7b", "spc"));
        mimeTypesMap.put("application/x-pkcs7-certreqresp", List.of("p7r"));
        mimeTypesMap.put("application/x-pkcs7-mime", List.of("p7m", "p7c"));
        mimeTypesMap.put("application/x-pkcs7-signature", List.of("p7s"));
        mimeTypesMap.put("application/x-project", List.of("mpc", "mpt", "mpv", "mpx"));
        mimeTypesMap.put("application/x-python-code", List.of("pyc", "pyo"));
        mimeTypesMap.put("application/x-qpro", List.of("wb1"));
        mimeTypesMap.put("application/x-rar-compressed", List.of("rar"));
        mimeTypesMap.put("application/x-rpm", List.of("rpm"));
        mimeTypesMap.put("application/x-sdp", List.of("sdp"));
        mimeTypesMap.put("application/x-sea", List.of("sea"));
        mimeTypesMap.put("application/x-seelogo", List.of("sl"));
        mimeTypesMap.put("application/x-sh", List.of("sh"));
        mimeTypesMap.put("application/x-shar", List.of("shar"));
        mimeTypesMap.put("application/x-shockwave-flash", List.of("swf"));
        mimeTypesMap.put("application/x-silverlight-app", List.of("xap"));
        mimeTypesMap.put("application/x-sprite", List.of("spr", "sprite"));
        mimeTypesMap.put("application/x-stuffit", List.of("sit"));
        mimeTypesMap.put("application/x-stuffitx", List.of("sitx"));
        mimeTypesMap.put("application/x-sv4cpio", List.of("sv4cpio"));
        mimeTypesMap.put("application/x-sv4crc", List.of("sv4crc"));
        mimeTypesMap.put("application/x-tar", List.of("tar"));
        mimeTypesMap.put("application/x-tbook", List.of("sbk", "tbk"));
        mimeTypesMap.put("application/x-tcl", List.of("tcl"));
        mimeTypesMap.put("application/x-tex", List.of("tex"));
        mimeTypesMap.put("application/x-tex-tfm", List.of("tfm"));
        mimeTypesMap.put("application/x-texinfo", List.of("texinfo", "texi"));
        mimeTypesMap.put("application/x-troff", List.of("roff", "t", "tr"));
        mimeTypesMap.put("application/x-troff-man", List.of("man"));
        mimeTypesMap.put("application/x-troff-me", List.of("me"));
        mimeTypesMap.put("application/x-troff-ms", List.of("ms"));
        mimeTypesMap.put("application/x-ustar", List.of("ustar"));
        mimeTypesMap.put("application/x-visio", List.of("vsd", "vsw", "vst"));
        mimeTypesMap.put("application/x-vnd.audioexplosion.mzz", List.of("mzz"));
        mimeTypesMap.put("application/x-vnd.ls-xpix", List.of("xpix"));
        mimeTypesMap.put("application/x-wais-source", List.of("src"));
        mimeTypesMap.put("application/x-winhelp", List.of("hlp"));
        mimeTypesMap.put("application/x-wintalk", List.of("wtk"));
        mimeTypesMap.put("application/x-wpwin", List.of("wpd"));
        mimeTypesMap.put("application/x-wri", List.of("wri"));
        mimeTypesMap.put("application/x-x509-ca-cert", List.of("crt", "cer", "der"));
        mimeTypesMap.put("application/x-x509-user-cert", List.of("crt"));
        mimeTypesMap.put("application/x-xfig", List.of("fig"));
        mimeTypesMap.put("application/x-xpinstall", List.of("xpi"));
        mimeTypesMap.put("application/xcap-diff+xml", List.of("xdf"));
        mimeTypesMap.put("application/xenc+xml", List.of("xenc"));
        mimeTypesMap.put("application/xhtml+xml", List.of("xhtml"));
        mimeTypesMap.put(CONTENT_TYPE_APPLICATION_XML, List.of("xml"));
        mimeTypesMap.put("application/xml-dtd", List.of("dtd"));
        mimeTypesMap.put("application/xop+xml", List.of("xop"));
        mimeTypesMap.put("application/xslt+xml", List.of("xslt"));
        mimeTypesMap.put("application/xspf+xml", List.of("xspf"));
        mimeTypesMap.put("application/xv+xml", List.of("mxml", "xhvml", "xvm", "xvml"));
        mimeTypesMap.put("application/yang", List.of("yang"));
        mimeTypesMap.put("application/yin+xml", List.of("yin"));
        mimeTypesMap.put("application/ynd.ms-pkipko", List.of("pko"));
        mimeTypesMap.put("application/zip", List.of("zip"));
        mimeTypesMap.put("audio/adpcm", List.of("adp"));
        mimeTypesMap.put("audio/basic", List.of("au", "snd"));
        mimeTypesMap.put("audio/it", List.of("it"));
        mimeTypesMap.put("audio/make", List.of("funk", "my"));
        mimeTypesMap.put("audio/make.my.funk", List.of("pfunk"));
        mimeTypesMap.put("audio/mid", List.of("mid", "rmi"));
        mimeTypesMap.put("audio/midi", List.of("kar", "rmi", "mid", "midi"));
        mimeTypesMap.put("audio/mp4", List.of("mp4a"));
        mimeTypesMap.put("audio/mpeg", List.of("mp3", "mpga"));
        mimeTypesMap.put("audio/ogg", List.of("oga", "ogg", "spx"));
        mimeTypesMap.put("audio/s3m", List.of("s3m"));
        mimeTypesMap.put("audio/tsp-audio", List.of("tsi"));
        mimeTypesMap.put("audio/tsplayer", List.of("tsp"));
        mimeTypesMap.put("audio/vnd.dece.audio", List.of("uva"));
        mimeTypesMap.put("audio/vnd.digital-winds", List.of("eol"));
        mimeTypesMap.put("audio/vnd.dra", List.of("dra"));
        mimeTypesMap.put("audio/vnd.dts", List.of("dts"));
        mimeTypesMap.put("audio/vnd.dts.hd", List.of("dtshd"));
        mimeTypesMap.put("audio/vnd.lucent.voice", List.of("lvp"));
        mimeTypesMap.put("audio/vnd.ms-playready.media.pya", List.of("pya"));
        mimeTypesMap.put("audio/vnd.nuera.ecelp4800", List.of("ecelp4800"));
        mimeTypesMap.put("audio/vnd.nuera.ecelp7470", List.of("ecelp7470"));
        mimeTypesMap.put("audio/vnd.nuera.ecelp9600", List.of("ecelp9600"));
        mimeTypesMap.put("audio/vnd.qcelp", List.of("qcp"));
        mimeTypesMap.put("audio/vnd.rip", List.of("rip"));
        mimeTypesMap.put("audio/voxware", List.of("vox"));
        mimeTypesMap.put("audio/webm", List.of("weba"));
        mimeTypesMap.put("audio/x-aac", List.of("aac"));
        mimeTypesMap.put("audio/x-adpcm", List.of("snd"));
        mimeTypesMap.put("audio/x-aiff", List.of("aif", "aifc", "aiff"));
        mimeTypesMap.put("audio/x-au", List.of("au"));
        mimeTypesMap.put("audio/x-gsm", List.of("gsd", "gsm"));
        mimeTypesMap.put("audio/x-jam", List.of("jam"));
        mimeTypesMap.put("audio/x-liveaudio", List.of("lam"));
        mimeTypesMap.put("audio/x-mod", List.of("mod"));
        mimeTypesMap.put("audio/x-mpegurl", List.of("m3u"));
        mimeTypesMap.put("audio/x-mpequrl", List.of("m3u"));
        mimeTypesMap.put("audio/x-ms-wax", List.of("wax"));
        mimeTypesMap.put("audio/x-ms-wma", List.of("wma"));
        mimeTypesMap.put("audio/x-nspaudio", List.of("lma", "la"));
        mimeTypesMap.put("audio/x-pn-realaudio", List.of("ra", "ram"));
        mimeTypesMap.put("audio/x-pn-realaudio-plugin", List.of("rpm", "rmp"));
        mimeTypesMap.put("audio/x-psid", List.of("sid"));
        mimeTypesMap.put("audio/x-realaudio", List.of("ra"));
        mimeTypesMap.put("audio/x-twinvq", List.of("vqf"));
        mimeTypesMap.put("audio/x-twinvq-plugin", List.of("vqe", "vql"));
        mimeTypesMap.put("audio/x-vnd.audioexplosion.mjuicemediafile", List.of("mjf"));
        mimeTypesMap.put("audio/x-voc", List.of("voc"));
        mimeTypesMap.put("audio/x-wav", List.of("wav"));
        mimeTypesMap.put("audio/xm", List.of("xm"));
        mimeTypesMap.put("chemical/x-cdx", List.of("cdx"));
        mimeTypesMap.put("chemical/x-cif", List.of("cif"));
        mimeTypesMap.put("chemical/x-cmdf", List.of("cmdf"));
        mimeTypesMap.put("chemical/x-cml", List.of("cml"));
        mimeTypesMap.put("chemical/x-csml", List.of("csml"));
        mimeTypesMap.put("chemical/x-pdb", List.of("pdb", "xyz"));
        mimeTypesMap.put("chemical/x-xyz", List.of("xyz"));
        mimeTypesMap.put("i-world/i-vrml", List.of("ivr"));
        mimeTypesMap.put("image/bmp", List.of("bmp"));
        mimeTypesMap.put("image/cgm", List.of("cgm"));
        mimeTypesMap.put("image/cis-cod", List.of("cod"));
        mimeTypesMap.put("image/cmu-raster", List.of("rast"));
        mimeTypesMap.put("image/fif", List.of("fif"));
        mimeTypesMap.put("image/florian", List.of("flo", "turbot"));
        mimeTypesMap.put("image/g3fax", List.of("g3"));
        mimeTypesMap.put("image/gif", List.of("gif"));
        mimeTypesMap.put("image/ief", List.of("ief"));
        mimeTypesMap.put("image/jpeg", List.of("jpeg", "jpe", "jpg"));
        mimeTypesMap.put("image/jutvision", List.of("jut"));
        mimeTypesMap.put("image/ktx", List.of("ktx"));
        mimeTypesMap.put("image/naplps", List.of("nap", "naplps"));
        mimeTypesMap.put("image/pict", List.of("pic", "pict"));
        mimeTypesMap.put("image/pipeg", List.of("jfif"));
        mimeTypesMap.put("image/pjpeg", List.of("jpg", "jpe", "jpeg", "jfif", "pjpeg"));
        mimeTypesMap.put("image/png", List.of("png", "x-png"));
        mimeTypesMap.put("image/prs.btif", List.of("btif"));
        mimeTypesMap.put("image/svg+xml", List.of("svg"));
        mimeTypesMap.put("image/tiff", List.of("tif", "tiff"));
        mimeTypesMap.put("image/vnd.adobe.photoshop", List.of("psd"));
        mimeTypesMap.put("image/vnd.dece.graphic", List.of("uvi"));
        mimeTypesMap.put("image/vnd.djvu", List.of("djv", "djvu"));
        mimeTypesMap.put("image/vnd.dvb.subtitle", List.of("sub"));
        mimeTypesMap.put("image/vnd.dwg", List.of("dwg"));
        mimeTypesMap.put("image/vnd.dxf", List.of("dxf"));
        mimeTypesMap.put("image/vnd.fastbidsheet", List.of("fbs"));
        mimeTypesMap.put("image/vnd.fpx", List.of("fpx"));
        mimeTypesMap.put("image/vnd.fst", List.of("fst"));
        mimeTypesMap.put("image/vnd.fujixerox.edmics-mmr", List.of("mmr"));
        mimeTypesMap.put("image/vnd.fujixerox.edmics-rlc", List.of("rlc"));
        mimeTypesMap.put("image/vnd.ms-modi", List.of("mdi"));
        mimeTypesMap.put("image/vnd.net-fpx", List.of("fpx", "npx"));
        mimeTypesMap.put("image/vnd.rn-realflash", List.of("rf"));
        mimeTypesMap.put("image/vnd.rn-realpix", List.of("rp"));
        mimeTypesMap.put("image/vnd.wap.wbmp", List.of("wbmp"));
        mimeTypesMap.put("image/vnd.xiff", List.of("xif"));
        mimeTypesMap.put("image/webp", List.of("webp"));
        mimeTypesMap.put("image/x-citrix-jpeg", List.of("jpeg", "jpg"));
        mimeTypesMap.put("image/x-citrix-png", List.of("png"));
        mimeTypesMap.put("image/x-cmu-raster", List.of("ras"));
        mimeTypesMap.put("image/x-cmx", List.of("cmx"));
        mimeTypesMap.put("image/x-dwg", List.of("dwg", "dxf", "svf"));
        mimeTypesMap.put("image/x-freehand", List.of("fh", "fhc", "fh4", "fh5", "fh7"));
        mimeTypesMap.put("image/x-icon", List.of("ico"));
        mimeTypesMap.put("image/x-jg", List.of("art"));
        mimeTypesMap.put("image/x-jps", List.of("jps"));
        mimeTypesMap.put("image/x-niff", List.of("nif", "niff"));
        mimeTypesMap.put("image/x-pcx", List.of("pcx"));
        mimeTypesMap.put("image/x-pict", List.of("pct", "pic"));
        mimeTypesMap.put("image/x-png", List.of("png"));
        mimeTypesMap.put("image/x-portable-anymap", List.of("pnm"));
        mimeTypesMap.put("image/x-portable-bitmap", List.of("pbm"));
        mimeTypesMap.put("image/x-portable-graymap", List.of("pgm"));
        mimeTypesMap.put("image/x-portable-greymap", List.of("pgm"));
        mimeTypesMap.put("image/x-portable-pixmap", List.of("ppm"));
        mimeTypesMap.put("image/x-quicktime", List.of("qti", "qif", "qtif"));
        mimeTypesMap.put("image/x-rgb", List.of("rgb"));
        mimeTypesMap.put("image/x-tiff", List.of("tif", "tiff"));
        mimeTypesMap.put("image/x-windows-bmp", List.of("bmp"));
        mimeTypesMap.put("image/x-xbitmap", List.of("xbm"));
        mimeTypesMap.put("image/x-xpixmap", List.of("xpm"));
        mimeTypesMap.put("image/x-xwindowdump", List.of("xwd"));
        mimeTypesMap.put("image/xbm", List.of("xbm"));
        mimeTypesMap.put("image/xpm", List.of("xpm"));
        mimeTypesMap.put(CONTENT_TYPE_MESSAGE_RFC822, List.of("eml", "mht", "mhtml"));
        mimeTypesMap.put("model/iges", List.of("iges", "igs"));
        mimeTypesMap.put("model/mesh", List.of("mesh", "silo", "msh"));
        mimeTypesMap.put("model/vnd.collada+xml", List.of("dae"));
        mimeTypesMap.put("model/vnd.dwf", List.of("dwf"));
        mimeTypesMap.put("model/vnd.gdl", List.of("gdl"));
        mimeTypesMap.put("model/vnd.gtw", List.of("gtw"));
        mimeTypesMap.put("model/vnd.mts", List.of("mts"));
        mimeTypesMap.put("model/vnd.vtu", List.of("vtu"));
        mimeTypesMap.put("model/vrml", List.of("vrml", "wrl"));
        mimeTypesMap.put("model/x-pov", List.of("pov"));
        mimeTypesMap.put("multipart/x-gzip", List.of("gzip"));
        mimeTypesMap.put("multipart/x-ustar", List.of("ustar"));
        mimeTypesMap.put("multipart/x-zip", List.of("zip"));
        mimeTypesMap.put("music/x-karaoke", List.of("kar"));
        mimeTypesMap.put("paleovu/x-pv", List.of("pvu"));
        mimeTypesMap.put("text/asp", List.of("asp"));
        mimeTypesMap.put("text/calendar", List.of("ics", "ifb"));
        mimeTypesMap.put("text/css", List.of("css"));
        mimeTypesMap.put("text/csv", List.of("csv"));
        mimeTypesMap.put("text/ecmascript", List.of("js"));
        mimeTypesMap.put("text/h323", List.of("323"));
        mimeTypesMap.put(CONTENT_TYPE_TEXT_HTML, List.of("html", "htm", "stm"));
        mimeTypesMap.put("text/iuls", List.of("uls"));
        mimeTypesMap.put("text/mcf", List.of("mcf"));
        mimeTypesMap.put("text/n3", List.of("n3"));
        mimeTypesMap.put("text/pascal", List.of("pas"));
        mimeTypesMap.put(CONTENT_TYPE_TEXT_PLAIN, List.of("txt", "h", "c", "bas"));
        mimeTypesMap.put("text/plain-bas", List.of("par"));
        mimeTypesMap.put("text/prs.lines.tag", List.of("dsc"));
        mimeTypesMap.put("text/richtext", List.of("rtx"));
        mimeTypesMap.put("text/scriplet", List.of("wsc"));
        mimeTypesMap.put("text/scriptlet", List.of("sct"));
        mimeTypesMap.put("text/sgml", List.of("sgm", "sgml"));
        mimeTypesMap.put("text/tab-separated-values", List.of("tsv"));
        mimeTypesMap.put("text/troff", List.of("man", "tr", "me", "ms", "roff", "t"));
        mimeTypesMap.put("text/turtle", List.of("ttl"));
        mimeTypesMap.put("text/uri-list", List.of("uni", "unis", "uris", "uri"));
        mimeTypesMap.put("text/vnd.abc", List.of("abc"));
        mimeTypesMap.put("text/vnd.curl", List.of("curl"));
        mimeTypesMap.put("text/vnd.curl.dcurl", List.of("dcurl"));
        mimeTypesMap.put("text/vnd.curl.mcurl", List.of("mcurl"));
        mimeTypesMap.put("text/vnd.curl.scurl", List.of("scurl"));
        mimeTypesMap.put("text/vnd.fly", List.of("fly"));
        mimeTypesMap.put("text/vnd.fmi.flexstor", List.of("flx"));
        mimeTypesMap.put("text/vnd.graphviz", List.of("gv"));
        mimeTypesMap.put("text/vnd.in3d.3dml", List.of("3dml"));
        mimeTypesMap.put("text/vnd.in3d.spot", List.of("spot"));
        mimeTypesMap.put("text/vnd.rn-realtext", List.of("rt"));
        mimeTypesMap.put("text/vnd.sun.j2me.app-descriptor", List.of("jad"));
        mimeTypesMap.put("text/vnd.wap.si", List.of("si"));
        mimeTypesMap.put("text/vnd.wap.sl", List.of("sl"));
        mimeTypesMap.put("text/vnd.wap.wml", List.of("wml"));
        mimeTypesMap.put("text/vnd.wap.wmlscript", List.of("wmls"));
        mimeTypesMap.put("text/webviewhtml", List.of("htt"));
        mimeTypesMap.put("text/x-asm", List.of("asm", "s"));
        mimeTypesMap.put("text/x-audiosoft-intra", List.of("aip"));
        mimeTypesMap.put("text/x-c", List.of("c", "cpp", "cc"));
        mimeTypesMap.put("text/x-component", List.of("htc"));
        mimeTypesMap.put("text/x-fortran", List.of("f77", "f90", "f", "for"));
        mimeTypesMap.put("text/x-h", List.of("h", "hh"));
        mimeTypesMap.put("text/x-java-source", List.of("java", "jav"));
        mimeTypesMap.put("text/x-java-source,java", List.of("java"));
        mimeTypesMap.put("text/x-la-asf", List.of("lsx"));
        mimeTypesMap.put("text/x-m", List.of("m"));
        mimeTypesMap.put("text/x-pascal", List.of("p"));
        mimeTypesMap.put("text/x-python", List.of("py"));
        mimeTypesMap.put("text/x-script", List.of("hlb"));
        mimeTypesMap.put("text/x-script.csh", List.of("csh"));
        mimeTypesMap.put("text/x-script.elisp", List.of("el"));
        mimeTypesMap.put("text/x-script.ksh", List.of("ksh"));
        mimeTypesMap.put("text/x-script.lisp", List.of("lsp"));
        mimeTypesMap.put("text/x-script.perl", List.of("pl"));
        mimeTypesMap.put("text/x-script.perl-module", List.of("pm"));
        mimeTypesMap.put("text/x-script.phyton", List.of("py"));
        mimeTypesMap.put("text/x-script.rexx", List.of("rexx"));
        mimeTypesMap.put("text/x-script.sh", List.of("sh"));
        mimeTypesMap.put("text/x-script.tcl", List.of("tcl"));
        mimeTypesMap.put("text/x-script.tcsh", List.of("tcsh"));
        mimeTypesMap.put("text/x-script.zsh", List.of("zsh"));
        mimeTypesMap.put("text/x-server-parsed-html", List.of("shtml", "ssi"));
        mimeTypesMap.put("text/x-setext", List.of("etx"));
        mimeTypesMap.put("text/x-sgml", List.of("sgm", "sgml"));
        mimeTypesMap.put("text/x-speech", List.of("spc", "talk"));
        mimeTypesMap.put("text/x-uil", List.of("uil"));
        mimeTypesMap.put("text/x-uuencode", List.of("uu", "uue"));
        mimeTypesMap.put("text/x-vcalendar", List.of("vcs"));
        mimeTypesMap.put("text/x-vcard", List.of("vcf"));
        mimeTypesMap.put("text/xml", List.of("xml"));
        mimeTypesMap.put("text/yaml", List.of("yaml", "yml"));
        mimeTypesMap.put("video/3gpp", List.of("3gp"));
        mimeTypesMap.put("video/3gpp2", List.of("3g2"));
        mimeTypesMap.put("video/animaflex", List.of("afl"));
        mimeTypesMap.put("video/avs-video", List.of("avs"));
        mimeTypesMap.put("video/h261", List.of("h261"));
        mimeTypesMap.put("video/h263", List.of("h263"));
        mimeTypesMap.put("video/h264", List.of("h264"));
        mimeTypesMap.put("video/jpeg", List.of("jpgv"));
        mimeTypesMap.put("video/jpm", List.of("jpgm", "jpm"));
        mimeTypesMap.put("video/mj2", List.of("mj2", "mjp2"));
        mimeTypesMap.put("video/mp4", List.of("mp4"));
        mimeTypesMap.put("video/mpeg", List.of("mpeg", "mp2", "mpa", "mpe", "mpg", "mpv2"));
        mimeTypesMap.put("video/ogg", List.of("ogv"));
        mimeTypesMap.put("video/quicktime", List.of("mov", "qt"));
        mimeTypesMap.put("video/vdo", List.of("vdo"));
        mimeTypesMap.put("video/vnd.dece.hd", List.of("uvh"));
        mimeTypesMap.put("video/vnd.dece.mobile", List.of("uvm"));
        mimeTypesMap.put("video/vnd.dece.pd", List.of("uvp"));
        mimeTypesMap.put("video/vnd.dece.sd", List.of("uvs"));
        mimeTypesMap.put("video/vnd.dece.video", List.of("uvv"));
        mimeTypesMap.put("video/vnd.fvt", List.of("fvt"));
        mimeTypesMap.put("video/vnd.mpegurl", List.of("m4u", "mxu"));
        mimeTypesMap.put("video/vnd.ms-playready.media.pyv", List.of("pyv"));
        mimeTypesMap.put("video/vnd.rn-realvideo", List.of("rv"));
        mimeTypesMap.put("video/vnd.uvvu.mp4", List.of("uvu"));
        mimeTypesMap.put("video/vnd.vivo", List.of("viv", "vivo"));
        mimeTypesMap.put("video/vosaic", List.of("vos"));
        mimeTypesMap.put("video/webm", List.of("webm"));
        mimeTypesMap.put("video/x-amt-demorun", List.of("xdr"));
        mimeTypesMap.put("video/x-amt-showrun", List.of("xsr"));
        mimeTypesMap.put("video/x-atomic3d-feature", List.of("fmf"));
        mimeTypesMap.put("video/x-dl", List.of("dl"));
        mimeTypesMap.put("video/x-dv", List.of("dif", "dv"));
        mimeTypesMap.put("video/x-f4v", List.of("f4v"));
        mimeTypesMap.put("video/x-fli", List.of("fli"));
        mimeTypesMap.put("video/x-flv", List.of("flv"));
        mimeTypesMap.put("video/x-gl", List.of("gl"));
        mimeTypesMap.put("video/x-isvideo", List.of("isu"));
        mimeTypesMap.put("video/x-la-asf", List.of("lsf", "lsx"));
        mimeTypesMap.put("video/x-m4v", List.of("m4v"));
        mimeTypesMap.put("video/x-motion-jpeg", List.of("mjpg"));
        mimeTypesMap.put("video/x-mpeg", List.of("mp3"));
        mimeTypesMap.put("video/x-mpeq2a", List.of("mp2"));
        mimeTypesMap.put("video/x-ms-asf", List.of("asf", "asr", "asx"));
        mimeTypesMap.put("video/x-ms-asf-plugin", List.of("asx"));
        mimeTypesMap.put("video/x-ms-wm", List.of("wm"));
        mimeTypesMap.put("video/x-ms-wmv", List.of("wmv"));
        mimeTypesMap.put("video/x-ms-wmx", List.of("wmx"));
        mimeTypesMap.put("video/x-ms-wvx", List.of("wvx"));
        mimeTypesMap.put("video/x-msvideo", List.of("avi"));
        mimeTypesMap.put("video/x-qtc", List.of("qtc"));
        mimeTypesMap.put("video/x-scm", List.of("scm"));
        mimeTypesMap.put("video/x-sgi-movie", List.of("movie"));
        mimeTypesMap.put("windows/metafile", List.of("wmf"));
        mimeTypesMap.put("www/mime", List.of("mime"));
        mimeTypesMap.put("x-conference/x-cooltalk", List.of("ice"));
        mimeTypesMap.put("x-music/x-midi", List.of("mid", "midi"));
        mimeTypesMap.put("x-world/x-3dmf", List.of("3dmf", "3dm", "qd3d", "qd3"));
        mimeTypesMap.put("x-world/x-svr", List.of("svr"));
        mimeTypesMap.put("x-world/x-vrml", List.of("vrml", "flr", "wrl", "wrz", "xaf", "xof"));
        mimeTypesMap.put("x-world/x-vrt", List.of("vrt"));
        mimeTypesMap.put("xgl/drawing", List.of("xgz"));
        mimeTypesMap.put("xgl/movie", List.of("xmz"));
        mimeTypesMap.put("application/andrew-inset", List.of("ez"));
    }
}

