/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi;

import app.tozzi.core.DeliveryStatusHandler;
import app.tozzi.core.PECHandler;
import app.tozzi.model.Address;
import app.tozzi.model.Attachment;
import app.tozzi.model.DataSourcePair;
import app.tozzi.model.Header;
import app.tozzi.model.Mail;
import app.tozzi.model.PEC;
import app.tozzi.model.ParsedEntity;
import app.tozzi.model.exception.MailParserException;
import app.tozzi.util.IOUtils;
import app.tozzi.util.MimeMessageUtils;
import app.tozzi.util.UUEncodingUtils;
import jakarta.activation.DataSource;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public class MailParser {
    private Properties properties;
    private boolean extractAllHeaders;

    public static MailParser getInstance() {
        return new MailParser(null, false);
    }

    public static MailParser getInstance(Properties properties) {
        return new MailParser(properties, false);
    }

    public static MailParser getInstance(boolean extractAllHeaders) {
        return new MailParser(null, extractAllHeaders);
    }

    public static MailParser getInstance(Properties properties, boolean extractAllHeaders) {
        return new MailParser(properties, extractAllHeaders);
    }

    public ParsedEntity parse(MimeMessage mimeMessage) {
        String xTranspHeader = MimeMessageUtils.getHeader(mimeMessage, "X-Trasporto");
        String xReceiptHeader = MimeMessageUtils.getHeader(mimeMessage, "X-Ricevuta");
        ParsedEntity parsedEntity = MailParser.extract(mimeMessage, xTranspHeader != null, xReceiptHeader != null, this.properties, this.extractAllHeaders);
        if (xReceiptHeader != null) {
            return PECHandler.loadReceipt((PEC)parsedEntity);
        }
        return parsedEntity;
    }

    public ParsedEntity parse(File eml) {
        ParsedEntity parsedEntity;
        if (eml == null || !eml.exists()) {
            throw new MailParserException("Invalid file");
        }
        FileInputStream is = new FileInputStream(eml);
        try {
            parsedEntity = this.parse(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MailParserException("Error during parsing", e);
            }
        }
        ((InputStream)is).close();
        return parsedEntity;
    }

    public ParsedEntity parse(InputStream eml) {
        return this.parse(MimeMessageUtils.createMimeMessage(eml, this.properties));
    }

    private static ParsedEntity extract(MimeMessage mimeMessage, boolean isPEC, boolean isPECReceipt, Properties properties, boolean extractAllHeaders) {
        String[] referencesHeader;
        Mail mail = new Mail();
        mail.setMessageID(MimeMessageUtils.getMessageID(mimeMessage));
        List<jakarta.mail.Address> from = MimeMessageUtils.getFrom(mimeMessage);
        mail.setFrom(from.stream().filter(r -> r instanceof InternetAddress).map(r -> {
            InternetAddress ia = (InternetAddress)r;
            return Address.builder().email(ia.getAddress()).name(ia.getPersonal()).build();
        }).toList());
        List<jakarta.mail.Address> to = MimeMessageUtils.getTo(mimeMessage);
        mail.setTo(to.stream().filter(r -> r instanceof InternetAddress).map(r -> {
            InternetAddress ia = (InternetAddress)r;
            return Address.builder().email(ia.getAddress()).name(ia.getPersonal()).build();
        }).toList());
        List<jakarta.mail.Address> cc = MimeMessageUtils.getCC(mimeMessage);
        mail.setCc(cc.stream().filter(r -> r instanceof InternetAddress).map(r -> {
            InternetAddress ia = (InternetAddress)r;
            return Address.builder().email(ia.getAddress()).name(ia.getPersonal()).build();
        }).toList());
        List<jakarta.mail.Address> bcc = MimeMessageUtils.getBCC(mimeMessage);
        mail.setBcc(bcc.stream().filter(r -> r instanceof InternetAddress).map(r -> {
            InternetAddress ia = (InternetAddress)r;
            return Address.builder().email(ia.getAddress()).name(ia.getPersonal()).build();
        }).toList());
        mail.setSentDate(MimeMessageUtils.getSentDate(mimeMessage));
        mail.setReceivedDate(MimeMessageUtils.getReceivedDate(mimeMessage));
        mail.setSubject(MimeMessageUtils.getSubject(mimeMessage));
        String inReplyTO = MimeMessageUtils.getHeader(mimeMessage, "In-Reply-To");
        if (inReplyTO != null) {
            mail.setReplyToMessageID(inReplyTO.replaceAll("<", "").replaceAll(">", ""));
        }
        if ((referencesHeader = MimeMessageUtils.getHeaders(mimeMessage, "References")) != null) {
            mail.setReplyToHistoryMessagesID(Stream.of(Stream.of(referencesHeader).toList().get(0).split(" ")).map(r -> r.replaceAll("<", "").replaceAll(">", "")).toList());
        }
        if (extractAllHeaders) {
            mail.setHeaders(StreamSupport.stream(Spliterators.spliteratorUnknownSize(MimeMessageUtils.getAllHeaders(mimeMessage).asIterator(), 0), false).map(e -> Header.builder().key(e.getName()).value(e.getValue()).build()).toList());
        }
        return MailParser.extractContent(mail, mimeMessage, isPEC, isPECReceipt, properties, extractAllHeaders);
    }

    private static ParsedEntity extractContent(Mail mail, MimeMessage mimeMessage, boolean isPEC, boolean isPECReceipt, Properties properties, boolean extractAllHeaders) {
        DataSourcePair<DataSource, DataSource> dsp = isPEC || isPECReceipt ? new DataSourcePair<DataSource, DataSource>() : null;
        MailParser.extractContent(mail, (MimePart)mimeMessage, isPEC, isPECReceipt, dsp);
        if (isPEC || isPECReceipt) {
            if (isPEC && dsp.getElementA() == null) {
                throw new MailParserException("Invalid PEC");
            }
            try {
                MimeMessage postaCertMimeMessage = dsp.getElementA() != null ? MimeMessageUtils.createMimeMessage(dsp.getElementA().getInputStream(), properties) : null;
                return PECHandler.loadPEC(postaCertMimeMessage != null ? (Mail)MailParser.extract(postaCertMimeMessage, false, false, properties, extractAllHeaders) : null, mail, dsp.getElementA(), dsp.getElementB(), mimeMessage);
            }
            catch (IOException e) {
                throw new MailParserException(e);
            }
        }
        return mail;
    }

    private static void extractContent(Mail mail, MimePart part, boolean isPEC, boolean isPECReceipt, DataSourcePair<DataSource, DataSource> pecAttachments) {
        Object content = MimeMessageUtils.getContent((Part)part);
        if (MimeMessageUtils.isMimeType((Part)part, "text/plain") && !"attachment".equalsIgnoreCase(MimeMessageUtils.getDisposition((Part)part)) && mail.getBodyTXT() == null) {
            String body = content.toString();
            if (UUEncodingUtils.containsEncodedAttachments(body)) {
                body = body.substring(0, UUEncodingUtils.getNextBeginIndex(body));
                mail.getAttachments().addAll(UUEncodingUtils.decodeAttachments(body));
            }
            mail.setBodyTXT(body);
        } else if (MimeMessageUtils.isMimeType((Part)part, "text/html") && !"attachment".equalsIgnoreCase(MimeMessageUtils.getDisposition((Part)part))) {
            mail.setBodyHTML((String)(mail.getBodyHTML() != null ? mail.getBodyHTML() + content.toString() : content.toString()));
        } else if (MimeMessageUtils.isMimeType((Part)part, "multipart/*")) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < MimeMessageUtils.getCount(multipart); ++i) {
                MailParser.extractContent(mail, (MimePart)MimeMessageUtils.getBodyPart(multipart, i), isPEC, isPECReceipt, pecAttachments);
            }
        } else if (MimeMessageUtils.isMimeType((Part)part, "message/delivery-status")) {
            mail.setHasDeliveryStatus(true);
            mail.setDeliveryStatus(DeliveryStatusHandler.loadDeliveryStatus(part));
        } else {
            boolean pec = false;
            if ((isPEC || isPECReceipt) && !pecAttachments.isComplete()) {
                if (pecAttachments.getElementA() == null && ("postacert.eml".equalsIgnoreCase(MimeMessageUtils.decodeText(MimeMessageUtils.getFileName((Part)part))) || "postacert.eml".equals(MimeMessageUtils.getFileName((Part)part))) && MimeMessageUtils.isMimeType((Part)part, "message/rfc822")) {
                    pec = true;
                    try {
                        pecAttachments.setElementA(IOUtils.createDataSource(part));
                    }
                    catch (IOException e) {
                        throw new MailParserException("Error extracting PEC postaCert.eml attachment", e);
                    }
                }
                if (pecAttachments.getElementB() == null && ("daticert.xml".equalsIgnoreCase(MimeMessageUtils.decodeText(MimeMessageUtils.getFileName((Part)part))) || "daticert.xml".equals(MimeMessageUtils.getFileName((Part)part))) && MimeMessageUtils.isMimeType((Part)part, "application/xml")) {
                    pec = true;
                    try {
                        pecAttachments.setElementB(IOUtils.createDataSource(part));
                    }
                    catch (IOException e) {
                        throw new MailParserException("Error extracting PEC datiCert.xml attachment", e);
                    }
                }
            }
            if (!pec) {
                DataSource dataSource;
                try {
                    dataSource = IOUtils.createDataSource(part);
                }
                catch (IOException e) {
                    throw new MailParserException("Error extracting attachment", e);
                }
                mail.getAttachments().add(Attachment.builder().name(dataSource.getName()).dataSource(dataSource).contentID(MimeMessageUtils.getHeaderValue("Content-ID", (Part)part)).xAttachmentID(MimeMessageUtils.getHeaderValue("X-Attachment-Id", (Part)part)).inline("inline".equals(MimeMessageUtils.getDisposition((Part)part))).build());
            }
        }
    }

    @Generated
    private MailParser(Properties properties, boolean extractAllHeaders) {
        this.properties = properties;
        this.extractAllHeaders = extractAllHeaders;
    }
}

