/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import app.tozzi.util.MimeMessageUtils;
import app.tozzi.util.MimeTypesUtil;
import jakarta.activation.DataSource;
import jakarta.activation.FileTypeMap;
import jakarta.mail.Part;
import jakarta.mail.internet.MimePart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IOUtils {
    public static DataSource createDataSource(MimePart part) throws IOException {
        return IOUtils.createDataSource(part, null);
    }

    public static DataSource createDataSource(InputStream inputStream, String name) throws IOException {
        byte[] content = IOUtils.getContent(inputStream);
        name = name == null ? "unknown_name" : name;
        ByteArrayDataSource result = new ByteArrayDataSource(content, IOUtils.getFileMimeType(name));
        result.setName(name);
        return result;
    }

    public static DataSource createDataSource(MimePart part, String name) throws IOException {
        DataSource dataSource = MimeMessageUtils.getDataHandler((Part)part).getDataSource();
        byte[] content = IOUtils.getContent(dataSource.getInputStream());
        String fileName = name != null ? name : IOUtils.loadNameForDataSource(part);
        ByteArrayDataSource result = new ByteArrayDataSource(content, IOUtils.getBaseMimeType(dataSource, fileName));
        result.setName(fileName);
        return result;
    }

    public static void fastCopy(InputStream src, OutputStream dest) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(src);
        WritableByteChannel outputChannel = Channels.newChannel(dest);
        IOUtils.fastCopy(inputChannel, outputChannel);
        inputChannel.close();
        outputChannel.close();
    }

    private static String loadNameForDataSource(MimePart part) {
        String fileName = MimeMessageUtils.getFileName((Part)part);
        return fileName != null && !fileName.trim().isEmpty() ? MimeMessageUtils.decodeText(fileName) : IOUtils.getName((Part)part);
    }

    static String getName(Part part) {
        String fileName = MimeMessageUtils.getFileName(part);
        if (fileName != null && !fileName.trim().isEmpty()) {
            return MimeMessageUtils.decodeText(fileName);
        }
        String extension = IOUtils.getExtension(part);
        String string = extension = extension != null && !extension.trim().isEmpty() ? "." + extension : "";
        if ("inline".equals(MimeMessageUtils.getDisposition(part))) {
            return "unknown_name_inline" + extension;
        }
        return "unknown_name" + extension;
    }

    private static String getExtension(Part part) {
        String fullMimeType = MimeMessageUtils.getContentType(part);
        if (fullMimeType != null && !fullMimeType.trim().isEmpty()) {
            return MimeTypesUtil.guessExtension(fullMimeType);
        }
        return null;
    }

    private static String getBaseMimeType(DataSource dataSource, String fileName) {
        String fullMimeType = dataSource.getContentType();
        if (fullMimeType == null || fullMimeType.trim().isEmpty()) {
            return IOUtils.getFileMimeType(fileName);
        }
        int pos = fullMimeType.indexOf(59);
        if (pos >= 0) {
            return fullMimeType.substring(0, pos);
        }
        return fullMimeType;
    }

    static byte[] getContent(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.fastCopy(is, os);
        byte[] result = os.toByteArray();
        return result;
    }

    private static void fastCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            ((Buffer)buffer).flip();
            dest.write(buffer);
            buffer.compact();
        }
        ((Buffer)buffer).flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    static String getFileMimeType(String fileName) {
        String fileExt;
        int dotPos = fileName.lastIndexOf(".");
        String result = dotPos < 0 ? "application/octet-stream" : ((fileExt = fileName.substring(dotPos + 1)).isEmpty() ? "application/octet-stream" : MimeTypesUtil.guessMimeType(fileExt));
        if ("application/octet-stream".equals(result)) {
            result = FileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
        }
        return result != null ? result : "application/octet-stream";
    }
}

