/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.core;

import app.tozzi.model.DeliveryStatus;
import app.tozzi.model.exception.MailParserException;
import jakarta.mail.internet.MimePart;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class DeliveryStatusHandler {
    public static DeliveryStatus loadDeliveryStatus(MimePart part) {
        DeliveryStatus deliveryStatus = new DeliveryStatus();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(part.getInputStream()));){
            String line = br.readLine();
            while (line != null) {
                if (line.toLowerCase().startsWith("action".toLowerCase() + ":")) {
                    deliveryStatus.setAction(DeliveryStatus.Action.from(line.substring("action".length() + 1).trim()));
                } else if (line.toLowerCase().startsWith("status".toLowerCase() + ":")) {
                    int prefix;
                    deliveryStatus.setStatus(line.substring("status".length() + 1).trim());
                    if (!deliveryStatus.getStatus().isEmpty() && (prefix = Character.getNumericValue(deliveryStatus.getStatus().charAt(0))) > 0) {
                        deliveryStatus.setStatusType(DeliveryStatus.StatusType.from(prefix));
                    }
                } else if (line.toLowerCase().startsWith("Diagnostic-Code".toLowerCase() + ":")) {
                    String diagnosticCode = line.substring("Diagnostic-Code".length() + 1).trim();
                    DeliveryStatus.DiagnosticCode dc = new DeliveryStatus.DiagnosticCode();
                    if (diagnosticCode.contains(";")) {
                        dc.setType(diagnosticCode.substring(0, diagnosticCode.indexOf(";")).trim());
                        dc.setDescription(diagnosticCode.substring(diagnosticCode.indexOf(";") + 1).trim());
                    } else {
                        dc.setDescription(diagnosticCode.trim());
                    }
                    deliveryStatus.setDiagnosticCode(dc);
                } else if (line.toLowerCase().startsWith("Remote-MTA".toLowerCase() + ":")) {
                    String deliveryRemoteMTA = line.substring("Remote-MTA".length() + 1).trim();
                    drm = new DeliveryStatus.RemoteMTA();
                    if (deliveryRemoteMTA.contains(";")) {
                        ((DeliveryStatus.RemoteMTA)drm).setType(deliveryRemoteMTA.substring(0, deliveryRemoteMTA.indexOf(";")).trim());
                        ((DeliveryStatus.RemoteMTA)drm).setAddress(deliveryRemoteMTA.substring(deliveryRemoteMTA.indexOf(";") + 1).trim());
                    }
                    deliveryStatus.setRemoteMTA((DeliveryStatus.RemoteMTA)drm);
                } else if (line.toLowerCase().startsWith("Reporting-MTA".toLowerCase() + ":")) {
                    String deliveryRemoteMTA = line.substring("Reporting-MTA".length() + 1).trim();
                    drm = new DeliveryStatus.ReportingMTA();
                    if (deliveryRemoteMTA.contains(";")) {
                        ((DeliveryStatus.ReportingMTA)drm).setType(deliveryRemoteMTA.substring(0, deliveryRemoteMTA.indexOf(";")).trim());
                        ((DeliveryStatus.ReportingMTA)drm).setAddress(deliveryRemoteMTA.substring(deliveryRemoteMTA.indexOf(";") + 1).trim());
                    }
                    deliveryStatus.setReportingMTA((DeliveryStatus.ReportingMTA)drm);
                } else if (line.toLowerCase().startsWith("Received-From-MTA".toLowerCase() + ":")) {
                    String deliveryRemoteMTA = line.substring("Received-From-MTA".length() + 1).trim();
                    drm = new DeliveryStatus.ReceivedFromMTA();
                    if (deliveryRemoteMTA.contains(";")) {
                        ((DeliveryStatus.ReceivedFromMTA)drm).setType(deliveryRemoteMTA.substring(0, deliveryRemoteMTA.indexOf(";")).trim());
                        ((DeliveryStatus.ReceivedFromMTA)drm).setName(deliveryRemoteMTA.substring(deliveryRemoteMTA.indexOf(";") + 1).trim());
                    }
                    deliveryStatus.setReceivedFromMTA((DeliveryStatus.ReceivedFromMTA)drm);
                } else if (line.toLowerCase().startsWith("Final-Recipient".toLowerCase() + ":")) {
                    String finalRecipient = line.substring("Final-Recipient".length() + 1).trim();
                    DeliveryStatus.FinalRecipient fr = new DeliveryStatus.FinalRecipient();
                    if (finalRecipient.contains(";")) {
                        fr.setType(finalRecipient.substring(0, finalRecipient.indexOf(";")).trim());
                        fr.setAddress(finalRecipient.substring(finalRecipient.indexOf(";") + 1).trim());
                    }
                    deliveryStatus.setFinalRecipient(fr);
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            throw new MailParserException(e);
        }
        return deliveryStatus;
    }
}

