/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.core;

import app.tozzi.model.CertificateData;
import app.tozzi.model.Mail;
import app.tozzi.model.PEC;
import app.tozzi.model.PECReceipt;
import app.tozzi.model.exception.MailParserException;
import app.tozzi.util.MimeMessageUtils;
import app.tozzi.util.XMLUtils;
import jakarta.activation.DataSource;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PECHandler {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public static PECReceipt loadReceipt(PEC pec) {
        try {
            PECReceipt pecReceipt = new PECReceipt();
            pecReceipt.setPec(pec);
            pecReceipt.setCertificateData(PECHandler.loadCertificateData(pec.getDatiCert().getInputStream()));
            return pecReceipt;
        }
        catch (Exception e) {
            throw new MailParserException("Error during PEC receipt processing", e);
        }
    }

    public static PEC loadPEC(Mail originalMessage, Mail envelope, DataSource postaCert, DataSource datiCert, MimeMessage mimeMessage) {
        try {
            PEC pec = new PEC();
            pec.setPostaCert(postaCert);
            pec.setDatiCert(datiCert);
            pec.setEnvelope(envelope);
            pec.setOriginalMessage(originalMessage);
            if (datiCert != null) {
                pec.setCertificateData(PECHandler.loadCertificateData(datiCert.getInputStream()));
            }
            pec.setTransportHeaderValue(MimeMessageUtils.getHeader(mimeMessage, "X-Trasporto"));
            pec.setReceiptHeaderValue(MimeMessageUtils.getHeader(mimeMessage, "X-Ricevuta"));
            pec.setReceiptTypeHeaderValue(MimeMessageUtils.getHeader(mimeMessage, "X-TipoRicevuta"));
            pec.setSecurityCheckHeaderValue(MimeMessageUtils.getHeader(mimeMessage, "X-VerificaSicurezza"));
            pec.setErrorHeaderValue(MimeMessageUtils.getHeader(mimeMessage, "errore"));
            pec.setReferenceHeaderValue(MimeMessageUtils.getHeader(mimeMessage, "X-Riferimento-Message-ID"));
            return pec;
        }
        catch (Exception e) {
            throw new MailParserException("Error during PEC processing", e);
        }
    }

    static CertificateData loadCertificateData(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        Document document = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().parse(inputStream);
        CertificateData certificateData = new CertificateData();
        Optional<String> sender = XMLUtils.getTextContent(document, "/postacert/intestazione/mittente");
        if (sender.isEmpty()) {
            throw new MailParserException("Path /postacert/intestazione/mittente must be not null");
        }
        certificateData.setSender(sender.get());
        Optional<String> answers = XMLUtils.getTextContent(document, "/postacert/intestazione/risposte");
        if (answers.isEmpty()) {
            throw new MailParserException("Path /postacert/intestazione/risposte must be not null");
        }
        certificateData.setAnswers(answers.get());
        Optional<String> issuer = XMLUtils.getTextContent(document, "/postacert/dati/gestore-emittente");
        if (issuer.isEmpty()) {
            throw new MailParserException("Path /postacert/dati/gestore-emittente must be not null");
        }
        certificateData.setIssuer(issuer.get());
        XMLUtils.getTextContent(document, "/postacert/intestazione/oggetto").ifPresent(certificateData::setSubject);
        Map<String, String> recipients = XMLUtils.getTextAndAttribute(document, "/postacert/intestazione/destinatari", "tipo");
        if (recipients.isEmpty()) {
            throw new MailParserException("Path and attribute /postacert/intestazione/destinatari;tipo must be not null");
        }
        certificateData.setRecipients(recipients.entrySet().stream().map(e -> CertificateData.PECRecipients.builder().address((String)e.getKey()).type(CertificateData.PECRecipients.PECRecipientType.from((String)e.getValue())).build()).toList());
        Optional<String> zone = XMLUtils.getAttribute(document, "/postacert/dati/data", "zona");
        if (zone.isEmpty()) {
            throw new MailParserException("Path and attribute /postacert/dati/data;zona must be not null");
        }
        certificateData.setDate(new CertificateData.PECDate());
        certificateData.getDate().setZone(zone.get());
        Optional<String> day = XMLUtils.getTextContent(document, "/postacert/dati/data/giorno");
        if (day.isEmpty()) {
            throw new MailParserException("Path /postacert/dati/data/giorno must be not null");
        }
        certificateData.getDate().setDay(day.get());
        Optional<String> hour = XMLUtils.getTextContent(document, "/postacert/dati/data/ora");
        if (hour.isEmpty()) {
            throw new MailParserException("Path /postacert/dati/data/ora must be not null");
        }
        certificateData.getDate().setHour(hour.get());
        XMLUtils.getAttribute(document, "/postacert/dati/ricevuta", "tipo").ifPresent(recType -> certificateData.setReceiptType(CertificateData.ReceiptType.from(recType)));
        Optional<String> error = XMLUtils.getAttribute(document, "/postacert", "errore");
        if (error.isEmpty()) {
            throw new MailParserException("Path and attribute /postacert;errore must be not null");
        }
        certificateData.setError(CertificateData.PECError.from(error.get()));
        XMLUtils.getTextContent(document, "/postacert/dati/errore-esteso").ifPresent(certificateData::setExtendedError);
        XMLUtils.getTextContent(document, "/postacert/dati/consegna").ifPresent(certificateData::setDelivery);
        XMLUtils.getTextContent(document, "/postacert/dati/ricezione").ifPresent(certificateData::setReceiving);
        XMLUtils.getTextContent(document, "/postacert/dati/msgid").ifPresent(certificateData::setMessageID);
        XMLUtils.getTextContent(document, "/postacert/dati/identificativo").ifPresent(certificateData::setId);
        Optional<String> type = XMLUtils.getAttribute(document, "/postacert", "tipo");
        if (type.isEmpty()) {
            throw new MailParserException("Path and attribute /postacert;tipo must be not null");
        }
        certificateData.setType(CertificateData.PostaCertType.from(type.get()));
        return certificateData;
    }
}

