/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static Optional<String> getAttribute(Document doc, String path, String attributeName) throws XPathExpressionException {
        return XMLUtils.getNodes(doc, path).stream().findFirst().flatMap(node -> {
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.item(i).getNodeName().equalsIgnoreCase(attributeName)) continue;
                return Optional.ofNullable(attributes.item(i).getNodeValue());
            }
            return Optional.empty();
        }).or(Optional::empty);
    }

    public static Map<String, String> getTextAndAttribute(Document document, String path, String attribute) throws XPathExpressionException {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Node> nodes = XMLUtils.getNodes(document, path);
        nodes.forEach(node -> {
            String value = node.getTextContent();
            String attr = null;
            NamedNodeMap attributes = node.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                if (!attributes.item(j).getNodeName().equalsIgnoreCase(attribute)) continue;
                attr = attributes.item(j).getNodeValue();
                break;
            }
            result.put(value, attr);
        });
        return result;
    }

    public static Optional<String> getTextContent(Document document, String path) throws XPathExpressionException {
        return XMLUtils.getNodes(document, path).stream().findFirst().map(Node::getTextContent).or(Optional::empty);
    }

    private static List<Node> getNodes(Document document, String path) throws XPathExpressionException {
        XPathExpression expr = XPathFactory.newInstance().newXPath().compile(path);
        NodeList nodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        return IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).toList();
    }
}

