/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.model;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public class CertificateData {
    private PostaCertType type;
    private String sender;
    private List<PECRecipients> recipients;
    private String messageID;
    private String id;
    private PECError error;
    private String answers;
    private String subject;
    private String issuer;
    private String delivery;
    private String receiving;
    private String extendedError;
    private PECDate date;
    private ReceiptType receiptType;

    @Generated
    public CertificateData() {
    }

    @Generated
    public PostaCertType getType() {
        return this.type;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public List<PECRecipients> getRecipients() {
        return this.recipients;
    }

    @Generated
    public String getMessageID() {
        return this.messageID;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public PECError getError() {
        return this.error;
    }

    @Generated
    public String getAnswers() {
        return this.answers;
    }

    @Generated
    public String getSubject() {
        return this.subject;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public String getDelivery() {
        return this.delivery;
    }

    @Generated
    public String getReceiving() {
        return this.receiving;
    }

    @Generated
    public String getExtendedError() {
        return this.extendedError;
    }

    @Generated
    public PECDate getDate() {
        return this.date;
    }

    @Generated
    public ReceiptType getReceiptType() {
        return this.receiptType;
    }

    @Generated
    public void setType(PostaCertType type) {
        this.type = type;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setRecipients(List<PECRecipients> recipients) {
        this.recipients = recipients;
    }

    @Generated
    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setError(PECError error) {
        this.error = error;
    }

    @Generated
    public void setAnswers(String answers) {
        this.answers = answers;
    }

    @Generated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Generated
    public void setReceiving(String receiving) {
        this.receiving = receiving;
    }

    @Generated
    public void setExtendedError(String extendedError) {
        this.extendedError = extendedError;
    }

    @Generated
    public void setDate(PECDate date) {
        this.date = date;
    }

    @Generated
    public void setReceiptType(ReceiptType receiptType) {
        this.receiptType = receiptType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertificateData)) {
            return false;
        }
        CertificateData other = (CertificateData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PostaCertType this$type = this.getType();
        PostaCertType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        List<PECRecipients> this$recipients = this.getRecipients();
        List<PECRecipients> other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients)) {
            return false;
        }
        String this$messageID = this.getMessageID();
        String other$messageID = other.getMessageID();
        if (this$messageID == null ? other$messageID != null : !this$messageID.equals(other$messageID)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PECError this$error = this.getError();
        PECError other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)((Object)this$error)).equals((Object)other$error)) {
            return false;
        }
        String this$answers = this.getAnswers();
        String other$answers = other.getAnswers();
        if (this$answers == null ? other$answers != null : !this$answers.equals(other$answers)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$delivery = this.getDelivery();
        String other$delivery = other.getDelivery();
        if (this$delivery == null ? other$delivery != null : !this$delivery.equals(other$delivery)) {
            return false;
        }
        String this$receiving = this.getReceiving();
        String other$receiving = other.getReceiving();
        if (this$receiving == null ? other$receiving != null : !this$receiving.equals(other$receiving)) {
            return false;
        }
        String this$extendedError = this.getExtendedError();
        String other$extendedError = other.getExtendedError();
        if (this$extendedError == null ? other$extendedError != null : !this$extendedError.equals(other$extendedError)) {
            return false;
        }
        PECDate this$date = this.getDate();
        PECDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        ReceiptType this$receiptType = this.getReceiptType();
        ReceiptType other$receiptType = other.getReceiptType();
        return !(this$receiptType == null ? other$receiptType != null : !((Object)((Object)this$receiptType)).equals((Object)other$receiptType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CertificateData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PostaCertType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        List<PECRecipients> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        String $messageID = this.getMessageID();
        result = result * 59 + ($messageID == null ? 43 : $messageID.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PECError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)((Object)$error)).hashCode());
        String $answers = this.getAnswers();
        result = result * 59 + ($answers == null ? 43 : $answers.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $delivery = this.getDelivery();
        result = result * 59 + ($delivery == null ? 43 : $delivery.hashCode());
        String $receiving = this.getReceiving();
        result = result * 59 + ($receiving == null ? 43 : $receiving.hashCode());
        String $extendedError = this.getExtendedError();
        result = result * 59 + ($extendedError == null ? 43 : $extendedError.hashCode());
        PECDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        ReceiptType $receiptType = this.getReceiptType();
        result = result * 59 + ($receiptType == null ? 43 : ((Object)((Object)$receiptType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CertificateData(type=" + String.valueOf((Object)this.getType()) + ", sender=" + this.getSender() + ", recipients=" + String.valueOf(this.getRecipients()) + ", messageID=" + this.getMessageID() + ", id=" + this.getId() + ", error=" + String.valueOf((Object)this.getError()) + ", answers=" + this.getAnswers() + ", subject=" + this.getSubject() + ", issuer=" + this.getIssuer() + ", delivery=" + this.getDelivery() + ", receiving=" + this.getReceiving() + ", extendedError=" + this.getExtendedError() + ", date=" + String.valueOf(this.getDate()) + ", receiptType=" + String.valueOf((Object)this.getReceiptType()) + ")";
    }

    public static enum PostaCertType {
        ACCETTAZIONE("accettazione"),
        NON_ACCETTAZIONE("non-accettazione"),
        PRESA_IN_CARICO("presa-in-carico"),
        AVVENUTA_CONSEGNA("avvenuta-consegna"),
        POSTA_CERTIFICATA("posta-certificata"),
        ERRORE("errore"),
        ERRORE_CONSEGNA("errore-consegna"),
        PREAVVISO_ERRORE_CONSEGNA("preavviso-errore-consegna"),
        RILEVAZIONE_VIRUS("rilevazione-virus");

        private final String description;

        public static PostaCertType from(String description) {
            return Stream.of(PostaCertType.values()).filter(t -> t.getDescription().equals(description)).findAny().orElse(null);
        }

        @Generated
        private PostaCertType(String description) {
            this.description = description;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }

    public static enum PECError {
        NESSUNO("nessuno"),
        NO_DEST("no-dest"),
        NO_DOMINIO("no-dominio"),
        VIRUS("virus"),
        ALTRO("altro");

        private final String description;

        public static PECError from(String description) {
            return Stream.of(PECError.values()).filter(t -> t.getDescription().equals(description)).findAny().orElse(null);
        }

        @Generated
        private PECError(String description) {
            this.description = description;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }

    public static class PECDate {
        private static final String PEC_DATE_PATTERN_1 = "dd/MM/yyyy HH:mm:ss";
        private static final String PEC_DATE_PATTERN_2 = "dd/MM/yyyy";
        private String zone;
        private String day;
        private String hour;

        public Date getDate() {
            if (this.day != null) {
                return Date.from(ZonedDateTime.parse(this.day + (String)(this.hour != null ? " " + this.hour : ""), DateTimeFormatter.ofPattern(this.hour != null ? PEC_DATE_PATTERN_1 : PEC_DATE_PATTERN_2).withZone(this.zone != null ? ZoneOffset.of(this.zone) : ZoneId.systemDefault())).toInstant());
            }
            return null;
        }

        @Generated
        public PECDate() {
        }

        @Generated
        public String getZone() {
            return this.zone;
        }

        @Generated
        public String getDay() {
            return this.day;
        }

        @Generated
        public String getHour() {
            return this.hour;
        }

        @Generated
        public void setZone(String zone) {
            this.zone = zone;
        }

        @Generated
        public void setDay(String day) {
            this.day = day;
        }

        @Generated
        public void setHour(String hour) {
            this.hour = hour;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PECDate)) {
                return false;
            }
            PECDate other = (PECDate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$zone = this.getZone();
            String other$zone = other.getZone();
            if (this$zone == null ? other$zone != null : !this$zone.equals(other$zone)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$hour = this.getHour();
            String other$hour = other.getHour();
            return !(this$hour == null ? other$hour != null : !this$hour.equals(other$hour));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PECDate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $zone = this.getZone();
            result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $hour = this.getHour();
            result = result * 59 + ($hour == null ? 43 : $hour.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CertificateData.PECDate(zone=" + this.getZone() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ")";
        }
    }

    public static enum ReceiptType {
        COMPLETA("completa"),
        BREVE("breve"),
        SINTETICA("sintetica");

        private final String description;

        public static ReceiptType from(String description) {
            return Stream.of(ReceiptType.values()).filter(t -> t.getDescription().equals(description)).findAny().orElse(null);
        }

        @Generated
        private ReceiptType(String description) {
            this.description = description;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }

    public static class PECRecipients {
        private String address;
        private PECRecipientType type;

        @Generated
        PECRecipients(String address, PECRecipientType type) {
            this.address = address;
            this.type = type;
        }

        @Generated
        public static PECRecipientsBuilder builder() {
            return new PECRecipientsBuilder();
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public PECRecipientType getType() {
            return this.type;
        }

        @Generated
        public void setAddress(String address) {
            this.address = address;
        }

        @Generated
        public void setType(PECRecipientType type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PECRecipients)) {
                return false;
            }
            PECRecipients other = (PECRecipients)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            PECRecipientType this$type = this.getType();
            PECRecipientType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PECRecipients;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            PECRecipientType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CertificateData.PECRecipients(address=" + this.getAddress() + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }

        public static enum PECRecipientType {
            ESTERNO("esterno"),
            CERTIFICATO("certificato");

            private final String description;

            public static PECRecipientType from(String description) {
                return Stream.of(PECRecipientType.values()).filter(t -> t.getDescription().equals(description)).findAny().orElse(null);
            }

            @Generated
            private PECRecipientType(String description) {
                this.description = description;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }
        }

        @Generated
        public static class PECRecipientsBuilder {
            @Generated
            private String address;
            @Generated
            private PECRecipientType type;

            @Generated
            PECRecipientsBuilder() {
            }

            @Generated
            public PECRecipientsBuilder address(String address) {
                this.address = address;
                return this;
            }

            @Generated
            public PECRecipientsBuilder type(PECRecipientType type) {
                this.type = type;
                return this;
            }

            @Generated
            public PECRecipients build() {
                return new PECRecipients(this.address, this.type);
            }

            @Generated
            public String toString() {
                return "CertificateData.PECRecipients.PECRecipientsBuilder(address=" + this.address + ", type=" + String.valueOf((Object)this.type) + ")";
            }
        }
    }
}

