/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.util;

import app.tozzi.model.Attachment;
import app.tozzi.model.exception.MailParserException;
import app.tozzi.util.IOUtils;
import app.tozzi.util.MimeMessageUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUEncodingUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UUEncodingUtils.class);

    public static boolean containsEncodedAttachments(String content) {
        if (content == null) {
            return false;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return false;
        }
        if (beginIndex > endIndex) {
            return UUEncodingUtils.containsEncodedAttachments(content.substring(beginIndex));
        }
        String subString = content.substring(beginIndex, endIndex + 3);
        if (!UUEncodingUtils.internalContainsEncodedAttachments(subString)) {
            return UUEncodingUtils.containsEncodedAttachments(content.substring(beginIndex + 6));
        }
        return true;
    }

    public static List<Attachment> decodeAttachments(String content) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        try {
            UUEncodingUtils.internalDecodeAttachments(content, result);
        }
        catch (IOException e) {
            throw new MailParserException(e);
        }
        return result;
    }

    public static int getNextBeginIndex(String content) {
        if (content == null) {
            return -1;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return -1;
        }
        if (beginIndex > endIndex) {
            return UUEncodingUtils.getNextBeginIndex(content.substring(endIndex + 3));
        }
        String subString = content.substring(beginIndex, endIndex + 3);
        if (UUEncodingUtils.internalContainsEncodedAttachments(subString)) {
            return beginIndex;
        }
        return UUEncodingUtils.getNextBeginIndex(content.substring(beginIndex + 6));
    }

    private static void internalDecodeAttachments(String content, List<Attachment> attachments) throws IOException {
        if (content == null) {
            return;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return;
        }
        if (beginIndex > endIndex) {
            UUEncodingUtils.internalDecodeAttachments(content.substring(beginIndex), attachments);
        } else {
            String subString = content.substring(beginIndex, endIndex + 3);
            if (UUEncodingUtils.internalContainsEncodedAttachments(subString)) {
                InputStream isDecoded = null;
                String fileName = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());){
                    fileName = UUEncodingUtils.getAttachmentName(subString, attachments);
                    isDecoded = MimeMessageUtils.decodeStream(is, "uuencode");
                    attachments.add(Attachment.builder().name(fileName).dataSource(IOUtils.createDataSource(isDecoded, fileName)).build());
                }
            }
            UUEncodingUtils.internalDecodeAttachments(content.substring(beginIndex + 6), attachments);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean internalContainsEncodedAttachments(String content) {
        try (BufferedReader reader = new BufferedReader(new StringReader(content));){
            int mode;
            String firstLine = reader.readLine();
            if (firstLine == null || !firstLine.regionMatches(false, 0, "begin ", 0, 6)) {
                boolean bl = false;
                return bl;
            }
            String lastLine = reader.lines().reduce((first, second) -> second).orElse(null);
            if (lastLine == null || !lastLine.regionMatches(false, 0, "end", 0, 3)) {
                boolean bl = false;
                return bl;
            }
            try {
                mode = Integer.parseInt(firstLine.substring(6, 9));
            }
            catch (NumberFormatException e) {
                log.warn("Permissions mode not valid", (Throwable)e);
                boolean bl = false;
                reader.close();
                return bl;
            }
            if (!UUEncodingUtils.isOctal(mode)) {
                log.warn("Permissions mode not in octal format");
                boolean e = false;
                return e;
            }
            String fileName = firstLine.substring(9);
            if (fileName.isBlank()) {
                log.warn("File name not present");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Error during uuencoded content check", (Throwable)e);
            throw new MailParserException(e);
        }
    }

    private static String getAttachmentName(String content, List<Attachment> attachments) {
        String string;
        BufferedReader reader = new BufferedReader(new StringReader(content));
        try {
            string = reader.readLine().substring(9).trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error during reading file name", (Throwable)e);
                return UUEncodingUtils.getVersionedFileName("unnamed", attachments.stream().map(Attachment::getName).toList(), 1);
            }
        }
        reader.close();
        return string;
    }

    private static String getVersionedFileName(String fileName, List<String> files, int i) {
        if (files.contains(fileName)) {
            fileName = (String)fileName + "(" + i + ")";
            return UUEncodingUtils.getVersionedFileName((String)fileName, files, i++);
        }
        return fileName;
    }

    private static boolean isOctal(int number) {
        boolean isOctal = false;
        while (number > 0) {
            if (number % 10 > 7) {
                isOctal = false;
                break;
            }
            isOctal = true;
            number /= 10;
        }
        return isOctal;
    }
}

