/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.uudecoder;

import app.tozzi.uudecoder.exception.UUDecoderException;
import app.tozzi.uudecoder.model.UUDecodedBean;
import jakarta.activation.DataSource;
import jakarta.activation.FileTypeMap;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUDecoder {
    private static final Logger log = LoggerFactory.getLogger(UUDecoder.class);
    private static final String CONTENT_TYPE_OCETSTREAM = "application/octet-stream";

    public static UUDecodedBean decode(String content) throws UUDecoderException {
        UUDecodedBean decodedBean = new UUDecodedBean();
        if (!UUDecoder.containsUUEncodedAttachments(content)) {
            log.info("UUEncoding not detected");
            decodedBean.setContent(content);
            return decodedBean;
        }
        String newContent = content.substring(0, UUDecoder.getNextBeginIndex(content));
        decodedBean.setContent(newContent);
        List<UUDecodedAttachment> decodedAttachments = UUDecoder.getUUDecodedAttachments(content);
        decodedBean.getAttachments().addAll(decodedAttachments);
        return decodedBean;
    }

    public static List<UUDecodedAttachment> getUUDecodedAttachments(String content) throws UUDecoderException {
        ArrayList<UUDecodedAttachment> res = new ArrayList<UUDecodedAttachment>();
        UUDecoder.getUUDecodedAttachments(content, res);
        return res;
    }

    public static String getNextUUEncodedString(String content) throws UUDecoderException {
        if (content == null) {
            return null;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return null;
        }
        if (beginIndex > endIndex) {
            return UUDecoder.getNextUUEncodedString(content.substring(beginIndex));
        }
        String subString = content.substring(beginIndex, endIndex + 3);
        if (UUDecoder.internalContainsUUencodedAttachments(subString)) {
            return subString;
        }
        return UUDecoder.getNextUUEncodedString(content.substring(beginIndex + 6));
    }

    public static int getNextBeginIndex(String content) throws UUDecoderException {
        if (content == null) {
            return -1;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return -1;
        }
        if (beginIndex > endIndex) {
            return UUDecoder.getNextBeginIndex(content.substring(endIndex + 3));
        }
        String subString = content.substring(beginIndex, endIndex + 3);
        if (UUDecoder.internalContainsUUencodedAttachments(subString)) {
            return beginIndex;
        }
        return UUDecoder.getNextBeginIndex(content.substring(beginIndex + 6));
    }

    public static boolean containsUUEncodedAttachments(String content) throws UUDecoderException {
        if (content == null) {
            return false;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return false;
        }
        if (beginIndex > endIndex) {
            return UUDecoder.containsUUEncodedAttachments(content.substring(beginIndex));
        }
        String subString = content.substring(beginIndex, endIndex + 3);
        if (!UUDecoder.internalContainsUUencodedAttachments(subString)) {
            return UUDecoder.containsUUEncodedAttachments(content.substring(beginIndex + 6));
        }
        return true;
    }

    private static void getUUDecodedAttachments(String content, List<UUDecodedAttachment> res) throws UUDecoderException {
        if (content == null) {
            return;
        }
        int beginIndex = content.indexOf("begin ");
        int endIndex = content.indexOf("end");
        if (beginIndex == -1 || endIndex == -1) {
            return;
        }
        if (beginIndex > endIndex) {
            UUDecoder.getUUDecodedAttachments(content.substring(beginIndex), res);
        } else {
            String subString = content.substring(beginIndex, endIndex + 3);
            if (UUDecoder.internalContainsUUencodedAttachments(subString)) {
                ByteArrayInputStream is = null;
                InputStream isDecoded = null;
                String fileName = null;
                try {
                    fileName = UUDecoder.getUUDecodedFileName(subString, res);
                    is = new ByteArrayInputStream(content.getBytes());
                    isDecoded = MimeUtility.decode((InputStream)is, (String)"uuencode");
                    res.add(new UUDecodedAttachment(fileName, UUDecoder.createDataSource(fileName, isDecoded)));
                }
                catch (Exception e) {
                    try {
                        log.error("Error during decoding of attachment {}", (Object)fileName, (Object)e);
                        throw new UUDecoderException("Error during decoding of attachment " + fileName, e);
                    }
                    catch (Throwable throwable) {
                        UUDecoder.closeStreams(is);
                        throw throwable;
                    }
                }
                UUDecoder.closeStreams(is);
            }
            UUDecoder.getUUDecodedAttachments(content.substring(beginIndex + 6), res);
        }
    }

    private static boolean internalContainsUUencodedAttachments(String content) throws UUDecoderException {
        boolean bl;
        BufferedReader reader;
        block15: {
            String firstLine;
            block14: {
                block13: {
                    block12: {
                        reader = null;
                        reader = new BufferedReader(new StringReader(content));
                        if (!reader.ready()) {
                            throw new UUDecoderException("Error during uuencoded content check: reader not ready", null);
                        }
                        firstLine = reader.readLine();
                        if (firstLine != null && firstLine.regionMatches(false, 0, "begin ", 0, 6)) break block12;
                        boolean bl2 = false;
                        UUDecoder.closeReaders(reader);
                        return bl2;
                    }
                    String lastLine = reader.lines().reduce((first, second) -> second).orElse(null);
                    if (lastLine != null && lastLine.regionMatches(false, 0, "end", 0, 3)) break block13;
                    boolean bl3 = false;
                    UUDecoder.closeReaders(reader);
                    return bl3;
                }
                Integer mode = null;
                try {
                    mode = Integer.parseInt(firstLine.substring(6, 9));
                }
                catch (NumberFormatException e) {
                    log.warn("Permissions mode not valid", (Throwable)e);
                    boolean bl4 = false;
                    UUDecoder.closeReaders(reader);
                    return bl4;
                }
                if (UUDecoder.isOctal(mode)) break block14;
                log.warn("Permissions mode not in octal format");
                boolean e = false;
                UUDecoder.closeReaders(reader);
                return e;
            }
            String fileName = firstLine.substring(9);
            if (fileName != null && !fileName.trim().isEmpty()) break block15;
            log.warn("File name not present");
            boolean bl5 = false;
            UUDecoder.closeReaders(reader);
            return bl5;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            try {
                log.error("Error during uuencoded content check", (Throwable)e);
                throw new UUDecoderException("Error during uuencoded content check", e);
            }
            catch (Throwable throwable) {
                UUDecoder.closeReaders(reader);
                throw throwable;
            }
        }
        UUDecoder.closeReaders(reader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUUDecodedFileName(String content, List<UUDecodedAttachment> res) {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(content));
            string = reader.readLine().substring(9).trim();
        }
        catch (Exception e) {
            String string2;
            try {
                log.error("Error during reading file name", (Throwable)e);
                string2 = UUDecoder.getVersionedFileName("unnamed", res.stream().map(UUDecodedAttachment::getFileName).collect(Collectors.toList()), 1);
            }
            catch (Throwable throwable) {
                UUDecoder.closeReaders(reader);
                throw throwable;
            }
            UUDecoder.closeReaders(reader);
            return string2;
        }
        UUDecoder.closeReaders(reader);
        return string;
    }

    private static String getVersionedFileName(String fileName, List<String> files, int i) {
        if (files.contains(fileName)) {
            fileName = fileName + "(" + i + ")";
            return UUDecoder.getVersionedFileName(fileName, files, i++);
        }
        return fileName;
    }

    private static boolean isOctal(Integer number) {
        boolean isOctal = false;
        while (number > 0) {
            if (number % 10 > 7) {
                isOctal = false;
                break;
            }
            isOctal = true;
            number = number / 10;
        }
        return isOctal;
    }

    private static DataSource createDataSource(String fileName, InputStream inputStream) throws IOException {
        FileTypeMap map = FileTypeMap.getDefaultFileTypeMap();
        String type = map.getContentType(fileName);
        byte[] content = UUDecoder.getContent(inputStream);
        ByteArrayDataSource result = new ByteArrayDataSource(content, type != null ? type : CONTENT_TYPE_OCETSTREAM);
        result.setName(fileName);
        return result;
    }

    private static byte[] getContent(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        UUDecoder.fastCopy(is, os);
        byte[] result = os.toByteArray();
        return result;
    }

    private static void fastCopy(InputStream src, OutputStream dest) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(src);
        WritableByteChannel outputChannel = Channels.newChannel(dest);
        UUDecoder.fastCopy(inputChannel, outputChannel);
        inputChannel.close();
        outputChannel.close();
    }

    private static void fastCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    private static void closeStreams(InputStream ... streams) {
        for (InputStream stream : streams) {
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeReaders(Reader ... readers) {
        for (Reader reader : readers) {
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class UUDecodedAttachment {
        private String fileName;
        private DataSource dataSource;

        public String getFileName() {
            return this.fileName;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UUDecodedAttachment)) {
                return false;
            }
            UUDecodedAttachment other = (UUDecodedAttachment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            DataSource this$dataSource = this.getDataSource();
            DataSource other$dataSource = other.getDataSource();
            return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UUDecodedAttachment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            DataSource $dataSource = this.getDataSource();
            result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
            return result;
        }

        public String toString() {
            return "UUDecoder.UUDecodedAttachment(fileName=" + this.getFileName() + ", dataSource=" + this.getDataSource() + ")";
        }

        public UUDecodedAttachment(String fileName, DataSource dataSource) {
            this.fileName = fileName;
            this.dataSource = dataSource;
        }
    }
}

