package app.tulz.diff

import app.tulz.diff.format.DiffFormat
import app.tulz.diff.util.DiffCollapse

object StringDiff {

  def apply(
    actual: String,
    expected: String,
    collapse: Boolean = true
  ): String = ansi(actual, expected)

  def ansi(
    actual: String,
    expected: String,
    collapse: Boolean = true
  ): String =
    DiffFormat.ansi(diff(actual, expected, collapse))

  def ansiBoth(
    actual: String,
    expected: String,
    collapse: Boolean = true
  ): (String, String) =
    DiffFormat.ansiBoth(diff(actual, expected, collapse))

  def text(
    actual: String,
    expected: String,
    collapse: Boolean = true
  ): String =
    DiffFormat.ansi(diff(actual, expected, collapse))

  def raw(
    actual: String,
    expected: String,
    collapse: Boolean = true
  ): List[DiffElement[String]] =
    diff(actual, expected, collapse).map(_.map(_.mkString))

  def diff[Out](
    actual: String,
    expected: String,
    collapse: Boolean
  ): List[DiffElement[String]] = {
    val myersDiff = MyersDiff.diff(actual.view, expected.view)
    val diff      = MyersInterpret(myersDiff, actual.view, expected.view)
    val result = if (collapse) {
      DiffCollapse(diff)
    } else {
      diff
    }
    result.map(_.map(_.mkString))
  }

}
