package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.records.SegmentData;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.Getter;
import lombok.Setter;

@Getter
@Entity
@Table(uniqueConstraints = {@UniqueConstraint(columnNames = {"attached_model_id", "segment_name"})})
public class Segment implements DataTransformer<SegmentData>, ModelProvider {
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private long id;

  @Setter @ManyToOne private Model attachedModel;

  @Setter
  @Column(name = "segment_name")
  private String segmentName;

  @Setter
  @Column(name = "segment_currency")
  private String segmentCurrency;

  /** Creates a new @Segment */
  public Segment() {}

  public Segment(Segment segment) {
    this(segment.asData(), segment.getAttachedModel());
  }

  public Segment(SegmentData segmentData, Model attachedModel) {
    this.updateFrom(segmentData, attachedModel);
  }

  @Override
  public SegmentData asData() {
    return new SegmentData(id, segmentName, segmentCurrency);
  }

  public void updateFrom(SegmentData segmentData, Model model) {
    this.attachedModel = model;
    this.segmentName = segmentData.segmentName();
    this.segmentCurrency = segmentData.segmentCurrency();
  }

  @Override
  public Long getModelId() {
    return this.attachedModel.getId();
  }
}
