package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.records.VariableValueData;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import jakarta.persistence.*;
import java.time.LocalDateTime;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;

@Data
@Entity
@Table(
    uniqueConstraints = {
      @UniqueConstraint(
          columnNames = {"attached_variable_id", "period", "attached_segment_id", "scenarioNumber"})
    })
public class VariableValue implements DataTransformer<VariableValueData>, ModelProvider {

  @Setter(AccessLevel.NONE)
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private long id;

  private Integer period;

  private Float value;

  private LocalDateTime lastChanged;
  private Integer scenarioNumber;
  private String editor;

  private String sourceFile;

  @ManyToOne private Variable attachedVariable;

  @ManyToOne private Segment attachedSegment;

  public VariableValue() {}

  public VariableValue(VariableValueData variableData, Variable variable) {
    this.period = variableData.period();
    this.value = variableData.value();
    this.lastChanged = LocalDateTime.now();
    this.scenarioNumber = variableData.scenarioNumber() != null ? variableData.scenarioNumber() : 0;
    this.attachedVariable = variable;
    this.editor = variableData.user();
    this.sourceFile = variableData.sourceFile();
  }

  private Long getAttachedSegmentId() {
    if (this.attachedSegment != null) {
      return this.attachedSegment.getId();
    }
    return null;
  }

  @Override
  public VariableValueData asData() {
    return new VariableValueData(
        this.id,
        this.period,
        this.value,
        this.lastChanged,
        this.scenarioNumber,
        this.getAttachedSegmentId(),
        this.getAttachedVariable().getId(),
        this.editor,
        this.sourceFile);
  }

  @Override
  public Long getModelId() {
    return this.getAttachedVariable().getModelId();
  }
}
