package app.valuationcontrol.multimodule.library.helpers.openai;


import app.valuationcontrol.multimodule.library.records.ReviewResponse;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.FunctionExecutor;
import com.theokanning.openai.service.OpenAiService;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Getter
public class OpenAiServiceImplementation {
  OpenAiService openAiService;
  String model;

  @Autowired
  public OpenAiServiceImplementation(Environment environment) {
    if (environment != null) {
      this.openAiService =
          new OpenAiService(environment.getProperty("openai.key", ""), Duration.ofSeconds(45));
      this.model = environment.getProperty("openai.model", "");
    }
  }

  public ChatCompletionRequest getChatRequestWithFunction(
      List<ChatMessage> messages, FunctionExecutor functionExecutor, String functionName) {
    return ChatCompletionRequest.builder()
        .model(this.model)
        .temperature(0.8D)
        .messages(messages)
        .functions(functionExecutor.getFunctions())
        .functionCall(ChatCompletionRequest.ChatCompletionRequestFunctionCall.of(functionName))
        .n(1)
        .logitBias(new HashMap<>())
        .build();
  }

  public ChatCompletionRequest getChatRequest(List<ChatMessage> messages) {
    return ChatCompletionRequest.builder()
        .model(this.model)
        .temperature(0.8D)
        .messages(messages)
        .n(1)
        .logitBias(new HashMap<>())
        .build();
  }

  public FunctionExecutor getReviewFunction() {
    return new FunctionExecutor(
        Collections.singletonList(
            ChatFunction.builder()
                .name("get_review")
                .description("Get the review of the current variable")
                .executor(
                    ReviewResponse.class,
                    r ->
                        new ReviewResponse(
                            r.variableId(), r.score(), r.explanation(), r.suggestion()))
                .build()));
  }
}
