package app.valuationcontrol.multimodule.library.helpers.security;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.User;
import java.io.Serial;
import java.util.Collection;
import java.util.Collections;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class MyUserPrincipal implements UserDetails {
  /** */
  @Serial private static final long serialVersionUID = 1L;

  private final transient User user;

  public MyUserPrincipal(User user) {
    this.user = user;
  }

  @SuppressWarnings("unused") // Used in SPEL
  public Boolean hasModelRole(Model model, String role) throws AccessDeniedException {
    return user.validateRole(role, model.getId(), false);
  }

  public Boolean hasModelRole(Long modelId, String role) throws AccessDeniedException {
    return user.validateRole(role, modelId, false);
  }

  @SuppressWarnings("unused") // Used in SPEL
  public Boolean hasAccessToTemplate(Long templateId) throws AccessDeniedException {
    if (templateId == -1) {
      return true;
    } else {
      return user.validateRole(String.valueOf(User.MODEL_ROLE.READER), templateId, false);
    }
  }

  @SuppressWarnings("unused") // Used in SPEL in entrypoint
  public Boolean canUnlock(Model model, String role) throws AccessDeniedException {
    return user.validateRole(role, model.getId(), true);
  }

  @Override
  public Collection<? extends GrantedAuthority> getAuthorities() {
    return Collections.emptyList();
  }

  @Override
  public String getPassword() {
    return null;
  }

  @Override
  public String getUsername() {
    return user.getEmail();
  }

  @Override
  public boolean isAccountNonExpired() {
    return false;
  }

  @Override
  public boolean isAccountNonLocked() {
    return false;
  }

  @Override
  public boolean isCredentialsNonExpired() {
    return false;
  }

  @Override
  public boolean isEnabled() {
    return false;
  }
}
