package app.valuationcontrol.multimodule.library.xlhandler;


import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import app.valuationcontrol.multimodule.library.entities.SensitivityResult;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.records.CalculationData;


import java.io.InputStream;
import java.time.Duration;
import java.util.List;

public interface ScenarioDataProvider {
  void runSensitivities(List<Sensitivity> sensitivity, SCENARIO scenario);

  CalculationData getContent(SCENARIO scenario);

  boolean isUnusedFor(Duration maxInactivity);

  void sleep();

  InputStream saveAs();

  void clearCacheAndReloadAndUpdateClients();

  void reloadAndUpdateClients();

  void refreshValue(Variable attachedVariable, VariableValue newVersion);

  void reloadVariableAndUpdateCache(Variable attachedVariable);

  List<SensitivityResult> getSensitivityResults();
}
