/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers.security;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.User;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class MyUserPrincipal
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private final transient User user;

    public MyUserPrincipal(User user) {
        this.user = user;
    }

    public Boolean hasModelRole(Model model, String role) throws AccessDeniedException {
        return this.user.validateRole(role, model.getId(), false);
    }

    public Boolean hasModelRole(Long modelId, String role) throws AccessDeniedException {
        return this.user.validateRole(role, modelId, false);
    }

    public Boolean hasAccessToTemplate(Long templateId) throws AccessDeniedException {
        if (templateId == -1L) {
            return true;
        }
        return this.user.validateRole(String.valueOf((Object)User.MODEL_ROLE.READER), templateId, false);
    }

    public Boolean canUnlock(Model model, String role) throws AccessDeniedException {
        return this.user.validateRole(role, model.getId(), true);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.emptyList();
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.user.getEmail();
    }

    public boolean isAccountNonExpired() {
        return false;
    }

    public boolean isAccountNonLocked() {
        return false;
    }

    public boolean isCredentialsNonExpired() {
        return false;
    }

    public boolean isEnabled() {
        return false;
    }
}

