/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.records.CalculationData;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.stereotype.Component;

@Component
public class ModelChangeNotifier {
    private static final Logger log = LogManager.getLogger(ModelChangeNotifier.class);
    private final SimpMessagingTemplate websocket;
    private final SimpUserRegistry userRegistry;

    @Autowired
    public ModelChangeNotifier(SimpMessagingTemplate websocket, SimpUserRegistry userRegistry) {
        this.websocket = websocket;
        this.userRegistry = userRegistry;
    }

    public HashSet<Integer> fetchScenariosFromUserRegistry(Long modelId) {
        HashSet<Integer> loadedScenarios = new HashSet<Integer>();
        this.userRegistry.getUsers().forEach(u -> u.getSessions().forEach(simpSession -> simpSession.getSubscriptions().stream().filter(simpSubscription -> simpSubscription.getDestination().contains("/topic/model/" + modelId + "/")).forEach(simpSubscription -> {
            try {
                Integer scenarioNumber = Integer.parseInt(simpSubscription.getDestination().replace("/topic/model/" + modelId + "/", ""));
                loadedScenarios.add(scenarioNumber);
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse scenarioNumber in subscription");
            }
        })));
        return loadedScenarios;
    }

    public HashSet<Integer> getLoadedScenario(long modelId) {
        HashSet<Integer> loadedScenarios = this.fetchScenariosFromUserRegistry(modelId);
        loadedScenarios.add(0);
        log.debug(loadedScenarios);
        return loadedScenarios;
    }

    public void updateUsersModel(CalculationData calculationData) {
        log.debug("Updating scenario: {}", (Object)calculationData.getScenarioNumber());
        this.websocket.convertAndSend((Object)("/topic/model/" + calculationData.getModel().id() + "/" + calculationData.getScenarioNumber()), (Object)calculationData);
    }
}

