/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import app.valuationcontrol.multimodule.library.entities.SensitivityResult;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.helpers.CellError;
import app.valuationcontrol.multimodule.library.helpers.DataPeriod;
import app.valuationcontrol.multimodule.library.records.CalculationData;
import app.valuationcontrol.multimodule.library.xlhandler.CalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.CellValueHelper;
import app.valuationcontrol.multimodule.library.xlhandler.GenericSheet;
import app.valuationcontrol.multimodule.library.xlhandler.ModelChangeNotifier;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import app.valuationcontrol.multimodule.library.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.multimodule.library.xlhandler.SensitivityRunner;
import app.valuationcontrol.multimodule.library.xlhandler.VariableEvaluator;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XLInstance
implements ScenarioDataProvider {
    private static final Logger log = LogManager.getLogger(XLInstance.class);
    public static final String INPUT = "input";
    public static final String PERCENT = "percent";
    public static final int YTD_PERIOD = -500;
    private final CalcDocument calcDocument;
    private final ModelChangeNotifier modelChangeNotifier;
    private Model attachedModel;
    private final Map<Long, List<CellError>> formulaErrors = new ConcurrentHashMap<Long, List<CellError>>();
    private final Map<SCENARIO, Map<Long, List<CellError>>> variableCellErrorsByScenario = new ConcurrentHashMap<SCENARIO, Map<Long, List<CellError>>>();
    private final Map<SCENARIO, Object[][]> cacheValues = new ConcurrentHashMap<SCENARIO, Object[][]>();
    private List<SensitivityResult> sensitivityResults = new ArrayList<SensitivityResult>();
    private final AtomicLong lastUsed = new AtomicLong();

    public XLInstance(Model attachedModel, CalcDocument calcDocument, ModelChangeNotifier modelChangeNotifier) {
        this.attachedModel = attachedModel;
        this.calcDocument = calcDocument;
        this.modelChangeNotifier = modelChangeNotifier;
        this.lastUsed.set(System.currentTimeMillis());
        this.reloadWholeBaseContentIfNoCache();
    }

    @Override
    public InputStream saveAs() {
        this.calcDocument.assertConnected(() -> {
            log.debug("saving document");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        return this.calcDocument.saveAs();
    }

    @Override
    public void reloadAndUpdateClients() {
        log.debug("Entering reloadAndUpdateClients " + String.valueOf(this.calcDocument));
        this.reloadWholeBaseContentIfNoCache();
        this.modelChangeNotifier.getLoadedScenario(this.attachedModel.getId()).forEach(scenarioNumber -> {
            log.debug("Reload and update clients : Content was reloaded for scenario Base ");
            this.sendUpdateToClients(SCENARIO.from(scenarioNumber));
        });
        log.debug("Exiting reloadAndUpdateClients" + String.valueOf(this.calcDocument));
    }

    public void setSingleValue(VariableValue variableValue) {
        if (variableValue != null && variableValue.getValue() != null) {
            this.insertIntoCell(SCENARIO.from(variableValue.getScenarioNumber()), CellValueHelper.cellValueOf(variableValue));
        }
    }

    @Override
    public void runSensitivities(List<Sensitivity> sensitivities, SCENARIO scenario) {
        this.calcDocument.assertConnected(() -> {
            log.debug("CacheValues: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        SensitivityRunner sensitivityRunner = new SensitivityRunner(this.calcDocument, sensitivities, scenario, this.attachedModel);
        this.sensitivityResults = sensitivityRunner.runSensitivities();
    }

    public void updateCacheValues(SCENARIO scenario) {
        if (this.attachedModel.getVariables().isEmpty()) {
            return;
        }
        log.debug("Entering updateCacheValues" + String.valueOf(this.calcDocument));
        try {
            this.lastUsed.set(System.currentTimeMillis());
            long millis = System.currentTimeMillis();
            if (!scenario.equals((Object)SCENARIO.BASE) && this.cacheValues.get((Object)SCENARIO.BASE) == null) {
                this.reloadWholeBaseContentIfNoCache();
            }
            this.calcDocument.assertConnected(() -> {
                log.debug("CacheValues: Force Reloading base");
                this.cacheValues.clear();
                this.reloadWholeBaseContentIfNoCache();
            });
            log.debug("CacheValues: Opening sheet in cacheValues " + String.valueOf((Object)scenario));
            GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(scenario);
            this.setScenarioVariableValues(scenario, scenarioGenericSheet);
            int endRow = this.attachedModel.getNumberOfVariables() - 1;
            Object[][] xlObject = scenarioGenericSheet.getValues(this.attachedModel.indexOfLastColumn(), endRow);
            this.cacheValues.put(scenario, xlObject);
            log.debug("CacheContent for scenario {} was defined in {}", (Object)scenario, (Object)(System.currentTimeMillis() - millis + "ms"));
            log.debug("Exiting updateCacheValues" + String.valueOf(this.calcDocument));
        }
        catch (Exception e) {
            log.error("Couldn't get content " + String.valueOf(e));
        }
    }

    @Override
    public synchronized CalculationData getContent(SCENARIO scenario) {
        log.debug("Entering getContent" + String.valueOf(this.calcDocument));
        this.lastUsed.set(System.currentTimeMillis());
        long millis = System.currentTimeMillis();
        try {
            if (this.attachedModel.getVariables().isEmpty()) {
                return new CalculationData(this.attachedModel, new ArrayList<SensitivityResult>(), new HashMap<Long, List<CellError>>(), new HashMap<Long, List<CellError>>(), scenario.ordinal());
            }
            if (this.cacheValues.get((Object)scenario) == null) {
                log.debug("updating cacheValues in getContent");
                this.updateCacheValues(scenario);
            }
            Object[][] xlObject = this.cacheValues.get((Object)scenario);
            log.debug("CacheValues is of size" + xlObject.length);
            for (Variable variable : this.attachedModel.getVariables()) {
                int row = variable.getRow();
                if (variable.isSingleOrConstantValue()) {
                    ArrayList<Object> singleOrConstantValues = new ArrayList<Object>();
                    singleOrConstantValues.add(xlObject[row][this.attachedModel.getConstantColumn()]);
                    if (variable.isModelledAtSegment()) {
                        for (int i = 1; i <= this.attachedModel.getSegments().size(); ++i) {
                            column = variable.columnOfSegmentAndPeriod(i - 1, (Integer)0);
                            singleOrConstantValues.add(xlObject[row][column]);
                        }
                    }
                    variable.setSingleOrConstantValue(singleOrConstantValues);
                } else {
                    ArrayList<Object[]> historicalValues = new ArrayList<Object[]>();
                    ArrayList<Object[]> projectionValues = new ArrayList<Object[]>();
                    if (this.attachedModel.isIncludeYTD()) {
                        column = variable.columnOfSegmentAndPeriod(-1, this.attachedModel.getNbProjectionPeriod());
                        variable.getYearToDateValue().add(xlObject[row][column]);
                        variable.getYearToGoValue().add(xlObject[row][column + 1]);
                    }
                    historicalValues.add(Arrays.copyOfRange(xlObject[row], variable.columnOfSegmentAndPeriod(-1, (Integer)(-this.attachedModel.getNbHistoricalPeriod().intValue())), variable.columnOfSegmentAndPeriod(-1, (Integer)0)));
                    projectionValues.add(Arrays.copyOfRange(xlObject[row], variable.columnOfSegmentAndPeriod(-1, (Integer)0), variable.columnOfSegmentAndPeriod(-1, this.attachedModel.getNbProjectionPeriod())));
                    if (variable.isModelledAtSegment()) {
                        for (int i = 0; i < this.attachedModel.getSegments().size(); ++i) {
                            if (this.attachedModel.isIncludeYTD()) {
                                int column = variable.columnOfSegmentAndPeriod(i, this.attachedModel.getNbProjectionPeriod());
                                variable.getYearToDateValue().add(xlObject[row][column]);
                                variable.getYearToGoValue().add(xlObject[row][column + 1]);
                            }
                            int historicalStart = variable.columnOfSegmentAndPeriod(i, (Integer)(-this.attachedModel.getNbHistoricalPeriod().intValue()));
                            int historicalEnd = variable.columnOfSegmentAndPeriod(i, (Integer)0);
                            historicalValues.add(Arrays.copyOfRange(xlObject[row], historicalStart, historicalEnd));
                            int projectionStart = variable.columnOfSegmentAndPeriod(i, (Integer)0);
                            int projectionEnd = variable.columnOfSegmentAndPeriod(i, this.attachedModel.getNbProjectionPeriod());
                            projectionValues.add(Arrays.copyOfRange(xlObject[row], projectionStart, projectionEnd));
                        }
                    }
                    variable.setHistoricalValues(historicalValues);
                    variable.setProjectionValues(projectionValues);
                }
                this.getCellErrors(variable, scenario);
            }
            CalculationData returnObject = new CalculationData(this.attachedModel, this.getSensitivityResults(), this.formulaErrors, this.variableCellErrorsByScenario.get((Object)scenario), scenario.ordinal());
            log.debug("Content for scenario {} was fetched in {}", (Object)scenario, (Object)(System.currentTimeMillis() - millis + "ms"));
            this.lastUsed.set(System.currentTimeMillis());
            log.debug("Exiting getContent" + String.valueOf(this.calcDocument));
            return returnObject;
        }
        catch (Exception e) {
            log.error("Couldn't get content " + String.valueOf(e));
            return null;
        }
    }

    private void setScenarioVariableValues(SCENARIO scenario, GenericSheet scenarioGenericSheet) {
        List cellValues = this.attachedModel.getVariables().stream().flatMap(variable -> variable.getVariableValuesForAScenario(scenario).stream().filter(v -> v.getValue() != null).filter(v -> v.getAttachedVariable().getAttachedModel().isIncludeYTD() || !Objects.requireNonNullElse(v.getPeriod(), 0).equals(-500)).map(CellValueHelper::cellValueOf)).toList();
        if (!cellValues.isEmpty()) {
            scenarioGenericSheet.setCellValues(cellValues.toArray(new GenericSheet.CellValue[0]));
        }
    }

    public String[] generateVariableArray(Variable variable) {
        String[] dumpArrayRow = new String[variable.getAttachedModel().getArraySize().intValue()];
        this.formulaErrors.remove(variable.getId());
        this.initVariableRow(dumpArrayRow, variable);
        boolean segmentExists = this.checkSegmentsExist(variable);
        if (variable.isSingleOrConstantValue()) {
            this.performSingleEntryReplication(variable, dumpArrayRow);
            String summaryFormula = "=";
            if (segmentExists && !variable.getVariableFormat().equals("date")) {
                String divider = variable.getVariableFormat().equals(PERCENT) ? String.valueOf(Math.max(1, this.attachedModel.getSegments().size())) : "1";
                for (int j = 0; j < this.attachedModel.getSegments().size(); ++j) {
                    summaryFormula = MessageFormat.format("{0}+{1}/{2}", summaryFormula, CellValueHelper.generateAddress(variable, variable.columnOfSegmentAndPeriod(j, (Integer)1)), divider);
                }
                dumpArrayRow[variable.getPrimaryColumn()] = summaryFormula;
            }
        } else {
            boolean performHistoricalReplication = this.shouldReplicateHistorical(variable);
            if (performHistoricalReplication) {
                this.performHistoricalReplication(variable, dumpArrayRow, segmentExists);
            }
            this.performForecastReplication(variable, dumpArrayRow, segmentExists);
            if (this.attachedModel.isIncludeYTD()) {
                this.performYTDReplication(variable, dumpArrayRow, segmentExists);
            }
            if (segmentExists && !variable.getVariableFormat().equals("date") && !variable.getVariableType().equals(INPUT)) {
                int start = -this.getAttachedModel().getNbHistoricalPeriod().intValue();
                int stop = this.getAttachedModel().getNbProjectionPeriod();
                for (int i = start; i < stop; ++i) {
                    String summaryFormula = "=";
                    if (variable.isPercentOrKPI()) {
                        DataPeriod segmentConstantPeriod = new DataPeriod(this.getAttachedModel(), i, 0, variable.isSingleOrConstantValue());
                        summaryFormula = VariableEvaluator.evaluateVariable(variable, segmentConstantPeriod, this.formulaErrors);
                    } else {
                        for (int j = 0; j < this.attachedModel.getSegments().size(); ++j) {
                            summaryFormula = MessageFormat.format("{0}+{1}", summaryFormula, CellValueHelper.generateAddress(variable, variable.columnOfSegmentAndPeriod(j, (Integer)i)));
                        }
                    }
                    dumpArrayRow[variable.getPrimaryColumn() + i] = summaryFormula;
                }
                if (variable.getVariableFormat().equals(PERCENT)) {
                    variable.getVariableDependencies().stream().filter(variable1 -> variable1.getVariableType().equals(INPUT)).forEach(variable2 -> {
                        CellError e = new CellError(0, "Dependency to input", "You should change the formula to avoid the use of input variables (" + variable2.getVariableName() + " ) in an aggregated segment value");
                        this.formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
                    });
                }
            }
        }
        return dumpArrayRow;
    }

    private void performSingleEntryReplication(Variable variable, String[] dumpArrayRow) {
        if (variable.isSingleOrConstantValue()) {
            if (variable.isModelledAtSegment() && this.attachedModel.getSegments() != null && !this.attachedModel.getSegments().isEmpty()) {
                for (int i = 1; i <= this.attachedModel.getSegments().size(); ++i) {
                    DataPeriod segmentConstantPeriod = new DataPeriod(this.getAttachedModel(), 0, i, variable.isSingleOrConstantValue());
                    int cellColumn = variable.columnOfSegmentAndPeriod(i - 1, (Integer)0);
                    dumpArrayRow[cellColumn] = VariableEvaluator.evaluateVariable(variable, segmentConstantPeriod, this.formulaErrors);
                }
            } else {
                DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), 0, 0, variable.isSingleOrConstantValue());
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)0))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
            }
        }
    }

    private void performYTDReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        int YTDperiod = this.attachedModel.getNbProjectionPeriod();
        int YTGperiod = YTDperiod + 1;
        if (segmentReplicationShouldBePerformed) {
            for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                Object ytgFormula;
                String ytdFormula = null;
                if (variable.isPercentOrKPI() || variable.isTypeTotal()) {
                    DataPeriod YTDdataPeriod = new DataPeriod(this.getAttachedModel(), YTDperiod, segmentIndex + 1, variable.isSingleOrConstantValue());
                    DataPeriod YTGdataPeriod = new DataPeriod(this.getAttachedModel(), YTGperiod, segmentIndex + 1, variable.isSingleOrConstantValue());
                    ytdFormula = VariableEvaluator.evaluateVariable(variable, YTDdataPeriod, this.formulaErrors);
                    ytgFormula = VariableEvaluator.evaluateVariable(variable, YTGdataPeriod, this.formulaErrors);
                } else {
                    ytgFormula = "=" + MessageFormat.format("{0}-{1}", CellValueHelper.generateAddress(variable, variable.columnOfSegmentAndPeriod(segmentIndex, (Integer)0)), CellValueHelper.generateAddress(variable, variable.columnOfSegmentAndPeriod(segmentIndex, (Integer)(YTGperiod - 1))));
                }
                if (ytdFormula != null) {
                    dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)YTDperiod))] = ytdFormula;
                }
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)YTGperiod))] = ytgFormula;
            }
        } else {
            Object ytgFormula;
            String ytdFormula = null;
            if (variable.isPercentOrKPI() || variable.isTypeTotal()) {
                DataPeriod YTDdataPeriod = new DataPeriod(this.getAttachedModel(), YTDperiod, 0, variable.isSingleOrConstantValue());
                DataPeriod YTGdataPeriod = new DataPeriod(this.getAttachedModel(), YTGperiod, 0, variable.isSingleOrConstantValue());
                ytdFormula = VariableEvaluator.evaluateVariable(variable, YTDdataPeriod, this.formulaErrors);
                ytgFormula = VariableEvaluator.evaluateVariable(variable, YTGdataPeriod, this.formulaErrors);
            } else {
                ytgFormula = "=" + MessageFormat.format("{0}-{1}", CellValueHelper.generateAddress(variable, variable.columnOfSegmentAndPeriod(-1, (Integer)0)), CellValueHelper.generateAddress(variable, variable.columnOfSegmentAndPeriod(-1, (Integer)(YTGperiod - 1))));
            }
            if (ytdFormula != null) {
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)YTDperiod))] = ytdFormula;
            }
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)YTGperiod))] = ytgFormula;
        }
    }

    private void performForecastReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        for (int period = 0; period < this.getAttachedModel().getNbProjectionPeriod(); ++period) {
            if (segmentReplicationShouldBePerformed) {
                for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                    DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, segmentIndex + 1, variable.isSingleOrConstantValue());
                    dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
                }
                continue;
            }
            DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, 0, variable.isSingleOrConstantValue());
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
        }
    }

    private void performHistoricalReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        for (int period = -this.getAttachedModel().getNbHistoricalPeriod().intValue(); period < 0; ++period) {
            if (segmentReplicationShouldBePerformed) {
                for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                    DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, segmentIndex + 1, variable.isSingleOrConstantValue());
                    int column = variable.columnOfSegmentAndPeriod(segmentIndex, (Integer)period);
                    dumpArrayRow[column] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
                }
                continue;
            }
            DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, 0, variable.isSingleOrConstantValue());
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
        }
    }

    private void initVariableRow(String[] dumpArrayRow, Variable variable) {
        dumpArrayRow[0] = String.valueOf(variable.getId());
        dumpArrayRow[1] = variable.getVariableName();
        dumpArrayRow[2] = variable.getVariableFormula();
        dumpArrayRow[3] = variable.getVariableType();
        dumpArrayRow[4] = String.valueOf(variable.getVariableArea().getId());
        dumpArrayRow[5] = String.valueOf(variable.getVariableSubArea().getId());
        dumpArrayRow[6] = variable.getVariableFormat();
        dumpArrayRow[7] = String.valueOf(variable.getVariableOrder());
        dumpArrayRow[8] = String.valueOf(variable.getVariableDepth());
    }

    private boolean shouldReplicateHistorical(Variable myVariable) {
        return this.getAttachedModel().getNbHistoricalPeriod() > 0 && (myVariable.isVariableApplyToHistoricals() || myVariable.getVariableType().contains("total") || myVariable.getVariableType().contains("kpi"));
    }

    private boolean checkSegmentsExist(Variable myVariable) {
        return myVariable.isModelledAtSegment() && !this.attachedModel.getSegments().isEmpty();
    }

    public synchronized void cleanAndUpdateAdditionalSheets() {
        log.debug("Entering cleanAndUpdateAdditionalSheets" + String.valueOf(this.calcDocument));
        this.calcDocument.closeAllButBase();
        this.modelChangeNotifier.getLoadedScenario(this.attachedModel.getId()).stream().filter(scenarioNumber -> !scenarioNumber.equals(SCENARIO.BASE.ordinal())).forEach(scenarioNumber -> {
            log.debug("Reloading closed sheet for scenario " + scenarioNumber);
            SCENARIO scenario = SCENARIO.from(scenarioNumber);
            log.debug("Refreshing scenario " + String.valueOf((Object)scenario));
            this.updateCacheValues(scenario);
        });
        log.debug("Exiting cleanAndUpdateAdditionalSheets" + String.valueOf(this.calcDocument));
    }

    private void sendUpdateToClients(SCENARIO scenario) {
        CalculationData calculationData = this.getContent(scenario);
        this.modelChangeNotifier.updateUsersModel(calculationData);
    }

    private void insertIntoCell(SCENARIO scenario, GenericSheet.CellValue cellValue) {
        GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(scenario);
        scenarioGenericSheet.setCellValues(cellValue);
    }

    @Override
    public void refreshValue(Variable myVariable, VariableValue myVariableValue) {
        long millis = System.currentTimeMillis();
        this.calcDocument.preventScreenUpdating(true);
        this.calcDocument.assertConnected(() -> {
            log.debug("refreshValue: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        if (Objects.equals(myVariableValue.getScenarioNumber(), SCENARIO.BASE.ordinal())) {
            this.reloadVariableAndUpdateCache(myVariable);
        } else {
            this.cacheValues.remove((Object)SCENARIO.from(myVariableValue.getScenarioNumber()));
            this.setSingleValue(myVariableValue);
        }
        this.calcDocument.preventScreenUpdating(false);
        log.debug("Model was refreshed in : " + (System.currentTimeMillis() - millis) + "ms");
    }

    @Override
    public void reloadVariableAndUpdateCache(Variable variable) {
        log.debug("Entering reloadVariableAndUpdateCache " + String.valueOf(this.calcDocument));
        this.calcDocument.assertConnected(() -> {
            log.debug("reloadVariableAndUpdateCache: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        int arraySize = variable.getAttachedModel().getArraySize();
        String[][] dumpArray = new String[1][arraySize];
        for (int j = 0; j < arraySize; ++j) {
            dumpArray[0][j] = "";
        }
        this.calcDocument.preventScreenUpdating(true);
        dumpArray[0] = this.generateVariableArray(variable);
        GenericSheet baseGenericSheet = this.calcDocument.getSheet(SCENARIO.BASE);
        baseGenericSheet.setRowValues(variable.getRow(), dumpArray[0]);
        this.cacheValues.clear();
        this.updateCacheValues(SCENARIO.BASE);
        this.cleanAndUpdateAdditionalSheets();
        this.calcDocument.preventScreenUpdating(false);
        log.debug("Exiting reloadVariableAndUpdateCache " + String.valueOf(this.calcDocument));
    }

    public void reloadWholeBaseContentIfNoCache() {
        log.debug("Entering reloadWholeBaseContentIfNoCache " + String.valueOf(this.calcDocument));
        if (this.cacheValues.get((Object)SCENARIO.BASE) == null) {
            int numberOfVariables = this.getAttachedModel().getNumberOfVariables();
            long millis = System.currentTimeMillis();
            if (numberOfVariables > 0) {
                int arraySize = this.getAttachedModel().getArraySize();
                String[][] dumpArray = new String[numberOfVariables][arraySize];
                for (int i = 0; i < numberOfVariables; ++i) {
                    for (int j = 0; j < arraySize; ++j) {
                        dumpArray[i][j] = "";
                    }
                }
                this.calcDocument.preventScreenUpdating(true);
                this.calcDocument.closeAllSheets();
                this.formulaErrors.clear();
                long before = System.currentTimeMillis();
                for (Variable myVariable : this.attachedModel.getVariables()) {
                    dumpArray[myVariable.getRow()] = this.generateVariableArray(myVariable);
                }
                log.debug("Logic was loaded in : " + (System.currentTimeMillis() - before) + "ms");
                GenericSheet baseGenericSheet = this.calcDocument.getSheet(SCENARIO.BASE);
                baseGenericSheet.setValue(dumpArray, Math.max(arraySize - 1, 0), Math.max(this.attachedModel.getNumberOfVariables() - 1, 0));
                this.setScenarioVariableValues(SCENARIO.BASE, baseGenericSheet);
                this.updateCacheValues(SCENARIO.BASE);
                this.calcDocument.preventScreenUpdating(false);
                log.debug("Model was refreshed and cached in : " + (System.currentTimeMillis() - millis) + "ms");
            } else {
                log.debug("No variables so model was not reloaded");
            }
        }
    }

    private void getCellErrors(Variable myVariable, SCENARIO scenario) {
        GenericSheet genericSheet = this.calcDocument.getSheet(scenario);
        ArrayList<CellError> cellErrors = new ArrayList<CellError>();
        this.variableCellErrorsByScenario.computeIfAbsent(scenario, i -> new ConcurrentHashMap()).put(myVariable.getId(), cellErrors);
        int historicalPeriods = myVariable.isSingleOrConstantValue() ? 0 : this.attachedModel.getNbHistoricalPeriod();
        int startIndex = myVariable.getPrimaryColumn() - historicalPeriods;
        int periodIndex = -historicalPeriods;
        int i2 = startIndex;
        while (i2 < myVariable.getAttachedModel().getArraySize()) {
            try {
                String error = genericSheet.getErrorInCell(i2, myVariable.getRow());
                if (error != null) {
                    CellError e = new CellError(periodIndex, "CalculationError", error);
                    cellErrors.add(e);
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            ++i2;
            ++periodIndex;
        }
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    @Override
    public boolean isUnusedFor(Duration inactivityThreshold) {
        return System.currentTimeMillis() - inactivityThreshold.toMillis() > this.lastUsed.get();
    }

    @Override
    public void sleep() {
        this.calcDocument.close();
    }

    @Override
    public void clearCacheAndReloadAndUpdateClients() {
        this.cacheValues.clear();
        this.reloadAndUpdateClients();
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    @Override
    public List<SensitivityResult> getSensitivityResults() {
        return this.sensitivityResults;
    }
}

