/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers.stompInterceptors;

import app.valuationcontrol.multimodule.library.helpers.security.JwtAuthenticationConverter;
import java.security.Principal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

public class VerifyConnectInterceptor
implements ChannelInterceptor {
    private static final Logger log = LogManager.getLogger(VerifyConnectInterceptor.class);
    @Autowired
    final JwtDecoder jwtDecoder;
    @Autowired
    final JwtAuthenticationConverter jwtAuthenticationConverter;

    public VerifyConnectInterceptor(JwtDecoder jwtDecoder, JwtAuthenticationConverter jwtAuthenticationConverter) {
        this.jwtDecoder = jwtDecoder;
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
    }

    public Message<?> preSend(@NonNull Message<?> message, @NonNull MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        if (accessor != null && StompCommand.CONNECT.equals((Object)accessor.getCommand())) {
            List authorization = accessor.getNativeHeader("Authorization");
            if (authorization != null) {
                try {
                    String accessToken = ((String)authorization.get(0)).split(" ")[1];
                    Jwt jwt = this.jwtDecoder.decode(accessToken);
                    AbstractAuthenticationToken authentication = this.jwtAuthenticationConverter.convert(jwt);
                    accessor.setUser((Principal)authentication);
                }
                catch (Exception e) {
                    log.info((Object)e);
                }
            } else {
                log.info("No authentication found");
            }
        }
        return message;
    }
}

