package app.valuationcontrol.multimodule.library.helpers.stompInterceptors;

import app.valuationcontrol.multimodule.library.helpers.security.JwtAuthenticationConverter;
import java.util.List;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

@Log4j2
public class VerifyConnectInterceptor implements ChannelInterceptor {

  @Autowired final JwtDecoder jwtDecoder;
  @Autowired final JwtAuthenticationConverter jwtAuthenticationConverter;

  public VerifyConnectInterceptor(
      JwtDecoder jwtDecoder, JwtAuthenticationConverter jwtAuthenticationConverter) {
    this.jwtDecoder = jwtDecoder;
    this.jwtAuthenticationConverter = jwtAuthenticationConverter;
  }

  @Override
  public Message<?> preSend(@NonNull Message<?> message, @NonNull MessageChannel channel) {
    StompHeaderAccessor accessor =
        MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
    if (accessor != null && StompCommand.CONNECT.equals(accessor.getCommand())) {
      List<String> authorization = accessor.getNativeHeader("Authorization");
      if (authorization != null) {
        try {
          String accessToken = authorization.get(0).split(" ")[1];
          Jwt jwt = jwtDecoder.decode(accessToken);
          Authentication authentication = jwtAuthenticationConverter.convert(jwt);
          accessor.setUser(authentication);
        } catch (Exception e) {
          log.info(e);
        }

      } else {
        log.info("No authentication found");
      }
    }

    return message;
  }
}
