/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.helpers.ModelChecker;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public class EntityService {
    private final Repositories repositories;

    public EntityService(WebApplicationContext webApplicationContext) {
        this.repositories = new Repositories((ListableBeanFactory)webApplicationContext);
    }

    public <T> Optional<T> safeCreate(Class<T> tClass, T entity, ModelProvider ... modelProviders) {
        if (!ModelChecker.inSameModel(modelProviders)) {
            return Optional.empty();
        }
        return Optional.of(this.create(tClass, entity));
    }

    public <T> Optional<T> safeUpdate(Class<T> tClass, T entity, T oldEntity, ModelProvider ... modelProviders) {
        if (!ModelChecker.inSameModel(modelProviders)) {
            return Optional.empty();
        }
        return Optional.of(this.update(tClass, entity));
    }

    public <T> Optional<T> safeDelete(Class<T> tClass, T entity, ModelProvider ... modelProviders) {
        return this.safeDelete(tClass, entity, (Runnable)null, modelProviders);
    }

    public <T> Optional<T> safeDelete(Class<T> tClass, T entity, Runnable sideEffect, ModelProvider ... modelProviders) {
        if (!ModelChecker.inSameModel(modelProviders)) {
            return Optional.empty();
        }
        T delete = this.delete(tClass, entity);
        if (sideEffect != null) {
            sideEffect.run();
        }
        return Optional.of(delete);
    }

    public <T> T create(Class<T> tClass, T entity) {
        return (T)this.handleEntity(tClass, repository -> repository.save(entity));
    }

    public <T> T update(Class<T> tClass, T updatedEntity) {
        return (T)this.handleEntity(tClass, repository -> repository.save(updatedEntity));
    }

    public <T> Iterable<T> updateAll(Class<T> tClass, Iterable<Pair<T, T>> updatedEntities) {
        return this.repositories.getRepositoryFor(tClass).map(repository -> {
            CrudRepository rep = (CrudRepository)repository;
            ArrayList updatedEntitiesReturn = new ArrayList();
            updatedEntities.forEach(ttPair -> updatedEntitiesReturn.add(rep.save(ttPair.getSecond())));
            return updatedEntitiesReturn;
        }).orElseThrow(() -> new IllegalArgumentException("Could not get repository for class: " + String.valueOf(tClass)));
    }

    public <T> T delete(Class<T> tClass, T entity) {
        this.handleEntity(tClass, repository -> {
            repository.delete(entity);
            return entity;
        });
        return entity;
    }

    private <T> T handleEntity(Class<T> tClass, Function<JpaRepository<T, Long>, T> consumer) {
        return (T)this.repositories.getRepositoryFor(tClass).map(repository -> consumer.apply((JpaRepository)repository)).orElseThrow(() -> new IllegalArgumentException("Could not get repository for class: " + String.valueOf(tClass)));
    }
}

