/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers.stompInterceptors;

import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import app.valuationcontrol.multimodule.library.helpers.security.MyUserPrincipal;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import java.security.Principal;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

public class TopicSubscriptionInterceptor
implements ChannelInterceptor {
    private static final Logger log = LogManager.getLogger(TopicSubscriptionInterceptor.class);
    public static final String TOPIC_MODEL = "/topic/model/";
    public final String TOPIC_CHANGELOG = "/topic/changelog/";
    final String REGEX = "(\\/topic\\/model\\/|\\/topic\\/changelog\\/)([0-9]*)((\\/)([0-9]*))?";
    final String[] topicsRequiringValidation = new String[]{"/topic/model/", "/topic/changelog/"};
    final String[] otherTopics = new String[]{"/user/topic/errors"};

    public Message<?> preSend(@NonNull Message<?> message, @NonNull MessageChannel channel) {
        StompHeaderAccessor headerAccessor = StompHeaderAccessor.wrap(message);
        if (StompCommand.SUBSCRIBE.equals((Object)headerAccessor.getCommand())) {
            log.debug("Checking " + String.valueOf(headerAccessor.getCommand()) + " -> " + headerAccessor.getDestination());
            if (Arrays.stream(this.topicsRequiringValidation).anyMatch(topic -> Objects.requireNonNull(headerAccessor.getDestination()).contains((CharSequence)topic))) {
                Principal userPrincipal = headerAccessor.getUser();
                log.debug((Object)userPrincipal);
                try {
                    assert (userPrincipal != null);
                    MyUserPrincipal mp = (MyUserPrincipal)((UsernamePasswordAuthenticationToken)userPrincipal).getPrincipal();
                    log.debug(mp.getUsername());
                    Pattern pattern = Pattern.compile("(\\/topic\\/model\\/|\\/topic\\/changelog\\/)([0-9]*)((\\/)([0-9]*))?");
                    Matcher matcher = pattern.matcher(headerAccessor.getDestination());
                    long modelId = 0L;
                    if (matcher.find()) {
                        modelId = Long.parseLong(matcher.group(2));
                        if (matcher.groupCount() > 3 && matcher.group(3) != null) {
                            int scenarioNumber = Integer.parseInt(matcher.group(5));
                            SCENARIO.from(scenarioNumber);
                        }
                    }
                    if (modelId <= 0L || !mp.hasModelRole(modelId, "READER").booleanValue()) {
                        throw new IllegalArgumentException("No permission for this topic");
                    }
                    log.debug("Successful subscription");
                }
                catch (NumberFormatException e) {
                    log.debug((Object)e);
                    throw new ResourceException(HttpStatus.BAD_REQUEST, "Unable to find the model to subscribe to");
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    throw new IllegalArgumentException("No permission for this topic");
                }
            } else if (Arrays.stream(this.otherTopics).noneMatch(topic -> Objects.requireNonNull(headerAccessor.getDestination()).contains((CharSequence)topic))) {
                log.debug("Requested subscription " + headerAccessor.getDestination() + " is not recognized by the topic interceptor");
                throw new IllegalArgumentException("Requested topic does not exits");
            }
        }
        return message;
    }
}

