/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.entities.Area;
import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.helpers.DataPeriod;
import app.valuationcontrol.multimodule.library.xlhandler.GenericSheet;

public class CellValueHelper {
    public static final int AZ_COUNTER = 26;

    public static GenericSheet.CellValue cellValueOf(VariableValue variableValue) {
        Variable variable = variableValue.getAttachedVariable();
        int columnIndex = variable.columnOfSegmentAndPeriod(variableValue.getAttachedSegment(), variableValue.getPeriod());
        return new GenericSheet.CellValue(variableValue.getValue().floatValue(), columnIndex, variable.getRow());
    }

    public static String generateAddress(Variable variable, DataPeriod dataPeriod) {
        int columnToAssess = variable.isSingleOrConstantValue() ? variable.getAttachedModel().getConstantColumn() + dataPeriod.getSegmentOffsetAsInteger() : variable.getPrimaryColumn() + dataPeriod.getTotalOffsetAsInteger();
        return CellValueHelper.generateAddress(variable, columnToAssess);
    }

    public static String getAreaSheetNameWithQuotes(Area area) {
        Model attachedModel = area.getAttachedModel();
        return "'" + attachedModel.getAreaStringHashMap().get(area) + "'";
    }

    public static String getExcelColumn(int columnToAssess) {
        String prefix = new String();
        int multiplier = columnToAssess / 26;
        int rest = columnToAssess % 26;
        if (multiplier >= 1) {
            prefix = Character.toString((char)(65 + multiplier - 1));
        }
        String column = prefix + (char)(65 + rest);
        return column;
    }

    private static String generateAddress(Variable variable, int columnToAssess) {
        String column = CellValueHelper.getExcelColumn(columnToAssess);
        int rowToAssess = 1 + variable.getRow();
        String returnString = variable.isSingleOrConstantValue() ? "$" + column + "$" + rowToAssess : column + rowToAssess;
        if (variable.getAttachedModel().getUseAreaAddress().booleanValue()) {
            returnString = CellValueHelper.getAreaSheetNameWithQuotes(variable.getVariableArea()) + "!" + returnString;
        }
        return returnString;
    }
}

