/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Area;
import app.valuationcontrol.multimodule.library.entities.KeyParam;
import app.valuationcontrol.multimodule.library.entities.LogEntry;
import app.valuationcontrol.multimodule.library.entities.ModelGraph;
import app.valuationcontrol.multimodule.library.entities.Segment;
import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import app.valuationcontrol.multimodule.library.records.ModelData;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.annotations.ColumnDefault;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;

@Entity
public class Model
implements DataTransformer<ModelData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    Long templateId = -1L;
    private String name;
    private Integer startYear;
    private Integer nbHistoricalPeriod;
    private Integer nbProjectionPeriod;
    private String company;
    private String companyNumber;
    private String currency;
    private String simpleModel;
    @ColumnDefault(value="false")
    private boolean locked;
    @ColumnDefault(value="false")
    private boolean includeYTD;
    @Embedded
    private KeyParam keyParam;
    @OneToMany(mappedBy="attachedModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id ASC")
    private final List<Variable> variables = new ArrayList<Variable>();
    @OneToMany(mappedBy="attachedModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<LogEntry> logEntries = new ArrayList<LogEntry>();
    @OneToMany(mappedBy="attachedModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id ASC")
    private final List<Segment> segments = new ArrayList<Segment>();
    @OneToMany(mappedBy="attachedModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="areaOrder ASC")
    private final List<Area> areas = new ArrayList<Area>();
    @OneToMany(mappedBy="attachedModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<ModelGraph> graphs = new ArrayList<ModelGraph>();
    @OneToMany(mappedBy="attachedModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<Sensitivity> sensitivities = new ArrayList<Sensitivity>();
    @Transient
    private Integer colBeforeDataStart = 10;
    @Transient
    private Boolean useAreaAddress = false;
    @Transient
    private final HashMap<Area, String> areaStringHashMap = new HashMap();

    public Model(String modelName, Integer numberOfHistoricalPeriods, Integer numberOfProjectionPeriod) {
        this.name = modelName;
        this.setNbHistoricalPeriod(numberOfHistoricalPeriods);
        this.setNbProjectionPeriod(numberOfProjectionPeriod);
    }

    public Model(ModelData modelData) {
        this.name = modelData.name();
        this.currency = modelData.currency();
        this.company = modelData.company();
        this.companyNumber = modelData.companyNumber();
        this.nbProjectionPeriod = modelData.nbProjectionPeriod();
        this.nbHistoricalPeriod = modelData.nbHistoricalPeriod();
        this.startYear = modelData.startYear();
        this.keyParam = modelData.keyParam();
        this.includeYTD = modelData.includeYTD();
    }

    public Model() {
    }

    public Integer getArraySize() {
        int metadataSize = this.getConstantColumn();
        int dataSize = this.getNumberOfPeriodsAndValue() * (this.getSegments().size() + 1);
        return metadataSize + dataSize;
    }

    public int indexOfLastColumn() {
        int segmentColumnOffset = this.getNumberOfPeriodsAndValue();
        return this.getTotalNumberOfColumns(true) + this.getSegments().size() * segmentColumnOffset;
    }

    public int getConstantColumn() {
        return this.colBeforeDataStart - 1;
    }

    public void setUseAreaAddress(boolean useAreaAddress) {
        if (useAreaAddress) {
            this.colBeforeDataStart = 4;
            this.getAreaStringHashMap().clear();
            this.getAreas().forEach(area -> {
                String randomString = RandomStringUtils.randomAlphanumeric((int)8);
                this.getAreaStringHashMap().put((Area)area, randomString);
                area.getSubAreas().sort(Comparator.comparingInt(sa -> Objects.requireNonNullElse(sa.getSubAreaOrder(), 1)));
            });
            this.getVariables().sort(Comparator.comparingInt(v -> Objects.requireNonNullElse(v.getVariableOrder(), 1)));
            this.getVariables().sort(Comparator.comparingInt(v -> Objects.requireNonNullElse(v.getVariableSubArea().getSubAreaOrder(), 1)));
        } else {
            this.getVariables().sort(Comparator.comparingLong(Variable::getId));
        }
        this.useAreaAddress = useAreaAddress;
    }

    public Integer getFirstProjectionColumn() {
        return this.colBeforeDataStart + this.nbHistoricalPeriod;
    }

    public int getTotalNumberOfColumns(boolean startingAtZero) {
        if (startingAtZero) {
            return this.colBeforeDataStart + this.getNumberOfPeriodsAndValue() - 2;
        }
        return this.colBeforeDataStart + this.getNumberOfPeriodsAndValue() - 1;
    }

    public int getNumberOfPeriodsAndValue() {
        int nbAdditionalValues = 1;
        if (this.includeYTD) {
            nbAdditionalValues = 3;
        }
        return this.nbHistoricalPeriod + this.nbProjectionPeriod + nbAdditionalValues;
    }

    public int getNumberOfVariables() {
        return this.getVariables().size();
    }

    public Integer getMaxVariableOrder() {
        return this.getVariables().stream().map(Variable::getVariableOrder).filter(Objects::nonNull).max(Integer::compareTo).orElse(0);
    }

    public Optional<Variable> getVariableWithID(long variableId) {
        return this.getVariables().stream().filter(existingVariable -> existingVariable.getId() == variableId).findFirst();
    }

    @Override
    public ModelData asData() {
        KeyParam keyParamCopy = new KeyParam();
        keyParamCopy.copyFromExisting(this.getKeyParam(), this);
        keyParamCopy.setKeyOutput1Period(Sensitivity.asModelYear(this.getKeyParam() != null ? this.getKeyParam().getKeyOutput1Period() : null, this));
        keyParamCopy.setKeyOutput2Period(Sensitivity.asModelYear(this.getKeyParam() != null ? this.getKeyParam().getKeyOutput2Period() : null, this));
        keyParamCopy.setKeyParam1Period(Sensitivity.asModelYear(this.getKeyParam() != null ? this.getKeyParam().getKeyParam1Period() : null, this));
        keyParamCopy.setKeyParam2Period(Sensitivity.asModelYear(this.getKeyParam() != null ? this.getKeyParam().getKeyParam2Period() : null, this));
        keyParamCopy.setKeyParam3Period(Sensitivity.asModelYear(this.getKeyParam() != null ? this.getKeyParam().getKeyParam3Period() : null, this));
        keyParamCopy.setKeyParam4Period(Sensitivity.asModelYear(this.getKeyParam() != null ? this.getKeyParam().getKeyParam4Period() : null, this));
        return new ModelData(this.id, this.name, this.startYear, this.nbHistoricalPeriod, this.nbProjectionPeriod, this.company, this.companyNumber, this.currency, this.simpleModel, this.locked, this.includeYTD, keyParamCopy);
    }

    @Override
    public Long getModelId() {
        return this.getId();
    }

    public void forceModelId(Long modelId) {
        this.id = modelId;
    }

    public Set<Long> getKeyVariablesForModel() {
        HashSet<Long> ids = new HashSet<Long>();
        if (this.getKeyParam() != null) {
            if (this.getKeyParam().getKeyOutput1Id() != null) {
                ids.add(this.getKeyParam().getKeyOutput1Id());
            }
            if (this.getKeyParam().getKeyOutput2Id() != null) {
                ids.add(this.getKeyParam().getKeyOutput2Id());
            }
            if (this.getKeyParam().getKeyParam1Id() != null) {
                ids.add(this.getKeyParam().getKeyParam1Id());
            }
            if (this.getKeyParam().getKeyParam2Id() != null) {
                ids.add(this.getKeyParam().getKeyParam2Id());
            }
            if (this.getKeyParam().getKeyParam3Id() != null) {
                ids.add(this.getKeyParam().getKeyParam3Id());
            }
            if (this.getKeyParam().getKeyParam4Id() != null) {
                ids.add(this.getKeyParam().getKeyParam4Id());
            }
        }
        this.getGraphs().forEach(modelGraph -> {
            if (modelGraph.getGraphVariable1Id() != null) {
                ids.add(modelGraph.getGraphVariable1Id());
            }
            if (modelGraph.getGraphVariable2Id() != null) {
                ids.add(modelGraph.getGraphVariable2Id());
            }
            if (modelGraph.getGraphVariable3Id() != null) {
                ids.add(modelGraph.getGraphVariable3Id());
            }
        });
        this.getSensitivities().forEach(sensitivity -> {
            if (sensitivity.getSensitivityMeasurementVariableId() != null) {
                ids.add(sensitivity.getSensitivityMeasurementVariableId());
            }
            if (sensitivity.getSensitivityVariable1Id() != null) {
                ids.add(sensitivity.getSensitivityVariable1Id());
            }
            if (sensitivity.getSensitivityVariable2Id() != null) {
                ids.add(sensitivity.getSensitivityVariable2Id());
            }
        });
        this.getVariables().stream().filter(variable -> variable.getVariableValues() != null && variable.getVariableValues().stream().anyMatch(variableValue -> variableValue.getScenarioNumber() > 0)).forEach(variable -> ids.add(variable.getId()));
        return ids.stream().filter(aLong -> aLong > -1L).collect(Collectors.toSet());
    }

    public Long getId() {
        return this.id;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStartYear() {
        return this.startYear;
    }

    public Integer getNbHistoricalPeriod() {
        return this.nbHistoricalPeriod;
    }

    public Integer getNbProjectionPeriod() {
        return this.nbProjectionPeriod;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getSimpleModel() {
        return this.simpleModel;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isIncludeYTD() {
        return this.includeYTD;
    }

    public KeyParam getKeyParam() {
        return this.keyParam;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public List<ModelGraph> getGraphs() {
        return this.graphs;
    }

    public List<Sensitivity> getSensitivities() {
        return this.sensitivities;
    }

    public Integer getColBeforeDataStart() {
        return this.colBeforeDataStart;
    }

    public Boolean getUseAreaAddress() {
        return this.useAreaAddress;
    }

    public HashMap<Area, String> getAreaStringHashMap() {
        return this.areaStringHashMap;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStartYear(Integer startYear) {
        this.startYear = startYear;
    }

    public void setNbHistoricalPeriod(Integer nbHistoricalPeriod) {
        this.nbHistoricalPeriod = nbHistoricalPeriod;
    }

    public void setNbProjectionPeriod(Integer nbProjectionPeriod) {
        this.nbProjectionPeriod = nbProjectionPeriod;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setSimpleModel(String simpleModel) {
        this.simpleModel = simpleModel;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setIncludeYTD(boolean includeYTD) {
        this.includeYTD = includeYTD;
    }

    public void setKeyParam(KeyParam keyParam) {
        this.keyParam = keyParam;
    }
}

