/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers.poiudf;

import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.usermodel.DateUtil;

public final class DateDif
implements Function {
    private static final Logger log = LogManager.getLogger(DateDif.class);

    public ValueEval evaluate(ValueEval[] valueEvals, int srcCellRow, int srcCellCol) {
        if (valueEvals.length != 3) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval v1 = OperandResolver.getSingleValue((ValueEval)valueEvals[0], (int)srcCellRow, (int)srcCellCol);
            ValueEval v2 = OperandResolver.getSingleValue((ValueEval)valueEvals[1], (int)srcCellRow, (int)srcCellCol);
            double startDate = OperandResolver.coerceValueToDouble((ValueEval)v1);
            double endDate = OperandResolver.coerceValueToDouble((ValueEval)v2);
            String unit = OperandResolver.coerceValueToString((ValueEval)valueEvals[2]);
            Instant javaStartDate = DateUtil.getJavaDate((double)startDate).toInstant();
            Instant javaEndDate = DateUtil.getJavaDate((double)endDate).toInstant();
            Period period = Period.between(javaStartDate.atZone(ZoneId.systemDefault()).toLocalDate(), javaEndDate.atZone(ZoneId.systemDefault()).toLocalDate());
            return switch (unit) {
                case "y" -> new NumberEval((double)period.getYears());
                case "m" -> new NumberEval((double)(period.getYears() * 12 + period.getMonths()));
                case "d" -> new NumberEval((double)ChronoUnit.DAYS.between(javaStartDate, javaEndDate));
                default -> new NumberEval((double)ChronoUnit.YEARS.between(javaStartDate, javaEndDate));
            };
        }
        catch (FormulaParseException | EvaluationException e) {
            return ErrorEval.REF_INVALID;
        }
    }
}

