/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.lang.NonNull;

public class MyCustomFloatEditor
extends CustomNumberEditor {
    private static final Logger log = LogManager.getLogger(MyCustomFloatEditor.class);
    public static final NumberFormat PERCENT_INSTANCE = NumberFormat.getPercentInstance(Locale.US);
    private static final String CHARACTERS = ".*[a-zA-Z].*";
    private static final Pattern PATTERN = Pattern.compile(".*[a-zA-Z].*");

    public MyCustomFloatEditor(Class<? extends Number> numberClass, boolean allowEmpty) throws IllegalArgumentException {
        super(numberClass, allowEmpty);
    }

    public void setAsText(@NonNull String text) throws IllegalArgumentException {
        if ((text = text.replace(",", ".")).contains("%") && this.textHasNoCharacters(text)) {
            try {
                super.setAsText(String.valueOf(PERCENT_INSTANCE.parse(text)));
            }
            catch (ParseException e) {
                log.debug((Object)e);
                throw new IllegalArgumentException();
            }
        } else {
            super.setAsText(text);
        }
    }

    private boolean textHasNoCharacters(String text) {
        return !PATTERN.matcher(text).matches();
    }
}

