/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import app.valuationcontrol.multimodule.library.xlhandler.CalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.GenericSheet;
import app.valuationcontrol.multimodule.library.xlhandler.POISheet;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontScheme;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POICalcDocument
implements CalcDocument {
    private static final Logger log = LogManager.getLogger(POICalcDocument.class);
    public static final String NUMBER_FORMAT = "#,##0.0;(#,##0.0)";
    public static final String PERCENTAGE_FORMAT = "#,##0.0%;(#,##0.0)%";
    public static final String DATE_FORMAT = "DD.MM.YYYY";
    private static final String SCENARIO_SHEET_PREFIX = "scenario_";
    private final Map<String, GenericSheet> sheetsByName = new ConcurrentHashMap<String, GenericSheet>();
    private final HashMap<String, XSSFCellStyle> stylesMap = new HashMap();
    protected XSSFWorkbook _notAccessibleWorkbook;
    private XSSFDataFormat decimalFormat;
    private XSSFDataFormat percentFormat;
    private XSSFDataFormat dateFormat;

    public POICalcDocument() {
        this.initiateWorkbook();
    }

    private XSSFCellStyle addStyleTosStylesMap(String variableType, String format, boolean isValue) {
        XSSFCellStyle style = this._notAccessibleWorkbook.createCellStyle();
        style.cloneStyleFrom((CellStyle)this._notAccessibleWorkbook.getCellStyleAt(0));
        int fontIndex = 0;
        if (variableType.contains("total") || variableType.contains("header")) {
            fontIndex = 1;
            if (variableType.contains("total")) {
                style.setBorderBottom(BorderStyle.DOUBLE);
            }
        } else if (variableType.equals("kpi")) {
            fontIndex = 2;
        } else if (variableType.contains("input") && isValue) {
            fontIndex = 4;
        }
        XSSFFont font = this._notAccessibleWorkbook.getFontAt(fontIndex);
        style.setFont((Font)font);
        if (isValue) {
            style.setDataFormat((short)1);
            if (format.equals("percent")) {
                style.setDataFormat((short)2);
            }
            if (format.equals("date")) {
                style.setDataFormat((short)3);
            }
            if (variableType.contains("input")) {
                style.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setBorderBottom(BorderStyle.THIN);
                style.setBorderTop(BorderStyle.THIN);
                style.setBorderLeft(BorderStyle.THIN);
                style.setBorderRight(BorderStyle.THIN);
            }
        }
        return style;
    }

    public XSSFCellStyle getStyle(String variableType, String format, boolean isValue) {
        return this.stylesMap.computeIfAbsent(variableType + "_" + format + "_" + isValue, style -> this.addStyleTosStylesMap(variableType, format, isValue));
    }

    private synchronized void initiateWorkbook() {
        this.sheetsByName.clear();
        this._notAccessibleWorkbook = new XSSFWorkbook();
        XSSFFont font = this._notAccessibleWorkbook.getFontAt(0);
        font.setFontHeightInPoints((short)8);
        font.setFontName("Arial");
        font.setFamily(3);
        font.setScheme(FontScheme.NONE);
        font.setItalic(false);
        font.setBold(false);
        XSSFFont fontBold = this._notAccessibleWorkbook.createFont();
        fontBold.setFontHeightInPoints((short)8);
        fontBold.setFontName("Arial");
        fontBold.setFamily(3);
        fontBold.setScheme(FontScheme.NONE);
        fontBold.setItalic(false);
        fontBold.setBold(true);
        XSSFFont fontItalic = this._notAccessibleWorkbook.createFont();
        fontItalic.setFontHeightInPoints((short)8);
        fontItalic.setFontName("Arial");
        fontItalic.setFamily(3);
        fontItalic.setScheme(FontScheme.NONE);
        fontItalic.setItalic(true);
        fontItalic.setBold(false);
        XSSFFont fontBoldUnderline = this._notAccessibleWorkbook.createFont();
        fontBoldUnderline.setFontHeightInPoints((short)8);
        fontBoldUnderline.setFontName("Arial");
        fontBoldUnderline.setFamily(3);
        fontBoldUnderline.setScheme(FontScheme.NONE);
        fontBoldUnderline.setItalic(false);
        fontBoldUnderline.setBold(true);
        fontBoldUnderline.setUnderline(FontUnderline.SINGLE);
        XSSFFont fontInput = this._notAccessibleWorkbook.createFont();
        fontInput.setFontHeightInPoints((short)8);
        fontInput.setFontName("Arial");
        fontInput.setFamily(3);
        fontInput.setScheme(FontScheme.NONE);
        fontInput.setItalic(false);
        fontInput.setBold(false);
        fontInput.setColor(IndexedColors.BLUE.getIndex());
        this.decimalFormat = this._notAccessibleWorkbook.createDataFormat();
        this.decimalFormat.putFormat((short)1, NUMBER_FORMAT);
        this.decimalFormat.putFormat((short)2, PERCENTAGE_FORMAT);
        this.decimalFormat.putFormat((short)3, DATE_FORMAT);
        XSSFCellStyle style = this._notAccessibleWorkbook.getCellStyleAt(0);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(false);
        this._notAccessibleWorkbook.getStylesSource().getCTStylesheet().addNewCellStyles().addNewCellStyle().setXfId(0L);
    }

    private synchronized <T> T doOneByOne(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception exception) {
            this.initiateWorkbook();
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private synchronized XSSFWorkbook getWorkbook() {
        return this._notAccessibleWorkbook;
    }

    public static String getScenarioSheetName(SCENARIO scenario) throws IllegalArgumentException {
        if (scenario != null) {
            return SCENARIO_SHEET_PREFIX + scenario.ordinal();
        }
        throw new IllegalArgumentException("Cannot produce sheetname since scenarioNumber = null");
    }

    @Override
    public void assertConnected(Runnable resetData) {
        this.doOneByOne(() -> {
            try {
                if (this._notAccessibleWorkbook == null) {
                    throw new RuntimeException("Spreadsheet pointer is null");
                }
                XSSFSheet sheet = this.getWorkbook().getSheet(POICalcDocument.getScenarioSheetName(SCENARIO.BASE));
                log.debug("Found in assertConnected for scenario sheet : " + sheet.getSheetName());
                if (sheet.getPhysicalNumberOfRows() == 0) {
                    throw new RuntimeException("Number of rows is nil so we reload");
                }
            }
            catch (Exception e) {
                log.debug("NOT Found in assertConnected");
                log.debug((Object)e);
                this.initiateWorkbook();
                resetData.run();
            }
            return null;
        });
    }

    @Override
    public GenericSheet getSheet(SCENARIO scenario) {
        String scenarioSheetName = POICalcDocument.getScenarioSheetName(scenario);
        return this.sheetsByName.computeIfAbsent(scenarioSheetName, s -> this.copyBaseTo(scenario));
    }

    @Override
    public GenericSheet createPrettySheet(String name) {
        return new POISheet(name, this.getWorkbook().createSheet(name));
    }

    @Override
    public void preventScreenUpdating(boolean prevent) {
        log.debug((Object)prevent);
    }

    @Override
    public void close() {
        this.doOneByOne(() -> {
            if (this._notAccessibleWorkbook == null) {
                log.debug("Workbook was null");
                return null;
            }
            try {
                log.debug("Closing workbook");
                this.getWorkbook().close();
                this._notAccessibleWorkbook = null;
                this.sheetsByName.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    @Override
    public InputStream saveAs() {
        try {
            ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
            this.getWorkbook().write((OutputStream)outputStream1);
            return new ByteArrayInputStream(outputStream1.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(GenericSheet genericSheet) {
        this.doOneByOne(() -> {
            this.sheetsByName.remove(genericSheet.getName());
            this.getWorkbook().getSheetIndex(genericSheet.getName());
            this.getWorkbook().removeSheetAt(this.getWorkbook().getSheetIndex(genericSheet.getName()));
            return null;
        });
    }

    @Override
    public GenericSheet copy(GenericSheet sourceGenericSheet, String newSheetName) {
        return this.doOneByOne(() -> {
            XSSFSheet sourceSheet = this.getWorkbook().getSheet(sourceGenericSheet.getName());
            if (sourceSheet != null) {
                int sourceGenericSheetIndex = this.getWorkbook().getSheetIndex(sourceSheet.getSheetName());
                XSSFSheet _newSheet = this.getWorkbook().cloneSheet(sourceGenericSheetIndex, newSheetName);
                POISheet genericSheet = new POISheet(newSheetName, _newSheet);
                this.sheetsByName.put(newSheetName, genericSheet);
                log.info("Copied sheet successfully to {}", (Object)newSheetName);
                return genericSheet;
            }
            return null;
        });
    }

    private GenericSheet copyBaseTo(SCENARIO scenario) {
        String scenarioSheetName = POICalcDocument.getScenarioSheetName(scenario);
        return this.doOneByOne(() -> {
            block7: {
                if (SCENARIO.BASE.equals((Object)scenario)) {
                    try {
                        if (this.getWorkbook().getSheet(scenarioSheetName) == null) {
                            this.getWorkbook().createSheet(scenarioSheetName);
                            break block7;
                        }
                        this.getWorkbook().removeSheetAt(this.getSheetIndexByName(scenarioSheetName));
                        this.getWorkbook().createSheet(scenarioSheetName);
                    }
                    catch (ResourceException e) {
                        log.error("Wrapped target exception: ", (Throwable)e);
                    }
                } else {
                    try {
                        this.getSheetIndexByName(scenarioSheetName);
                    }
                    catch (IllegalStateException e) {
                        this.getWorkbook().cloneSheet(this.getSheetIndexByName(POICalcDocument.getScenarioSheetName(SCENARIO.BASE)), scenarioSheetName);
                    }
                }
            }
            XSSFSheet byName = this.getWorkbook().getSheet(scenarioSheetName);
            return new POISheet(scenarioSheetName, byName);
        });
    }

    private int getSheetIndexByName(String sheetName) throws IllegalStateException {
        int sheetIndex = this.getWorkbook().getSheetIndex(sheetName);
        if (sheetIndex == -1) {
            throw new IllegalStateException("Sheet was not found");
        }
        return sheetIndex;
    }

    @Override
    public void closeAllButBase() {
        this.doOneByOne(() -> {
            Iterator<Map.Entry<String, GenericSheet>> iterator = this.sheetsByName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, GenericSheet> next = iterator.next();
                if (POICalcDocument.getScenarioSheetName(SCENARIO.BASE).equals(next.getKey())) continue;
                iterator.remove();
                this.getWorkbook().removeSheetAt(this.getWorkbook().getSheetIndex(next.getValue().getName()));
            }
            return null;
        });
    }

    @Override
    public void closeAllSheets() {
        this.doOneByOne(() -> {
            this.initiateWorkbook();
            return null;
        });
    }
}

