/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.helpers.CellError;
import app.valuationcontrol.multimodule.library.helpers.DataPeriod;
import app.valuationcontrol.multimodule.library.helpers.StringReplacer;
import app.valuationcontrol.multimodule.library.helpers.VariableReplacementOccurrence;
import app.valuationcontrol.multimodule.library.xlhandler.CellValueHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableEvaluator {
    @Generated
    private static final Logger log = LogManager.getLogger(VariableEvaluator.class);
    private static final String CONVERGE_TO_GROUPS = "(convergeto\\()(.+)(\\))";
    public static final String EQUALS = "=";
    private static final String REGEX_STRING_INTERVAL = "t[\\-|\\+]?\\d*";
    private static final String ALL_PERIODS = "allperiods";
    private static final String HISTORICAL_PERIOD = "historicalperiod";
    private static final String PROJECTION_PERIOD = "projectionperiod";
    private static final String LAST_PERIOD = "lastperiod";
    private static final String FIRST_PERIOD = "firstperiod";
    private static final Pattern PATTERN = Pattern.compile("t[\\-|\\+]?\\d*");
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_CURLY = "{";
    private static final String RIGHT_CURLY = "}";
    public static final int AGGREGATION_SEGMENT = -1;
    private static final String[] PREDEFINED_MODIFIERS = new String[]{"allperiods", "historicalperiod", "projectionperiod", "lastperiod", "firstperiod"};

    private VariableEvaluator() {
    }

    public static String evaluateVariable(Variable variable, DataPeriod dataPeriod, Map<Long, List<CellError>> formulaErrors) {
        String currentEvaluatedFormula = variable.getEvaluatedVariableFormula();
        try {
            Double.parseDouble(currentEvaluatedFormula);
            return VariableEvaluator.asFormula(currentEvaluatedFormula);
        }
        catch (Exception exception) {
            if (currentEvaluatedFormula.toLowerCase().matches(CONVERGE_TO_GROUPS)) {
                currentEvaluatedFormula = VariableEvaluator.makeConvergeFunction(variable, dataPeriod, currentEvaluatedFormula);
            }
            currentEvaluatedFormula = VariableEvaluator.replacePeriodIndicatorsAndPeriodChecks(variable, dataPeriod, currentEvaluatedFormula);
            if (variable.getReplacementOccurrences().isEmpty()) {
                VariableEvaluator.evaluateVariableReplacers(variable, formulaErrors);
            }
            if (variable.getReplacementOccurrences() == null || variable.getReplacementOccurrences().isEmpty()) {
                return VariableEvaluator.asFormula(currentEvaluatedFormula);
            }
            for (VariableReplacementOccurrence variableReplacement : variable.getReplacementOccurrences()) {
                currentEvaluatedFormula = VariableEvaluator.replace(currentEvaluatedFormula, VariableEvaluator.getReplacementString(variable, dataPeriod, variableReplacement, formulaErrors), variableReplacement);
            }
            return VariableEvaluator.asFormula(currentEvaluatedFormula);
        }
    }

    private static String replace(String formula, String replacementString, VariableReplacementOccurrence variableReplacement) {
        return formula.replace(variableReplacement.searchString(), replacementString);
    }

    static String asFormula(String currentEvaluatedFormula) {
        return EQUALS + currentEvaluatedFormula;
    }

    private static String getReplacementString(Variable variable, DataPeriod dataPeriod, VariableReplacementOccurrence variableReplacement, Map<Long, List<CellError>> formulaErrors) {
        String replacementString = variableReplacement.searchString();
        String prefixSearchString = LEFT_CURLY + variableReplacement.searchVariable().getId() + RIGHT_CURLY;
        String targetReplacementString = replacementString.substring(prefixSearchString.length());
        if (!variableReplacement.searchVariable().isModelledAtSegment()) {
            dataPeriod = new DataPeriod(variable.getAttachedModel(), dataPeriod.periodOffset(), 0, variableReplacement.searchVariable().isSingleOrConstantValue());
        }
        for (StringReplacer myReplacer : variableReplacement.stringReplacers()) {
            if (myReplacer.modifier() == null) {
                targetReplacementString = switch (myReplacer.searchString()) {
                    case ALL_PERIODS -> variableReplacement.searchVariable().generateAllPeriodsRange(dataPeriod);
                    case HISTORICAL_PERIOD -> variableReplacement.searchVariable().generateHistoricalRange(dataPeriod);
                    case PROJECTION_PERIOD -> variableReplacement.searchVariable().generateProjectionRange(dataPeriod);
                    case FIRST_PERIOD -> variableReplacement.searchVariable().generateFirstPeriodRange(dataPeriod);
                    case LAST_PERIOD -> variableReplacement.searchVariable().generateLastPeriodRange(dataPeriod);
                    default -> CellValueHelper.generateAddress(variableReplacement.searchVariable(), dataPeriod);
                };
                continue;
            }
            if (dataPeriod.isWithinBound(dataPeriod.periodOffset() + myReplacer.modifier())) {
                DataPeriod newDataPeriod = new DataPeriod(variable.getAttachedModel(), myReplacer.modifier() + dataPeriod.periodOffset(), dataPeriod.segmentOffsetFactor(), variableReplacement.searchVariable().isSingleOrConstantValue());
                String addressReplacementString = CellValueHelper.generateAddress(variableReplacement.searchVariable(), newDataPeriod);
                targetReplacementString = targetReplacementString.replace(myReplacer.searchString(), addressReplacementString);
                targetReplacementString = targetReplacementString.replace(LEFT_BRACKET, "").replace(RIGHT_BRACKET, "");
                continue;
            }
            targetReplacementString = "-1";
            CellError e = new CellError(dataPeriod.periodOffset(), "OutOfBounds error", "You are trying to access an unsafe area using " + myReplacer.searchString() + " in formula " + variable.getVariableFormula());
            formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
        }
        return targetReplacementString;
    }

    private static String replacePeriodIndicatorsAndPeriodChecks(Variable myVariable, DataPeriod dataPeriod, String currentEvaluatedFormula) {
        currentEvaluatedFormula = currentEvaluatedFormula.replace("periodindicator", Integer.toString(dataPeriod.periodOffset() + 1));
        currentEvaluatedFormula = currentEvaluatedFormula.replace("islastperiod", dataPeriod.periodOffset() + 1 == myVariable.getAttachedModel().getNbProjectionPeriod() ? "1" : "0");
        currentEvaluatedFormula = currentEvaluatedFormula.replace("isfirstperiod", dataPeriod.periodOffset() == 0 ? "1" : "0");
        return currentEvaluatedFormula;
    }

    private static String makeConvergeFunction(Variable variable, DataPeriod dataPeriod, String originalFormula) {
        String target;
        int remainingPeriod = variable.getAttachedModel().getNbProjectionPeriod() - dataPeriod.periodOffset();
        String previousCellAddress = CellValueHelper.generateAddress(variable, dataPeriod.previousPeriod());
        Pattern p = Pattern.compile(CONVERGE_TO_GROUPS);
        Matcher m = p.matcher(originalFormula);
        if (m.find()) {
            target = m.group(2);
        } else {
            target = originalFormula.replace("convergeto(", "");
            target = target.replace(")", "");
        }
        return "if(isNumber(" + previousCellAddress + ");" + previousCellAddress + "+(" + target + "-" + previousCellAddress + ")/" + remainingPeriod + ";" + target + "/" + remainingPeriod + ")";
    }

    private static void evaluateVariableReplacers(Variable variable, Map<Long, List<CellError>> formulaErrors) {
        Object currentEvaluatedFormula = variable.getEvaluatedVariableFormula();
        for (Variable searchVariable : variable.getVariableDependencies()) {
            ArrayList<StringReplacer> replacers;
            int stringIndex;
            currentEvaluatedFormula = VariableEvaluator.checkForPredefinedModifiers(variable, (String)currentEvaluatedFormula, searchVariable);
            String searchString = LEFT_CURLY + searchVariable.getId() + "}[";
            do {
                if ((stringIndex = ((String)currentEvaluatedFormula).indexOf(searchString)) == -1) continue;
                int stringIndexMiddleStart = stringIndex + searchString.length() - 1;
                Object tempEvaluatedFormula = currentEvaluatedFormula;
                if (!((String)tempEvaluatedFormula).contains(RIGHT_BRACKET)) {
                    CellError e = new CellError(-1, "FormulaError", "Couldn't find terminating bracket for formula " + variable.getVariableFormula());
                    formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
                    break;
                }
                replacers = new ArrayList<StringReplacer>();
                int stringIndexStop = ((String)tempEvaluatedFormula).indexOf(RIGHT_BRACKET, stringIndex) + 1;
                String startString = ((String)tempEvaluatedFormula).substring(0, stringIndex);
                String middleString = ((String)tempEvaluatedFormula).substring(stringIndexMiddleStart, stringIndexStop);
                String endString = ((String)tempEvaluatedFormula).substring(stringIndexStop);
                Matcher m = PATTERN.matcher(middleString);
                while (m.find()) {
                    String tempModifierString = m.group();
                    int modifier = tempModifierString.equals("t") ? 0 : Integer.parseInt(tempModifierString.replace("t", ""));
                    StringReplacer replacer = new StringReplacer(tempModifierString, modifier);
                    replacers.add(replacer);
                }
                replacers.sort(StringReplacer.StringReplacerComparatorDesc);
                String middleStringBeforeReplacements = middleString;
                for (StringReplacer temp_replacer : replacers) {
                    middleString = middleString.replace(temp_replacer.searchString(), "");
                }
                middleString = middleString.replace(LEFT_BRACKET, "");
                middleString = middleString.replace(RIGHT_BRACKET, "");
                currentEvaluatedFormula = startString + middleString + endString;
                VariableReplacementOccurrence vro = new VariableReplacementOccurrence(searchVariable, LEFT_CURLY + searchVariable.getId() + RIGHT_CURLY.concat(middleStringBeforeReplacements), replacers);
                variable.getReplacementOccurrences().add(vro);
            } while (stringIndex != -1);
            searchString = LEFT_CURLY + searchVariable.getId() + RIGHT_CURLY;
            do {
                if ((stringIndex = ((String)currentEvaluatedFormula).indexOf(searchString)) == -1) continue;
                replacers = new ArrayList();
                StringReplacer replacer = new StringReplacer(searchString, null);
                replacers.add(replacer);
                VariableReplacementOccurrence vro = new VariableReplacementOccurrence(searchVariable, searchString, replacers);
                variable.getReplacementOccurrences().add(vro);
                currentEvaluatedFormula = ((String)currentEvaluatedFormula).replace(searchString, "");
            } while (stringIndex != -1);
        }
    }

    private static String checkForPredefinedModifiers(Variable variable, String currentEvaluatedFormula, Variable searchVariable) {
        for (String predefinedModifier : PREDEFINED_MODIFIERS) {
            String searchString = LEFT_CURLY + searchVariable.getId() + "}[" + predefinedModifier + RIGHT_BRACKET;
            if (!currentEvaluatedFormula.contains(searchString)) continue;
            StringReplacer replacer = new StringReplacer(predefinedModifier, null);
            VariableReplacementOccurrence vro = new VariableReplacementOccurrence(searchVariable, searchString, Collections.singletonList(replacer));
            variable.getReplacementOccurrences().add(vro);
            currentEvaluatedFormula = currentEvaluatedFormula.replace(searchString, "");
        }
        return currentEvaluatedFormula;
    }
}

