package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.records.CalculationData;
import app.valuationcontrol.multimodule.library.records.JSONRecords.JSONModelRecord;
import app.valuationcontrol.multimodule.library.xlhandler.POICalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import app.valuationcontrol.multimodule.library.xlhandler.XLInstance;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;

public class CloudRunnerHelpers {
    public static CalculationData performCalculation(JSONModelRecord jsonModelRecord){

        Model model = jsonModelRecord.getModel();

        //Create IDs as variable are not stored in database
        long id=1L;
        for(Variable variable : model.getVariables()){
            variable.setId(id);
            id=id+1;
        }

        //Evaluate variables
        for(Variable variable : model.getVariables()){
            variable.setEvaluatedVariableFormula(FormulaEvaluator.evaluateVariableFormula(variable));
        }

        POICalcDocument poiCalcDocument = new POICalcDocument();
        XLInstance xlInstance = new XLInstance(model,poiCalcDocument,false);

        return xlInstance.getContent(SCENARIO.BASE);
    }
}
