package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.entities.Model;
import java.util.Objects;

/**
 * @param myModel is the attached model
 * @param periodOffset is the current period being assessed (example : -1 for historical period and
 *     5 for projection period)
 * @param segmentOffsetFactor is the multiplier to be applied to segment offset length
 *     (model.getNumberOfPeriods)
 */
public record DataPeriod(
    Model myModel, Integer periodOffset, Integer segmentOffsetFactor, boolean isConstant,Integer ...triangleOffset) {

  public Integer getTotalOffsetAsInteger() {
    return Objects.requireNonNullElse(periodOffset, 0)
        + segmentOffsetFactor * myModel.getNumberOfPeriodsAndValue();
  }

  public Integer getColumn() {
    if (isConstant) {
      return this.myModel.getConstantColumn() + getSegmentOffsetAsInteger();
    } else {
      return this.myModel.getConstantColumn()
          + this.myModel.getNbHistoricalPeriod()
          + 1
          + getTotalOffsetAsInteger();
    }
  }

  public Integer getSegmentOffsetAsInteger() {
    return segmentOffsetFactor * myModel.getNumberOfPeriodsAndValue();
  }

  public Integer lowBound() {
    return -myModel.getNbHistoricalPeriod();
  }

  public Integer highBound() {
    return myModel.getNbProjectionPeriod() - 1;
  }

  public boolean isWithinBound(Integer periodToCheck) {
    return periodToCheck >= lowBound() && periodToCheck <= highBound();
  }

  public DataPeriod previousPeriod() {
    return new DataPeriod(this.myModel, periodOffset - 1, this.segmentOffsetFactor, isConstant,this.triangleOffset);
  }
}
