package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.constraints.EvenParenthesis;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class ParenthesisValidatorImpl implements ConstraintValidator<EvenParenthesis, String> {
  private static final Pattern LEFT_PARENTHESIS = Pattern.compile("\\(");
  private static final Pattern RIGHT_PARENTHESIS = Pattern.compile("\\)");

  @Override
  public boolean isValid(String value, ConstraintValidatorContext context) {
    if (value == null) {
      return false;
    }

    return BracketsValidatorImpl.count(value, LEFT_PARENTHESIS)
        == BracketsValidatorImpl.count(value, RIGHT_PARENTHESIS);
  }
}
