package app.valuationcontrol.multimodule.library.helpers.openai;

import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.Getter;
import lombok.extern.log4j.Log4j2;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Log4j2
@Component
@Getter
public class OpenAiServiceImplementation {
  private final ChatClient chatClient;

  @Autowired
  public OpenAiServiceImplementation(ChatClient.Builder chatClientBuilder) { //Defined in ressources
      this.chatClient = chatClientBuilder.build();
  }

  public ChatClient.CallResponseSpec getChatRequest(
          Prompt prompt,Object toolObject) {

    if(toolObject!=null){
      return chatClient.prompt(prompt)
              .tools(toolObject).call();
    }

    return chatClient.prompt(prompt).call();

  }

  public JsonNode doRequest(
          Prompt messages,
          Object tool) {

    try{
      ChatClient.CallResponseSpec chatCompletionRequest=getChatRequest(messages,tool);
      ObjectMapper objectMapper = new ObjectMapper();
      String chatResponse = chatCompletionRequest.content();

      if(chatResponse != null && !chatResponse.isEmpty()){
        if (tool != null) {
          return objectMapper.readTree(chatResponse);
        } else {
              ObjectNode _rootNode = objectMapper.createObjectNode();
              _rootNode.put("response", chatResponse);
              return _rootNode;
        }
      }else {
        throw new ResourceException(
                HttpStatus.BAD_REQUEST, "Couldn't parse empty response OpenAI");
      }
    } catch (Exception e) {
      log.debug(e);
      throw new ResourceException(HttpStatus.GATEWAY_TIMEOUT, "the OPen AI server did not respond");
    }

  }


}
