package app.valuationcontrol.multimodule.library.records.JSONRecords;


import app.valuationcontrol.multimodule.library.entities.*;
import app.valuationcontrol.multimodule.library.helpers.FormulaEvaluator;
import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import app.valuationcontrol.multimodule.library.records.ModelData;
import app.valuationcontrol.multimodule.library.records.SegmentData;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.HttpStatus;

import java.util.Calendar;
@Log4j2
public record JSONModelRecord(String name, int nbHistoricalPeriod, int nbForecastPeriod, int startYear, JSONArea[] areas, JSONVariable[] variables,JSONVariableValue[] variableValues,JSONSegment[] segments) {

    public Model getModel(){
        String modelName = this.name();
        int startYear;
        int nbForecastPeriod;
        int nbHistoricalPeriod;


        try{
            startYear = this.startYear();
        } catch (Exception e) {
            startYear = 0;
        }

        if(startYear == 0)startYear= Calendar.getInstance().get(Calendar.YEAR);

        try{
            nbForecastPeriod = this.nbForecastPeriod();
        } catch (Exception e) {
            nbForecastPeriod = 5;
        }

        try{
            nbHistoricalPeriod = this.nbHistoricalPeriod();
        } catch (Exception e) {
            nbHistoricalPeriod = 3;
        }


        modelName =  modelName != null ? modelName : "Default model";

        ModelData modelData =
                new ModelData(
                        -1L,
                        modelName,
                        startYear,
                        nbHistoricalPeriod,
                        nbForecastPeriod,
                        "Company Number",
                        "Company ID",
                        "CU",
                        "",
                        false,
                        false,
                        null);

        Model model = new Model(modelData); //TODO: Implement segment/sensitivities/keyParams in JSONModel

        //Creating areas and subareas
        int areaOrder=0;
        for (JSONArea areaObject : this.areas()){
            Area area = new Area(model,areaObject.name(),"",areaOrder);
            int subAreaOrder=0;
            for(JSONSubArea jsonSubArea : areaObject.subAreas()){
                SubArea subArea = new SubArea();
                subArea.setAttachedArea(area);
                subArea.setSubAreaName(jsonSubArea.name());
                subArea.setSubAreaDescription(jsonSubArea.description());
                subArea.setModelledAtSegment(jsonSubArea.modelledAtSegment());
                subArea.setSubAreaOrder(subAreaOrder);
                area.getSubAreas().add(subArea);
                subAreaOrder =  subAreaOrder+1;
            }
            areaOrder =  areaOrder+1;
            model.getAreas().add(area);
        }

        //Creating variables
        int variableOrder=0;
        for(JSONVariable jsonVariable : this.variables()){
            Variable variable = new Variable();
            variable.setAttachedModel(model);
            variable.setVariableName(jsonVariable.name());
            variable.setVariableFormula(jsonVariable.formula()!=null && !jsonVariable.formula().isBlank()?jsonVariable.formula():"0");
            String variableType = switch (jsonVariable.variableType()) {
                case "Input" -> "input";
                case "Total" -> "total_row";
                case "Check" -> "check";
                case "Constant" -> "constant";
                case "Single Result" -> "single_result";
                default -> "calc";
            };
            variable.setVariableType(variableType);
            variable.setVariableDescription(jsonVariable.description());
            SubArea subArea;
            try{
                subArea = model.getAreas().stream().flatMap(
                        area -> area.getSubAreas().stream().filter(subArea1 -> subArea1.getSubAreaName().equals(jsonVariable.subArea()))
                ).findFirst().orElseThrow();
            } catch (Exception e) {
                log.info("Couldn't FIND SUBAREA,{}",jsonVariable.subArea());
                throw new RuntimeException(e);
            }

            variable.setVariableSubArea(subArea);
            variable.setVariableArea(subArea.getAttachedArea());
            variable.setVariableOrder(variableOrder);
            if (jsonVariable.name().contains("percent")) {
                variable.setVariableFormat("percent");
            }else if (jsonVariable.name().contains("total")) {
                variable.setVariableFormat("total");
            } else {
                variable.setVariableFormat("decimal");
            }
            variableOrder=variableOrder+1;

            log.info("Variable {}, Area {}, Subarea {}",variable.getVariableName(),subArea.getAttachedArea().getAreaName(),subArea.getSubAreaName());
            model.getVariables().add(variable);
        }
        log.debug("All variables loaded");

        if(this.segments!=null){
            for(JSONSegment jsonSegment : this.segments){
                SegmentData segmentData = new SegmentData(-1L, jsonSegment.name(), jsonSegment.currency());
                Segment segment = new Segment(segmentData,model);
                model.getSegments().add(segment);
            }
        }


        if(this.variableValues!=null){
            //Creating variableValues
            for(JSONVariableValue jsonVariableValue:this.variableValues){
                Variable variable = model.getVariables().stream().filter(v-> v.getVariableName().equalsIgnoreCase(jsonVariableValue.variableName())).findFirst()
                        .orElseThrow(()->new ResourceException(HttpStatus.BAD_REQUEST,"Couldnt find a matching variable for {}"));

                VariableValue variableValue = new VariableValue();
                variableValue.setAttachedVariable(variable);
                variableValue.setValue(jsonVariableValue.value());
                variableValue.setScenarioNumber(jsonVariableValue.scenario());
                variableValue.setPeriod(jsonVariableValue.period());
                variableValue.setAttachedSegment(null); //TODO: Implement segment in JSONModel
                variableValue.setEditor("");
                variableValue.setSourceFile("Json Import");
                variable.getVariableValues().add(variableValue);
            }
        }
        return model;
    }

}
