package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.entities.Area;
import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.helpers.DataPeriod;

import java.util.Arrays;

public class CellValueHelper {
  public static final int AZ_COUNTER = 26;

  public static GenericSheet.CellValue cellValueOf(VariableValue variableValue) {

    Variable variable = variableValue.getAttachedVariable();

    var columnIndex =
        variable.columnOfSegmentAndPeriod(
            variableValue.getAttachedSegment(), variableValue.getPeriod());

    return new GenericSheet.CellValue(variableValue.getValue(), columnIndex, variable.getRow());
  }



  public static String getAreaSheetNameWithQuotes(Area area) {
    Model attachedModel = area.getAttachedModel();
    return "'" + attachedModel.getAreaStringHashMap().get(area) + "'";
  }


  public static String getExcelColumn(int columnToAssess){
    String column;
    String prefix= "";
    int multiplier = columnToAssess / AZ_COUNTER;
    int rest = columnToAssess % AZ_COUNTER;

    // Defining column prefix AA
    if (multiplier >= 1) {
      prefix = Character.toString((char) (65 + multiplier - 1));
    }
    column = prefix + (char) (65 + rest);
    return column;
  }

  /**
   * Returns the A1 address of the formula
   *
   * @param dataPeriod indicates which dataperiod we should generate address for
   * @return the generated address as a String
   */
  public static String generateAddress(Variable variable, DataPeriod dataPeriod) {
    int columnToAssess;
    String returnString;

    //Getting column
    if (variable.isSingleOrConstantValue()) {
      columnToAssess =
              (variable.getAttachedModel().getConstantColumn())
                      + dataPeriod.getSegmentOffsetAsInteger();
    } else {
      columnToAssess = variable.getPrimaryColumn() + dataPeriod.getTotalOffsetAsInteger();
    }
    String column=getExcelColumn(columnToAssess);

    int triangleOffset=0;
    if(variable.isTriangle()){
      triangleOffset = Arrays.stream(dataPeriod.triangleOffset()).findFirst().orElse(0);
    }

    //Getting row
    int rowToAssess = 1 + variable.getRow()+triangleOffset; // Checks whether the variable should use area

    if (variable.isSingleOrConstantValue()) {
      returnString = "$" + column + "$" + rowToAssess;
    } else {
      returnString = column + rowToAssess;
    }

    //Checking whether we should use an area as tab name
    if (variable.getAttachedModel().getUseAreaAddress()) {
      returnString = getAreaSheetNameWithQuotes(variable.getVariableArea()) + "!" + returnString;
    }

    return returnString;

  }
}
