/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.SubArea;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.EntityDTOConverter;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import app.valuationcontrol.multimodule.library.records.AreaData;
import app.valuationcontrol.multimodule.library.records.SubAreaData;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"attached_model_id", "area_name"})})
public class Area
implements DataTransformer<AreaData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Model attachedModel;
    @Column(name="area_name")
    private String areaName;
    @Column(name="area_description")
    private String areaDescription;
    @Column(name="area_order")
    private Integer areaOrder;
    @OneToMany(mappedBy="attachedArea", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="subAreaOrder ASC")
    private List<SubArea> subAreas = new ArrayList<SubArea>();

    public Area(AreaData areaData, Model model) {
        this.updateFrom(areaData);
        this.attachedModel = model;
        this.setAreaOrder(model.getAreas().size() + 1);
    }

    public Area(Model attachedModel, String areaName, String description, Integer order) {
        this.attachedModel = attachedModel;
        this.areaName = areaName;
        this.areaDescription = description;
        this.areaOrder = order;
    }

    public Area(Area existingArea) {
        this.attachedModel = existingArea.getAttachedModel();
        this.areaName = existingArea.getAreaName();
        this.areaDescription = existingArea.getAreaDescription();
        this.areaOrder = existingArea.getAreaOrder();
        this.subAreas = existingArea.getSubAreas();
    }

    @Override
    public AreaData asData() {
        List<SubAreaData> subAreaData = EntityDTOConverter.asData(this.subAreas);
        return new AreaData(this.id, this.areaName, this.areaDescription, this.areaOrder, subAreaData);
    }

    @Override
    public Long getModelId() {
        return this.attachedModel.getId();
    }

    public void updateFrom(AreaData areaData) {
        this.areaName = areaData.areaName();
        this.areaDescription = areaData.areaDescription();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public Model getAttachedModel() {
        return this.attachedModel;
    }

    @Generated
    public String getAreaName() {
        return this.areaName;
    }

    @Generated
    public String getAreaDescription() {
        return this.areaDescription;
    }

    @Generated
    public Integer getAreaOrder() {
        return this.areaOrder;
    }

    @Generated
    public List<SubArea> getSubAreas() {
        return this.subAreas;
    }

    @Generated
    public Area() {
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    @Generated
    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    @Generated
    public void setAreaDescription(String areaDescription) {
        this.areaDescription = areaDescription;
    }

    @Generated
    public void setAreaOrder(Integer areaOrder) {
        this.areaOrder = areaOrder;
    }
}

